/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import java.awt.Color;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.LibraryAttribute;
import ptolemy.vergil.actor.ActorGraphFrame;

public class ActorGraphTableau
extends Tableau {
    private static Color BACKGROUND_COLOR = new Color(0xE5E5E5);

    public ActorGraphTableau(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
    }

    public ActorGraphTableau(PtolemyEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        this(container, name, null);
    }

    public ActorGraphTableau(PtolemyEffigy container, String name, LibraryAttribute defaultLibrary) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        NamedObj model = container.getModel();
        if (model == null) {
            return;
        }
        if (!(model instanceof CompositeEntity)) {
            throw new IllegalActionException((Nameable)this, "Cannot graphically edit a model that is not a CompositeEntity. Model is a " + model);
        }
        CompositeEntity entity = (CompositeEntity)model;
        ActorGraphFrame frame = new ActorGraphFrame(entity, (Tableau)this, defaultLibrary);
        this.setFrame(frame);
        frame.setBackground(BACKGROUND_COLOR);
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof PtolemyEffigy) {
                ActorGraphTableau tableau = (ActorGraphTableau)effigy.getEntity("graphTableau");
                if (tableau == null) {
                    LibraryAttribute library = (LibraryAttribute)this.getAttribute("_library", LibraryAttribute.class);
                    tableau = new ActorGraphTableau((PtolemyEffigy)effigy, "graphTableau", library);
                }
                return tableau;
            }
            return null;
        }
    }
}

