/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.MoMLApplication;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.actor.gui.UserActorLibrary;
import ptolemy.data.expr.Parameter;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.ErrorHandler;
import ptolemy.moml.MoMLParser;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.VergilErrorHandler;

public class VergilApplication
extends MoMLApplication {
    protected static String[][] _commandOptions = new String[][]{{"-configuration", "<configuration URL, defaults to ptolemy/configs/full/configuration.xml>"}};
    private String _configurationSubdirectory;
    private URL _configurationURL;
    private boolean _expectingConfiguration = false;

    public VergilApplication(String[] args) throws Exception {
        super("ptolemy/configs", args);
        MoMLParser.setErrorHandler((ErrorHandler)new VergilErrorHandler());
    }

    public VergilApplication(String basePath, String[] args) throws Exception {
        super(basePath, args);
        MoMLParser.setErrorHandler((ErrorHandler)new VergilErrorHandler());
    }

    public static void main(final String[] args) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        new VergilApplication(args);
                    }
                    catch (Throwable throwable) {
                        VergilApplication._errorAndExit("Command failed", args, throwable);
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            VergilApplication._errorAndExit("Command failed", args, throwable2);
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            System.exit(0);
        }
    }

    public static void openLibrary(Configuration configuration, File file) throws Exception {
        MoMLParser.setErrorHandler((ErrorHandler)new VergilErrorHandler());
        UserActorLibrary.openLibrary(configuration, file);
    }

    protected Configuration _createDefaultConfiguration() throws Exception {
        try {
            if (this._configurationURL == null) {
                this._configurationURL = VergilApplication.specToURL(String.valueOf(this._basePath) + "/full/configuration.xml");
            }
        }
        catch (IOException ex) {
            try {
                this._configurationURL = VergilApplication.specToURL(String.valueOf(this._basePath) + "/hyvisual/configuration.xml");
            }
            catch (IOException iOException) {
                throw ex;
            }
        }
        Configuration configuration = super._createDefaultConfiguration();
        try {
            configuration = VergilApplication.readConfiguration(this._configurationURL);
        }
        catch (Exception ex) {
            throw new Exception("Failed to read configuration '" + this._configurationURL + "'", ex);
        }
        PtolemyPreferences.setDefaultPreferences(configuration);
        Parameter hideUserLibraryAttribute = (Parameter)configuration.getAttribute("_hideUserLibrary", Parameter.class);
        if (hideUserLibraryAttribute == null || hideUserLibraryAttribute.getExpression().equals("false")) {
            try {
                MoMLParser.setErrorHandler((ErrorHandler)new VergilErrorHandler());
                UserActorLibrary.openUserLibrary(configuration);
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Failed to display user library.", (Throwable)ex);
            }
        }
        return configuration;
    }

    protected Configuration _createEmptyConfiguration() throws Exception {
        Configuration configuration = this._createDefaultConfiguration();
        URL welcomeURL = null;
        URL introURL = null;
        ModelDirectory directory = configuration.getDirectory();
        Parameter applicationBlankPtolemyEffigyAtStartup = (Parameter)configuration.getAttribute("_applicationBlankPtolemyEffigyAtStartup", Parameter.class);
        if (applicationBlankPtolemyEffigyAtStartup != null && applicationBlankPtolemyEffigyAtStartup.getExpression().equals("true")) {
            PtolemyEffigy.Factory factory = new PtolemyEffigy.Factory(directory, directory.uniqueName("ptolemyEffigy"));
            Effigy effigy = factory.createEffigy(directory, null, null);
            configuration.createPrimaryTableau(effigy);
        }
        try {
            String configurationURLString = this._configurationURL.toExternalForm();
            String base = configurationURLString.substring(0, configurationURLString.lastIndexOf("/"));
            welcomeURL = VergilApplication.specToURL(String.valueOf(base) + "/welcomeWindow.xml");
            introURL = VergilApplication.specToURL(String.valueOf(base) + "/intro.htm");
            this._parser.reset();
            this._parser.setContext((NamedObj)configuration);
            this._parser.parse(welcomeURL, welcomeURL);
        }
        catch (Throwable throwable) {
            if (this._configurationSubdirectory == null) {
                this._configurationSubdirectory = "full";
            }
            welcomeURL = VergilApplication.specToURL(String.valueOf(this._basePath) + "/" + this._configurationSubdirectory + "/welcomeWindow.xml");
            introURL = VergilApplication.specToURL(String.valueOf(this._basePath) + "/" + this._configurationSubdirectory + "/intro.htm");
            this._parser.reset();
            this._parser.setContext((NamedObj)configuration);
            this._parser.parse(welcomeURL, welcomeURL);
        }
        Effigy doc = (Effigy)configuration.getEntity("directory.doc");
        doc.identifier.setExpression(introURL.toExternalForm());
        return configuration;
    }

    protected void _parseArgs(String[] args) throws Exception {
        this._commandTemplate = "vergil [ options ] [file ...]";
        LinkedList<String> processedArgsList = new LinkedList<String>();
        int i = 0;
        while (i < args.length) {
            if (!this._configurationParseArg(args[i])) {
                processedArgsList.add(args[i]);
            }
            ++i;
        }
        if (this._expectingConfiguration) {
            throw new IllegalActionException("Missing configuration");
        }
        String[] processedArgs = processedArgsList.toArray(new String[processedArgsList.size()]);
        super._parseArgs(processedArgs);
    }

    protected String _usage() {
        return this._configurationUsage(this._commandTemplate, _commandOptions, new String[0]);
    }

    private boolean _configurationParseArg(String arg) throws Exception {
        if (arg.startsWith("-conf")) {
            this._expectingConfiguration = true;
        } else if (arg.startsWith("-")) {
            try {
                this._configurationSubdirectory = arg.substring(1);
                String potentialConfiguration = String.valueOf(this._basePath) + "/" + this._configurationSubdirectory + "/configuration.xml";
                this._configurationURL = VergilApplication.specToURL(potentialConfiguration);
            }
            catch (Throwable throwable) {
                return false;
            }
        } else if (this._expectingConfiguration) {
            this._expectingConfiguration = false;
            this._configurationURL = VergilApplication.specToURL(arg);
        } else {
            return false;
        }
        return true;
    }

    private static void _errorAndExit(String message, String[] args, Throwable throwable) {
        StringBuffer argsBuffer = new StringBuffer("Command failed");
        if (args.length > 0) {
            argsBuffer.append("\nArguments: " + args[0]);
            int i = 1;
            while (i < args.length) {
                argsBuffer.append(" " + args[i]);
                ++i;
            }
            argsBuffer.append("\n");
        }
        System.out.println(argsBuffer.toString());
        throwable.printStackTrace();
        MessageHandler.setMessageHandler((MessageHandler)new GraphicalMessageHandler());
        MessageHandler.error((String)argsBuffer.toString(), (Throwable)throwable);
        System.exit(0);
    }
}

