/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil;

import ptolemy.actor.Manager;
import ptolemy.actor.TypeEvent;
import ptolemy.actor.TypeListener;
import ptolemy.actor.TypedIOPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Configurable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.MoMLViewerApplet;

public class TypeAnimatorApplet
extends MoMLViewerApplet {
    public void managerStateChanged(Manager manager) {
        super.managerStateChanged(manager);
        if (manager.getState() == Manager.INITIALIZING) {
            this._updateAllTypeDisplays();
        }
    }

    public void start() {
        this._updateAllTypeDisplays();
    }

    protected NamedObj _createModel(Workspace workspace) throws Exception {
        this._toplevel = super._createModel(workspace);
        if (this._toplevel instanceof CompositeEntity) {
            CompositeEntity toplevel = (CompositeEntity)this._toplevel;
            PortTypeListener typeListener = new PortTypeListener();
            for (Entity entity : toplevel.entityList()) {
                for (TypedIOPort port : entity.portList()) {
                    port.addTypeListener((TypeListener)typeListener);
                }
            }
        }
        return this._toplevel;
    }

    private void _updateAllTypeDisplays() {
        if (this._toplevel instanceof CompositeEntity) {
            CompositeEntity toplevel = (CompositeEntity)this._toplevel;
            for (Entity entity : toplevel.entityList()) {
                for (TypedIOPort port : entity.portList()) {
                    this._updateTypeDisplay(port);
                }
            }
        }
    }

    private void _updateTypeDisplay(TypedIOPort port) {
        Configurable config;
        String portName = port.getName(this._toplevel);
        String labelName = portName.replace('.', '_');
        Attribute label = this._toplevel.getAttribute(labelName);
        if (label != null && (config = (Configurable)label.getAttribute("_iconDescription")) != null) {
            String moml = "<property name=\"_iconDescription\" class=\"ptolemy.kernel.util.SingletonConfigurableAttribute\"><configure><svg><text x=\"20\" style=\"font-size:14; font-family:sanserif; fill:red\" y=\"20\">" + port.getType() + "</text></svg></configure></property>";
            label.requestChange((ChangeRequest)new MoMLChangeRequest((Object)this, (NamedObj)label, moml));
        }
    }

    private class PortTypeListener
    implements TypeListener {
        private PortTypeListener() {
        }

        public void typeChanged(TypeEvent event) {
            TypedIOPort port = (TypedIOPort)event.getSource();
            TypeAnimatorApplet.this._updateTypeDisplay(port);
        }
    }
}

