/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil;

import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.JGraph;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.MoMLApplet;
import ptolemy.actor.gui.MoMLApplication;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.actor.ActorViewerGraphController;
import ptolemy.vergil.basic.RunnableGraphController;
import ptolemy.vergil.fsm.FSMGraphController;
import ptolemy.vergil.fsm.FSMGraphModel;

public class MoMLViewerApplet
extends MoMLApplet {
    private Configuration _configuration;

    public String[][] getParameterInfo() {
        String[][] newinfo = new String[][]{{"includeRunPanel", "", "Indicator to include run panel"}, {"configuration", "", "Ptolemy II configuration"}};
        return this._concatStringArrays(super.getParameterInfo(), newinfo);
    }

    public void start() {
    }

    protected NamedObj _createModel(Workspace workspace) throws Exception {
        return this._createModel(workspace, false);
    }

    protected void _createView() {
        RunnableGraphController controller;
        if (!(this._toplevel instanceof CompositeEntity)) {
            return;
        }
        String configurationPath = this.getParameter("configuration");
        if (configurationPath != null) {
            try {
                URL specificationURL = MoMLApplication.specToURL(configurationPath);
                this._configuration = MoMLApplication.readConfiguration(specificationURL);
                this.report("Opened '" + specificationURL + "': " + (Object)((Object)this._configuration));
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to open '" + configurationPath + "':", ex);
            }
        }
        GraphPane pane = null;
        if (this._toplevel instanceof FSMActor) {
            controller = new FSMGraphController();
            FSMGraphModel graphModel = new FSMGraphModel((CompositeEntity)((FSMActor)this._toplevel));
            if (this._configuration != null) {
                ((FSMGraphController)controller).setConfiguration(this._configuration);
            }
            pane = new GraphPane((GraphController)controller, (GraphModel)graphModel);
        } else {
            controller = new ActorViewerGraphController();
            ((ActorViewerGraphController)controller).setConfiguration(this._configuration);
            ActorGraphModel model = new ActorGraphModel(this._toplevel);
            pane = new GraphPane((GraphController)controller, (GraphModel)model);
        }
        JGraph modelViewer = new JGraph(pane);
        boolean boundsSet = false;
        try {
            SizeAttribute vergilBounds = (SizeAttribute)this._toplevel.getAttribute("_vergilSize", SizeAttribute.class);
            boundsSet = vergilBounds.setSize((Component)modelViewer);
        }
        catch (Throwable throwable) {}
        if (!boundsSet) {
            Dimension size = new Dimension(400, 300);
            modelViewer.setMinimumSize(size);
            modelViewer.setPreferredSize(size);
        }
        modelViewer.setBackground(this.getBackground());
        this.getContentPane().add((Component)modelViewer, "North");
        String panelFlag = this.getParameter("includeRunPanel");
        if (panelFlag != null && panelFlag.trim().toLowerCase().equals("true")) {
            super._createView();
        }
    }
}

