/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFrame;
import ptolemy.util.StringUtilities;

public class PlotApplication
extends PlotFrame {
    protected static boolean _test = false;

    public PlotApplication() throws Exception {
        this(new String[0]);
    }

    public PlotApplication(String[] args) throws Exception {
        this(new Plot(), args);
    }

    public PlotApplication(PlotBox plot, String[] args) throws Exception {
        super("PlotApplication", plot);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this._parseArgs(args);
        if (args == null || args.length == 0) {
            this.samplePlot();
        }
        this.setVisible(true);
    }

    public PlotApplication(PlotBox plot) {
        super("PlotApplication", plot);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setVisible(true);
    }

    public static void main(final String[] args) {
        try {
            Runnable doActions = new Runnable(){

                public void run() {
                    try {
                        new PlotApplication(new Plot(), args);
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                        ex.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeAndWait(doActions);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            System.exit(0);
        }
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "PlotApplication class\nBy: Edward A. Lee and Christopher Brooks\nVersion 5.7, Build: $Id: PlotApplication.java,v 1.69.4.1 2008/04/04 20:01:01 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-2008, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _close() {
        StringUtilities.exit((int)0);
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotApplication is a standalone plot  application.\n  File formats understood: Ptplot ASCII.\n  Left mouse button: Zooming.\n\n" + this._usage(), "About Ptolemy Plot", 1);
    }

    protected int _parseArgs(String[] args) throws CmdLineArgException, FileNotFoundException, IOException {
        int i = 0;
        String title = "Ptolemy plot";
        int width = 500;
        int height = 300;
        while (args != null && i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("-height")) {
                if (i > args.length - 1) {
                    throw new CmdLineArgException(this._usage());
                }
                height = Integer.valueOf(args[i++]);
                continue;
            }
            if (arg.equals("-help")) {
                System.out.println(this._usage());
                StringUtilities.exit((int)0);
                continue;
            }
            if (arg.equals("-test")) {
                _test = true;
                continue;
            }
            if (arg.equals("-version")) {
                System.out.println("Version 5.7, Build $Id: PlotApplication.java,v 1.69.4.1 2008/04/04 20:01:01 cxh Exp $");
                StringUtilities.exit((int)0);
                continue;
            }
            if (arg.equals("-width")) {
                if (i > args.length - 1) {
                    throw new CmdLineArgException("-width requires an integer argument");
                }
                width = Integer.valueOf(args[i++]);
                continue;
            }
            if (arg.equals("")) continue;
            if (arg.equals("-")) {
                URL base = new URL("file", null, "standard input");
                this._read(base, System.in);
                continue;
            }
            if (!arg.startsWith("-")) {
                InputStream instream;
                URL base;
                try {
                    URL inurl;
                    base = inurl = new URL(null, arg);
                    instream = inurl.openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(arg);
                    instream = new FileInputStream(file);
                    this._file = new File(file.getAbsolutePath());
                    title = this._file.getName();
                    this._directory = this._file.getParentFile();
                    base = new URL("file", null, this._directory.getAbsolutePath());
                }
                this._read(base, instream);
                continue;
            }
            throw new CmdLineArgException("Unrecognized option: " + arg);
        }
        this.setSize(width, height);
        this.setTitle(title);
        int argumentsRead = i;
        return argumentsRead;
    }

    protected String _usage() {
        String[][] commandOptions = new String[][]{{"-height", "<pixels>"}, {"-width", "<pixels>"}};
        String[] commandFlags = new String[]{"-help", "-test", "-version", "-"};
        StringBuffer result = new StringBuffer("Usage: ptplot [ options ] [file ...]\n\nOptions that take values:\n");
        int i = 0;
        while (i < commandOptions.length) {
            result.append(" " + commandOptions[i][0] + " " + commandOptions[i][1] + "\n");
            ++i;
        }
        result.append("\nBoolean flags:\n");
        i = 0;
        while (i < commandFlags.length) {
            result.append(" " + commandFlags[i]);
            ++i;
        }
        return result.toString();
    }
}

