/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.swing.JApplet;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.util.MessageHandler;

public class BasicJApplet
extends JApplet {
    protected Color _background;

    public String getAppletInfo() {
        return "Ptolemy II swing-based applet.\nPtolemy II comes from UC Berkeley, Department of EECS.\nSee http://ptolemy.eecs.berkeley.edu/ptolemyII";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"background", "#RRGGBB", "color of the background"}};
        return pinfo;
    }

    public void init() {
        GraphicalMessageHandler.setContext(this);
        MessageHandler.setMessageHandler((MessageHandler)new GraphicalMessageHandler());
        this._background = null;
        try {
            String colorSpecification = this.getParameter("background");
            if (colorSpecification != null) {
                this._background = Color.decode(colorSpecification);
            }
        }
        catch (Exception ex) {
            this.report("Warning: background parameter failed: ", ex);
        }
        this.setBackground(this._background);
        this.getRootPane().setBackground(this._background);
        this.getContentPane().setBackground(this._background);
    }

    public void report(Throwable throwable) {
        this.report(String.valueOf(MessageHandler.shortDescription((Throwable)throwable)) + " thrown by applet.", throwable);
    }

    public void report(String message) {
        try {
            this.showStatus(message);
        }
        catch (Throwable throwable) {
            System.err.println("showStatus() threw a NullPointerException\nThis can happen if the Applet has already exited\n because of an error or exception.\n");
            throwable.printStackTrace();
        }
    }

    public void report(String message, Throwable throwable) {
        throwable.printStackTrace();
        MessageHandler.error((String)message, (Throwable)throwable);
        try {
            this.showStatus("exception occurred.");
        }
        catch (Throwable throwable2) {
            System.err.println("showStatus() threw an exception\n" + this._stackTraceToString(throwable2) + "This can happen if the Applet has already exited\n " + "because of an error or exception.\n" + "The original error or exception was:\n" + this._stackTraceToString(throwable));
        }
    }

    protected String[][] _concatStringArrays(String[][] first, String[][] second) {
        String[][] newInfo = new String[first.length + second.length][];
        System.arraycopy(first, 0, newInfo, 0, first.length);
        System.arraycopy(second, 0, newInfo, first.length, second.length);
        return newInfo;
    }

    protected Color _getBackground() {
        return this._background;
    }

    protected String _stackTraceToString(Throwable throwable) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(stream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stream.toString();
    }
}

