/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui.unit;

import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.interactor.BasicSelectionRenderer;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionEvent;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionListener;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.interactor.SelectionRenderer;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.GraphUtilities;
import diva.graph.JGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.PtolemyDialog;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.unit.BasicEdgeHighlighter;
import ptolemy.data.unit.Solution;
import ptolemy.data.unit.UnitConstraints;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.BasicGraphFrame;

public class UnitSolverDialog
extends PtolemyDialog
implements ActionListener,
ListSelectionListener,
SelectionListener {
    GraphController _controller = null;
    SelectionRenderer _defaultSelectionRenderer = null;
    Vector _entities = null;
    JLabel _fullSolutionResult = new JLabel("Not Run");
    JButton _setToSelectedButton = new JButton("Set To Selected");
    JButton _showComponentsButton = new JButton("Show Components");
    TypedCompositeActor _model = null;
    SelectionModel _selectionModel = null;
    AbstractBasicGraphModel _graphModel = null;
    Vector _relations = null;
    SelectionInteractor _selectionInteractor = null;
    Vector _solutions = new Vector();
    JList _solutionsList = null;
    SolutionListModel _solutionsListModel = null;
    JButton _runMinimalSpanSolverButton = new JButton("Run");
    JButton _runFullSolverButton = new JButton("Run");
    Tableau _tableau = null;
    UnitConstraints _uConstraints = null;

    public UnitSolverDialog(DialogTableau dialogTableau, Frame owner, Entity target, Configuration configuration) {
        super("Solve units for " + target.getName(), dialogTableau, owner, target, configuration);
        BasicSelectionRenderer tempSelectionRenderer = null;
        this._tableau = ((TableauFrame)owner).getTableau();
        this._model = (TypedCompositeActor)target;
        BasicGraphFrame parent = (BasicGraphFrame)this._tableau.getFrame();
        JGraph jGraph = parent.getJGraph();
        GraphPane graphPane = jGraph.getGraphPane();
        this._controller = graphPane.getGraphController();
        this._selectionModel = this._controller.getSelectionModel();
        Interactor interactor = this._controller.getEdgeController(new Object()).getEdgeInteractor();
        this._graphModel = (AbstractBasicGraphModel)this._controller.getGraphModel();
        this._selectionInteractor = (SelectionInteractor)interactor;
        this._defaultSelectionRenderer = this._selectionInteractor.getSelectionRenderer();
        tempSelectionRenderer = new BasicSelectionRenderer((FigureDecorator)new BasicEdgeHighlighter());
        if (this._model == this.getTarget()) {
            this._entities = this._getSelectedNodes();
            this._relations = this._getSelectedRelations();
            if (this._entities.isEmpty() && this._relations.isEmpty()) {
                this._entities = new Vector(this._model.entityList(ComponentEntity.class));
                this._relations = new Vector(this._model.relationList());
            }
        } else {
            this._entities = new Vector();
            this._entities.add(this.getTarget());
            this._relations = new Vector();
        }
        this._selectionModel.clearSelection();
        this._selectionInteractor.setSelectionRenderer((SelectionRenderer)tempSelectionRenderer);
        this._showComponents();
        this._selectionModel.addSelectionListener((SelectionListener)this);
        JPanel fullSolverPanel = new JPanel();
        fullSolverPanel.setLayout(new BoxLayout(fullSolverPanel, 1));
        fullSolverPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Full Solution"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this._runFullSolverButton.addActionListener(this);
        fullSolverPanel.add(this._runFullSolverButton);
        this._fullSolutionResult.setOpaque(true);
        this._fullSolutionResult.setBackground(Color.white);
        fullSolverPanel.add(this._fullSolutionResult);
        JPanel componentsPanel = new JPanel();
        componentsPanel.setLayout(new BoxLayout(componentsPanel, 1));
        componentsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Components"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this._setToSelectedButton.setEnabled(false);
        componentsPanel.add(this._setToSelectedButton);
        this._setToSelectedButton.addActionListener(this);
        componentsPanel.add(this._showComponentsButton);
        this._showComponentsButton.addActionListener(this);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(fullSolverPanel);
        topPanel.add(componentsPanel);
        JPanel minimalSpanPanel = new JPanel(new BorderLayout());
        minimalSpanPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Minimal Spanning Solutions"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        minimalSpanPanel.add((Component)this._runMinimalSpanSolverButton, "North");
        this._runMinimalSpanSolverButton.addActionListener(this);
        this._solutionsListModel = new SolutionListModel();
        this._solutionsList = new JList(this._solutionsListModel);
        this._solutionsList.setSelectionMode(0);
        this._solutionsList.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this._solutionsList);
        minimalSpanPanel.add((Component)scrollPane, "Center");
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BoxLayout(mainPane, 1));
        mainPane.add(topPanel);
        mainPane.add(minimalSpanPanel);
        this.setContents(mainPane);
    }

    public void actionPerformed(ActionEvent aEvent) {
        if (aEvent.getSource() == this._runMinimalSpanSolverButton) {
            try {
                this._uConstraints = new UnitConstraints(this._model, this._entities, this._relations);
                this._solutions = this._uConstraints.minimalSpanSolutions();
            }
            catch (IllegalActionException e) {
                MessageHandler.error((String)"Minimal Span Solver failed: ", (Throwable)e);
                return;
            }
            this._solutionsListModel.setSolutions(this._solutions);
            this._solutionsList.setModel(this._solutionsListModel);
        } else if (aEvent.getSource() == this._runFullSolverButton) {
            this._solutionsList.clearSelection();
            try {
                this._uConstraints = new UnitConstraints(this._model, this._entities, this._relations);
                Solution solution = this._uConstraints.completeSolution();
                this._fullSolutionResult.setText(solution.getShortStateDesc());
            }
            catch (IllegalActionException e) {
                MessageHandler.error((String)"Full Solver failed: ", (Throwable)e);
                return;
            }
        } else if (aEvent.getSource() == this._setToSelectedButton) {
            this._setSelectedComponents();
        } else if (aEvent.getSource() == this._showComponentsButton) {
            this._showComponents();
        } else {
            super.actionPerformed(aEvent);
        }
    }

    public void deAnnotateGraph() {
        StringBuffer moml = new StringBuffer();
        for (ComponentEntity entity : this._model.entityList(ComponentEntity.class)) {
            String entityDeletes = this._deletesIfNecessary((NamedObj)entity);
            moml.append("<entity name=\"" + entity.getName() + "\">");
            if (entityDeletes != null) {
                moml.append(entityDeletes);
            }
            for (Port port : entity.portList()) {
                String portDeletes = this._deletesIfNecessary((NamedObj)port);
                if (portDeletes == null) continue;
                moml.append("<port name=\"" + port.getName() + "\">" + portDeletes + "</port>");
            }
            moml.append("</entity>");
        }
        for (Relation relation : this._model.relationList()) {
            String relationDeletes = this._deletesIfNecessary((NamedObj)relation);
            if (relationDeletes == null) continue;
            moml.append("<relation name=\"" + relation.getName() + "\">" + relationDeletes + "\"/></relation>");
        }
        if (moml.length() > 0) {
            String momlUpdate = "<group>" + moml.toString() + "</group>";
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, (NamedObj)this._model, momlUpdate);
            request.setUndoable(true);
            request.setPersistent(false);
            this._model.requestChange((ChangeRequest)request);
        }
    }

    public void selectionChanged(SelectionEvent e) {
        this._setToSelectedButton.setEnabled(true);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this._solutionsList.getSelectedIndex();
        if (index >= 0) {
            this._showComponents();
            Solution solution = (Solution)this._solutions.elementAt(index);
            solution.annotateGraph();
        }
    }

    protected void _cancel() {
        this._selectionModel.removeSelectionListener((SelectionListener)this);
        this._selectionModel.clearSelection();
        this._selectionInteractor.setSelectionRenderer(this._defaultSelectionRenderer);
        this._showComponents();
        super._cancel();
    }

    protected void _createExtendedButtons(JPanel _buttons) {
    }

    protected URL _getHelpURL() {
        URL helpURL = this.getClass().getClassLoader().getResource("ptolemy/actor/gui/doc/unitConstraintsSolver.htm");
        return helpURL;
    }

    private String _deletesIfNecessary(NamedObj obj) {
        String retv = null;
        Attribute color = obj.getAttribute("_color");
        Attribute explanation = obj.getAttribute("_explanation");
        if (color != null && explanation != null) {
            retv = "<deleteProperty name=\"_color\"/><deleteProperty name=\"_explanation\"/>";
        }
        return retv;
    }

    private Vector _getSelectedNodes() {
        Vector<NamedObj> nodes = new Vector<NamedObj>();
        if (this._tableau.getFrame() instanceof BasicGraphFrame) {
            Object[] selection = this._selectionModel.getSelectionAsArray();
            int i = 0;
            while (i < selection.length) {
                Object userObject;
                NamedObj actual;
                if (selection[i] instanceof Figure && (actual = (NamedObj)this._graphModel.getSemanticObject(userObject = ((Figure)selection[i]).getUserObject())) instanceof ComponentEntity) {
                    nodes.add(actual);
                }
                ++i;
            }
        }
        return nodes;
    }

    private Vector _getSelectedRelations() {
        Vector<NamedObj> relations = new Vector<NamedObj>();
        if (this._tableau.getFrame() instanceof BasicGraphFrame) {
            Object[] selection = this._selectionModel.getSelectionAsArray();
            int i = 0;
            while (i < selection.length) {
                Object userObject;
                NamedObj actual;
                if (selection[i] instanceof Figure && (actual = (NamedObj)this._graphModel.getSemanticObject(userObject = ((Figure)selection[i]).getUserObject())) instanceof Relation && !relations.contains(actual)) {
                    relations.add(actual);
                }
                ++i;
            }
        }
        return relations;
    }

    private void _setSelectedComponents() {
        Vector entities = this._getSelectedNodes();
        Vector relations = this._getSelectedRelations();
        this._entities = new Vector();
        this._relations = new Vector();
        int i = 0;
        while (i < entities.size()) {
            this._entities.add(entities.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < relations.size()) {
            this._relations.add(relations.elementAt(i));
            ++i;
        }
        this._setToSelectedButton.setEnabled(false);
    }

    private void _showComponents() {
        this._selectionModel.clearSelection();
        this.deAnnotateGraph();
        Iterator nodes = this._graphModel.nodes(this._model);
        while (nodes.hasNext()) {
            Location node = (Location)nodes.next();
            NamedObj entity = (NamedObj)this._graphModel.getSemanticObject(node);
            if (!this._entities.contains(entity)) continue;
            Figure figure = this._controller.getFigure((Object)node);
            this._selectionModel.addSelection((Object)figure);
            Iterator edges = GraphUtilities.partiallyContainedEdges((Object)node, (GraphModel)this._graphModel);
            while (edges.hasNext()) {
                Object edge = edges.next();
                Object relation = this._graphModel.getSemanticObject(edge);
                if (!this._relations.contains(relation)) continue;
                Figure relationFigure = this._controller.getFigure(edge);
                this._selectionModel.addSelection((Object)relationFigure);
            }
        }
    }

    public class SolutionListModel
    extends AbstractListModel {
        Vector _solutions = new Vector();

        public Object getElementAt(int index) {
            return ((Solution)this._solutions.elementAt(index)).getStateDesc();
        }

        public int getSize() {
            return this._solutions.size();
        }

        public void setSolutions(Vector solutions) {
            this._solutions = solutions;
            this.fireContentsChanged(this, 0, this._solutions.size());
        }

        public void clear() {
            this._solutions = new Vector();
        }
    }
}

