/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.RecordToken;
import ptolemy.data.expr.Parameter;
import ptolemy.gui.Top;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class WindowPropertiesAttribute
extends Parameter
implements ComponentListener {
    private Frame _listeningTo;

    public WindowPropertiesAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setVisibility(Settable.NONE);
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
        this.recordProperties(this._listeningTo);
    }

    public void componentResized(ComponentEvent event) {
        this.recordProperties(this._listeningTo);
    }

    public void componentShown(ComponentEvent event) {
    }

    public void recordProperties(Frame frame) {
        try {
            Rectangle bounds = frame.getBounds();
            boolean maximized = (frame.getExtendedState() & 6) == 6;
            this.setToken("{bounds={" + bounds.x + ", " + bounds.y + ", " + bounds.width + ", " + bounds.height + "}, maximized=" + maximized + "}");
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("Can't set propertes value! " + (Object)((Object)ex));
        }
    }

    public boolean setProperties(Frame frame) {
        boolean maximized;
        RecordToken value;
        block7: {
            if (this._listeningTo != frame) {
                if (this._listeningTo != null) {
                    this._listeningTo.removeComponentListener(this);
                }
                frame.addComponentListener(this);
                this._listeningTo = frame;
            }
            try {
                value = (RecordToken)this.getToken();
                if (value != null) break block7;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        ArrayToken boundsToken = (ArrayToken)value.get("bounds");
        BooleanToken maximizedToken = (BooleanToken)value.get("maximized");
        int x = ((IntToken)boundsToken.getElement(0)).intValue();
        int y = ((IntToken)boundsToken.getElement(1)).intValue();
        int width = ((IntToken)boundsToken.getElement(2)).intValue();
        int height = ((IntToken)boundsToken.getElement(3)).intValue();
        x = x < 0 ? 30 : x;
        y = y < 0 ? 30 : y;
        Toolkit tk = Toolkit.getDefaultToolkit();
        x = x + width > tk.getScreenSize().width ? 0 : x;
        y = y + height > tk.getScreenSize().height ? 0 : y;
        frame.setBounds(x, y, width, height);
        if (maximizedToken != null && (maximized = maximizedToken.booleanValue())) {
            frame.setExtendedState(frame.getExtendedState() | 6);
        }
        if (frame instanceof Top) {
            ((Top)frame).setCentering(false);
        }
        return true;
    }
}

