/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class SizeAttribute
extends Parameter
implements ComponentListener {
    private Component _listeningTo;

    public SizeAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setVisibility(Settable.NONE);
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void recordSize(Component component) {
        try {
            Rectangle bounds = component.getBounds();
            this.setToken("[" + bounds.width + ", " + bounds.height + "]");
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("Can't set bounds value!");
        }
    }

    public boolean setSize(Component component) {
        if (this._listeningTo != component) {
            if (this._listeningTo != null) {
                this._listeningTo.removeComponentListener(this);
            }
            component.addComponentListener(this);
            this._listeningTo = component;
        }
        try {
            IntMatrixToken token = (IntMatrixToken)this.getToken();
            if (token != null) {
                int width = token.getElementAt(0, 0);
                int height = token.getElementAt(0, 1);
                Dimension dimension = new Dimension(width, height);
                component.setSize(dimension);
                if (component instanceof JComponent) {
                    ((JComponent)component).setPreferredSize(dimension);
                    ((JComponent)component).setMinimumSize(dimension);
                }
            } else if (component instanceof JComponent) {
                ((JComponent)component).setPreferredSize(null);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

