/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import ptolemy.data.MatrixToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;

public class MatrixPane
extends JScrollPane {
    public JTable table = new JTable();
    private static Token _emptyStringToken = new StringToken("");
    private static EmptyTableModel _emptyTableModel = new EmptyTableModel();

    public MatrixPane() {
        this.table.setTableHeader(null);
        this.table.setAutoResizeMode(4);
        this.setViewportView(this.table);
        this.table.setBackground(null);
    }

    public void clear() {
        this.table.setModel(_emptyTableModel);
    }

    public void display(MatrixToken matrix) {
        this.table.setModel(new MatrixAsTable(matrix));
    }

    private static class EmptyTableModel
    extends AbstractTableModel {
        private EmptyTableModel() {
        }

        public int getColumnCount() {
            return 0;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getValueAt(int row, int column) {
            return _emptyStringToken;
        }
    }

    private static class MatrixAsTable
    extends AbstractTableModel {
        private MatrixToken _matrix = null;

        MatrixAsTable(MatrixToken matrix) {
            this._matrix = matrix;
        }

        public int getColumnCount() {
            return this._matrix.getColumnCount();
        }

        public String getColumnName(int columnIndex) {
            return Integer.toString(columnIndex);
        }

        public int getRowCount() {
            return this._matrix.getRowCount();
        }

        public Object getValueAt(int row, int column) {
            if (row >= this._matrix.getRowCount() || column >= this._matrix.getColumnCount()) {
                return _emptyStringToken;
            }
            return this._matrix.getElementAsToken(row, column).toString();
        }
    }
}

