/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.expr.ExpertParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLParser;
import ptolemy.moml.filter.BackwardCompatibility;
import ptolemy.moml.filter.RemoveGraphicalClasses;

public class CheckModelSize {
    public static String checkModelSize(Configuration configuration, String[] args) throws Exception {
        StringBuffer results = new StringBuffer();
        HashSet sizeProblemSet = new HashSet();
        if (configuration != null) {
            List entityList = configuration.allCompositeEntityList();
            for (Object entity : entityList) {
                if (!(entity instanceof TypedCompositeActor) || sizeProblemSet.contains(entity)) continue;
                String checkSizeOutput = CheckModelSize._checkSize((NamedObj)((TypedCompositeActor)entity), false);
                if (!checkSizeOutput.equals("")) {
                    results.append("<tr>\n  <td>" + ((TypedCompositeActor)entity).getFullName() + "</td>\n  <td>" + checkSizeOutput + "</td>\n");
                }
                sizeProblemSet.add(entity);
            }
            List classList = configuration.classDefinitionList();
            for (Object entity : classList) {
                System.out.println("CheckModelSize: " + entity + " " + (entity instanceof TypedCompositeActor));
                if (!(entity instanceof TypedCompositeActor) || sizeProblemSet.contains(entity)) continue;
                String checkSizeOutput = CheckModelSize._checkSize((NamedObj)((TypedCompositeActor)entity), false);
                if (!checkSizeOutput.equals("")) {
                    results.append("<tr>\n  <td><b>Class</b> " + ((TypedCompositeActor)entity).getFullName() + "</td>\n  <td>" + checkSizeOutput + "</td>\n");
                }
                sizeProblemSet.add(entity);
            }
        }
        int i = 0;
        while (i < args.length) {
            String fileName = args[i];
            StringBuffer analysis = new StringBuffer();
            MoMLParser parser = new MoMLParser();
            MoMLParser.setMoMLFilters((List)BackwardCompatibility.allFilters());
            RemoveGraphicalClasses removeGraphicalClasses = new RemoveGraphicalClasses();
            removeGraphicalClasses.put("ptolemy.codegen.kernel.StaticSchedulingCodeGenerator", null);
            MoMLParser.addMoMLFilter((MoMLFilter)removeGraphicalClasses);
            if (fileName.endsWith(".xml") || fileName.endsWith(".moml")) {
                try {
                    NamedObj top = null;
                    try {
                        top = parser.parse(null, new File(fileName).toURI().toURL());
                    }
                    catch (Exception ex) {
                        try {
                            top = parser.parse(null, new URL(fileName));
                        }
                        catch (Exception ex2) {
                            throw new Exception("Failed to parse \"" + fileName + "\". First exception:\n" + ex, ex2);
                        }
                    }
                    String checkSizeOutput = CheckModelSize._checkSize(top, false);
                    if (checkSizeOutput.equals("")) {
                        analysis.append(" seems to be OK.");
                    } else {
                        analysis.append(checkSizeOutput);
                    }
                    if (top instanceof CompositeEntity) {
                        List entityList = ((CompositeEntity)top).deepEntityList();
                        for (Object entity : entityList) {
                            if (!(entity instanceof TypedCompositeActor) || sizeProblemSet.contains(entity)) continue;
                            checkSizeOutput = CheckModelSize._checkSize((NamedObj)((TypedCompositeActor)entity), false);
                            if (!checkSizeOutput.equals("")) {
                                sizeProblemSet.add(entity);
                                results.append("<tr>\n  <td>" + ((TypedCompositeActor)entity).getFullName() + "</td>\n  <td>" + checkSizeOutput + "</td>\n");
                            }
                            sizeProblemSet.add(entity);
                        }
                    }
                }
                catch (Throwable throwable) {
                    analysis.append(" can't be parsed because ");
                    analysis.append(KernelException.stackTraceToString((Throwable)throwable));
                }
                String fileURL = new File(fileName).toURI().toURL().toString();
                results.append("<tr>\n  <td><a href=\"" + fileURL + "\">" + fileURL + "</a></td>\n  <td>" + analysis + "</td>\n");
            }
            ++i;
        }
        return "<h1>Check Size</h1>\nBelow are the results from checking the sizes of and centering of models\n<table>\n<b>Note: after running review these results, be sure to exit, as the graphical elements of the  models will have been removed</b>\n" + results.toString() + "</table>\n";
    }

    public static void main(String[] args) {
        try {
            System.out.println(CheckModelSize.checkModelSize(null, args));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static String _checkSize(NamedObj top, boolean ignoreMissingVergilSize) {
        StringBuffer analysis = new StringBuffer();
        if (top instanceof CompositeActor) {
            SizeAttribute vergilSize = (SizeAttribute)top.getAttribute("_vergilSize");
            ExpertParameter vergilZoom = (ExpertParameter)top.getAttribute("_vergilZoomFactor");
            ExpertParameter vergilCenter = (ExpertParameter)top.getAttribute("_vergilCenter");
            if (vergilSize != null) {
                block17: {
                    try {
                        IntMatrixToken vergilSizeToken = (IntMatrixToken)vergilSize.getToken();
                        if (vergilSizeToken == null) {
                            throw new IllegalActionException((Nameable)top, "_vergilSize token was null?");
                        }
                        int width = vergilSizeToken.getElementAt(0, 0);
                        int height = vergilSizeToken.getElementAt(0, 1);
                        if (width > 800) {
                            analysis.append(" width(" + width + ") > 800");
                        }
                        if (height > 768) {
                            analysis.append(" height(" + height + ") > 768");
                        }
                        if (vergilCenter == null) break block17;
                        try {
                            ArrayToken vergilCenterToken = (ArrayToken)vergilCenter.getToken();
                            double x = ((ScalarToken)vergilCenterToken.getElement(0)).doubleValue();
                            double y = ((ScalarToken)vergilCenterToken.getElement(1)).doubleValue();
                            if (Math.abs(x - (double)width / 2.0) > 0.1 || Math.abs(y - (double)height / 2.0) > 0.1) {
                                analysis.append(" Center([" + x + ", " + y + "]) is not centered, should be [" + (double)width / 2.0 + ", " + (double)height / 2.0 + "]");
                            }
                        }
                        catch (IllegalActionException ex) {
                            analysis.append(" _vergilCenter malformed");
                            analysis.append(KernelException.stackTraceToString((Throwable)ex));
                        }
                    }
                    catch (IllegalActionException ex) {
                        analysis.append(" _vergilSize malformed");
                        analysis.append(KernelException.stackTraceToString((Throwable)ex));
                    }
                }
                if (vergilZoom != null) {
                    try {
                        DoubleToken vergilZoomToken = (DoubleToken)vergilZoom.getToken();
                        double zoom = vergilZoomToken.doubleValue();
                        if (zoom != 1.0) {
                            analysis.append(" Zoom(" + zoom + ") != 1.0");
                        }
                    }
                    catch (IllegalActionException ex) {
                        analysis.append(" _vergilZoom malformed");
                        analysis.append(KernelException.stackTraceToString((Throwable)ex));
                    }
                }
            } else if (!ignoreMissingVergilSize) {
                analysis.append(" has no _vergilSize.");
            }
        } else {
            analysis.append(" is a " + top.getClassName() + " not a CompositeActor.");
        }
        return analysis.toString();
    }
}

