/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import ptolemy.actor.gui.JNLPUtilities;
import ptolemy.util.StringUtilities;

public class BrowserLauncher {
    public static boolean delayExit;
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class mrjFileUtilsClass;
    private static Class mrjOSTypeClass;
    private static Class aeDescClass;
    private static Constructor aeTargetConstructor;
    private static Constructor appleEventConstructor;
    private static Constructor aeDescConstructor;
    private static Method findFolder;
    private static Method getFileCreator;
    private static Method getFileType;
    private static Method openURL;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static Object linkage;
    private static final int MRJ_2_0 = 0;
    private static final int MRJ_2_1 = 1;
    private static final int MRJ_3_0 = 3;
    private static final int MRJ_3_1 = 4;
    private static final int WINDOWS_NT = 5;
    private static final int WINDOWS_9x = 6;
    private static final int OTHER = -1;
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")'";
    private static String errorMessage;

    static {
        block9: {
            delayExit = false;
            loadedWithoutErrors = true;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                String mrjVersion = System.getProperty("mrj.version");
                String majorMRJVersion = mrjVersion.substring(0, 3);
                try {
                    double version = Double.valueOf(majorMRJVersion);
                    if (version == 2.0) {
                        jvm = 0;
                        break block9;
                    }
                    if (version >= 2.1 && version < 3.0) {
                        jvm = 1;
                        break block9;
                    }
                    if (version == 3.0) {
                        jvm = 3;
                        break block9;
                    }
                    if (version >= 3.1) {
                        jvm = 4;
                        break block9;
                    }
                    loadedWithoutErrors = false;
                    errorMessage = "Unsupported MRJ version: " + version;
                }
                catch (NumberFormatException numberFormatException) {
                    loadedWithoutErrors = false;
                    errorMessage = "Invalid MRJ version: " + mrjVersion;
                }
            } else {
                jvm = osName.startsWith("Windows") ? (osName.indexOf("9") != -1 ? 6 : 5) : -1;
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length >= 1) {
            BrowserLauncher.openURL(args[0]);
        } else {
            BrowserLauncher.openURL("http://ptolemy.eecs.berkeley.edu");
        }
        if (delayExit) {
            System.out.println("Delaying exit for 10 seconds because wemay have copied a jar: file");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
            System.exit(0);
        }
    }

    public static void openURL(String url) throws IOException {
        if (!loadedWithoutErrors) {
            throw new IOException("Exception in finding browser: " + errorMessage);
        }
        if (!url.startsWith("http:")) {
            File urlFile = null;
            try {
                urlFile = new File(url);
            }
            catch (Exception exception) {}
            if (urlFile == null || !urlFile.exists()) {
                String refClassName = "ptolemy.kernel.util.NamedObj";
                try {
                    Class<?> refClass = Class.forName(refClassName);
                    URL entryURL = refClass.getClassLoader().getResource(url);
                    if (entryURL != null && !url.startsWith("jar:")) {
                        System.out.println("BrowserLauncher: Could not find '" + url + "', but '" + entryURL + "' was found.");
                        url = entryURL.toString();
                    } else if (url.startsWith("jar:")) {
                        String old = url;
                        String temporaryURL = JNLPUtilities.saveJarURLInClassPath(url);
                        if (temporaryURL != null) {
                            url = temporaryURL;
                        } else {
                            url = JNLPUtilities.saveJarURLAsTempFile(url, "tmp", null, null);
                            delayExit = true;
                        }
                        System.out.println("BrowserLauncher: Could not find '" + old + "', but jar url'" + url + "' was found.");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("BrowserLauncher: Internal error,  Could not find " + refClassName);
                }
            }
        }
        if (!StringUtilities.getProperty((String)"ptolemy.ptII.browser").equals("")) {
            Runtime.getRuntime().exec(new String[]{"\"" + StringUtilities.getProperty((String)"ptolemy.ptII.browser") + "\"", url});
            return;
        }
        Object browser = BrowserLauncher.locateBrowser();
        if (browser == null) {
            throw new IOException("Unable to locate browser: " + errorMessage);
        }
        String errorMessage = "";
        switch (jvm) {
            case 0: {
                errorMessage = "Command was a call to aeDescConstructor(" + url + ")";
                Object aeDesc = null;
                try {
                    try {
                        aeDesc = aeDescConstructor.newInstance(url);
                        putParameter.invoke(browser, keyDirectObject, aeDesc);
                        sendNoReply.invoke(browser, new Object[0]);
                        break;
                    }
                    catch (InvocationTargetException ite) {
                        throw new IOException("InvocationTargetException while creating AEDesc: " + ite.getMessage());
                    }
                    catch (IllegalAccessException iae) {
                        throw new IOException("IllegalAccessException while building AppleEvent: " + iae.getMessage());
                    }
                    catch (InstantiationException ie) {
                        throw new IOException("InstantiationException while creating AEDesc: " + ie.getMessage());
                    }
                }
                finally {
                    aeDesc = null;
                    browser = null;
                }
            }
            case 1: {
                String[] args = new String[]{(String)browser, url};
                errorMessage = "Command was: " + args[0] + " " + args[1];
                Runtime.getRuntime().exec(args);
                break;
            }
            case 3: {
                errorMessage = "Command was a call to ICLaunchURL(" + url + ")";
                int[] instance = new int[1];
                int result = BrowserLauncher.ICStart(instance, 0);
                if (result == 0) {
                    int[] selectionEnd;
                    int[] selectionStart = new int[1];
                    byte[] urlBytes = url.getBytes();
                    result = BrowserLauncher.ICLaunchURL(instance[0], new byte[1], urlBytes, urlBytes.length, selectionStart, selectionEnd = new int[]{urlBytes.length});
                    if (result == 0) {
                        BrowserLauncher.ICStop(instance);
                        break;
                    }
                    throw new IOException("Unable to launch URL: " + result);
                }
                throw new IOException("Unable to create an Internet Config instance: " + result);
            }
            case 4: {
                errorMessage = "Command was a call to openURL(" + url + ")";
                try {
                    openURL.invoke(null, url);
                    break;
                }
                catch (InvocationTargetException ite) {
                    throw new IOException("InvocationTargetException while calling openURL() on " + url + " " + ite.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new IOException("IllegalAccessException while calling openURL() on: " + url + " " + iae.getMessage());
                }
            }
            case 5: 
            case 6: {
                String[] args = new String[]{(String)browser, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, String.valueOf('\"') + url + '\"'};
                Process process = Runtime.getRuntime().exec(args);
                errorMessage = "Command was: " + args[0] + " " + args[1] + " " + args[2] + " " + args[3] + " " + args[4] + "\nNote: Under Windows, make sure that the file named by " + "the url is executable.";
                int exitCode = 0;
                try {
                    exitCode = process.waitFor();
                    process.exitValue();
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
                if (exitCode == 0) break;
                throw new IOException("Process exec'd by BrowserLauncher returned " + exitCode + "." + "\n url was: " + url + "\n browser was: " + browser + "\n " + errorMessage);
            }
            case -1: {
                String[] args = new String[]{(String)browser, NETSCAPE_REMOTE_PARAMETER, NETSCAPE_OPEN_PARAMETER_START + url + NETSCAPE_OPEN_PARAMETER_END};
                Process process = Runtime.getRuntime().exec(args);
                errorMessage = "Command was: " + args[0] + " " + args[1] + " " + args[2];
                try {
                    if (process.waitFor() == 0) break;
                    Runtime.getRuntime().exec(new String[]{(String)browser, url});
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            default: {
                Runtime.getRuntime().exec(new String[]{"\"" + (String)browser + "\"", url});
            }
        }
    }

    private BrowserLauncher() {
    }

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static boolean loadClasses() {
        switch (jvm) {
            case 0: {
                try {
                    Class<?> aeTargetClass = Class.forName("com.apple.MacOS.AETarget");
                    Class<?> osUtilsClass = Class.forName("com.apple.MacOS.OSUtils");
                    Class<?> appleEventClass = Class.forName("com.apple.MacOS.AppleEvent");
                    Class<?> aeClass = Class.forName("com.apple.MacOS.ae");
                    aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
                    aeTargetConstructor = aeTargetClass.getDeclaredConstructor(Integer.TYPE);
                    appleEventConstructor = appleEventClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, aeTargetClass, Integer.TYPE, Integer.TYPE);
                    aeDescConstructor = aeDescClass.getDeclaredConstructor(String.class);
                    makeOSType = osUtilsClass.getDeclaredMethod("makeOSType", String.class);
                    putParameter = appleEventClass.getDeclaredMethod("putParameter", Integer.TYPE, aeDescClass);
                    sendNoReply = appleEventClass.getDeclaredMethod("sendNoReply", new Class[0]);
                    Field keyDirectObjectField = aeClass.getDeclaredField("keyDirectObject");
                    keyDirectObject = (Integer)keyDirectObjectField.get(null);
                    Field autoGenerateReturnIDField = appleEventClass.getDeclaredField("kAutoGenerateReturnID");
                    kAutoGenerateReturnID = (Integer)autoGenerateReturnIDField.get(null);
                    Field anyTransactionIDField = appleEventClass.getDeclaredField("kAnyTransactionID");
                    kAnyTransactionID = (Integer)anyTransactionIDField.get(null);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field systemFolderField = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = systemFolderField.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    getFileCreator = mrjFileUtilsClass.getDeclaredMethod("getFileCreator", File.class);
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", File.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (SecurityException se) {
                    errorMessage = se.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 3: {
                try {
                    Class<?> linker = Class.forName("com.apple.mrj.jdirect.Linker");
                    Constructor<?> constructor = linker.getConstructor(Class.class);
                    linkage = constructor.newInstance(BrowserLauncher.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (InvocationTargetException ite) {
                    errorMessage = ite.getMessage();
                    return false;
                }
                catch (InstantiationException ie) {
                    errorMessage = ie.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 4: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", String.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                try {
                    Integer finderCreatorCode = (Integer)makeOSType.invoke(null, FINDER_CREATOR);
                    Object aeTarget = aeTargetConstructor.newInstance(finderCreatorCode);
                    Integer gurlType = (Integer)makeOSType.invoke(null, GURL_EVENT);
                    Object appleEvent = appleEventConstructor.newInstance(gurlType, gurlType, aeTarget, kAutoGenerateReturnID, kAnyTransactionID);
                    return appleEvent;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InstantiationException ie) {
                    browser = null;
                    errorMessage = ie.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getMessage();
                    return browser;
                }
            }
            case 1: {
                File systemFolder;
                try {
                    systemFolder = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException iare) {
                    browser = null;
                    errorMessage = iare.getMessage();
                    return browser;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                    return browser;
                }
                String[] systemFolderFiles = systemFolder.list();
                int i = 0;
                while (i < systemFolderFiles.length) {
                    try {
                        Object fileCreator;
                        Object fileType;
                        File file = new File(systemFolder, systemFolderFiles[i]);
                        if (file.isFile() && FINDER_TYPE.equals((fileType = getFileType.invoke(null, file)).toString()) && FINDER_CREATOR.equals((fileCreator = getFileCreator.invoke(null, file)).toString())) {
                            browser = file.toString();
                            return browser;
                        }
                    }
                    catch (IllegalArgumentException iare) {
                        errorMessage = iare.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException iae) {
                        browser = null;
                        errorMessage = iae.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException ite) {
                        browser = null;
                        errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                        return browser;
                    }
                    ++i;
                }
                browser = null;
                break;
            }
            case 3: 
            case 4: {
                browser = "";
                break;
            }
            case 5: {
                browser = "cmd.exe";
                break;
            }
            case 6: {
                browser = "command.com";
                break;
            }
            default: {
                browser = "firefox";
            }
        }
        return browser;
    }
}

