/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.net.URL;
import java.net.URLConnection;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.EffigyFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class BrowserEffigy
extends Effigy {
    public static Factory staticFactory = null;

    public BrowserEffigy(Workspace workspace) {
        super(workspace);
        this.setModifiable(false);
    }

    public BrowserEffigy(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setModifiable(false);
    }

    public static BrowserEffigy newBrowserEffigy(CompositeEntity container, URL base, URL in) throws Exception {
        BrowserEffigy effigy = new BrowserEffigy(container, container.uniqueName("browserEffigy"));
        effigy.setModifiable(false);
        effigy.uri.setURL(in);
        return effigy;
    }

    public static class Factory
    extends EffigyFactory {
        public Factory(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            staticFactory = this;
        }

        public boolean canCreateBlankEffigy() {
            return false;
        }

        public Effigy createEffigy(CompositeEntity container, URL base, URL in) throws Exception {
            if (in == null) {
                return null;
            }
            String extension = Factory.getExtension(in);
            if (extension.equals("pdf") || extension.startsWith("htm") || extension.startsWith("shtm")) {
                BrowserEffigy effigy = BrowserEffigy.newBrowserEffigy(container, base, in);
                return effigy;
            }
            URLConnection connection = in.openConnection();
            if (connection == null) {
                return null;
            }
            String contentType = connection.getContentType();
            if (contentType == null) {
                return null;
            }
            if (contentType.startsWith("text/html") || contentType.startsWith("text/rtf")) {
                BrowserEffigy effigy = BrowserEffigy.newBrowserEffigy(container, base, in);
                return effigy;
            }
            return null;
        }
    }
}

