/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompoundQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.p2.publisher.IPublisherResult;

public class PublisherResult
implements IPublisherResult {
    private static final Collection EMPTY_COLLECTION = new ArrayList(0);
    final Map rootIUs = new HashMap();
    final Map nonRootIUs = new HashMap();

    public void addIU(IInstallableUnit iu, String type) {
        if (type == "root") {
            this.addIU(this.rootIUs, iu.getId(), iu);
        }
        if (type == "non_root") {
            this.addIU(this.nonRootIUs, iu.getId(), iu);
        }
    }

    public void addIUs(Collection ius, String type) {
        Iterator i = ius.iterator();
        while (i.hasNext()) {
            this.addIU((IInstallableUnit)i.next(), type);
        }
    }

    private void addIU(Map map, String id, IInstallableUnit iu) {
        HashSet<IInstallableUnit> ius = (HashSet<IInstallableUnit>)map.get(id);
        if (ius == null) {
            ius = new HashSet<IInstallableUnit>(11);
            map.put(id, ius);
        }
        ius.add(iu);
    }

    public IInstallableUnit getIU(String id, Version version, String type) {
        IInstallableUnit iu;
        Iterator i;
        Collection ius;
        if (type == null || type == "root") {
            ius = (Collection)this.rootIUs.get(id);
            i = ius.iterator();
            while (i.hasNext()) {
                iu = (IInstallableUnit)i.next();
                if (!iu.getVersion().equals((Object)version)) continue;
                return iu;
            }
        }
        if (type == null || type == "non_root") {
            ius = (Collection)this.nonRootIUs.get(id);
            i = ius.iterator();
            while (i.hasNext()) {
                iu = (IInstallableUnit)i.next();
                if (!iu.getVersion().equals((Object)version)) continue;
                return iu;
            }
        }
        return null;
    }

    public IInstallableUnit getIU(String id, String type) {
        Collection ius;
        if ((type == null || type == "root") && (ius = (Collection)this.rootIUs.get(id)) != null && ius.size() > 0) {
            return (IInstallableUnit)ius.iterator().next();
        }
        if ((type == null || type == "non_root") && (ius = (Collection)this.nonRootIUs.get(id)) != null && ius.size() > 0) {
            return (IInstallableUnit)ius.iterator().next();
        }
        return null;
    }

    public Collection getIUs(String id, String type) {
        if (type == null) {
            ArrayList result = new ArrayList();
            result.addAll(id == null ? this.flatten(this.rootIUs.values()) : this.getIUs(this.rootIUs, id));
            result.addAll(id == null ? this.flatten(this.nonRootIUs.values()) : this.getIUs(this.nonRootIUs, id));
            return result;
        }
        if (type == "root") {
            return id == null ? this.flatten(this.rootIUs.values()) : (Collection)this.rootIUs.get(id);
        }
        if (type == "non_root") {
            return id == null ? this.flatten(this.nonRootIUs.values()) : (Collection)this.nonRootIUs.get(id);
        }
        return null;
    }

    private Collection getIUs(Map ius, String id) {
        Collection result = (Collection)ius.get(id);
        return result == null ? EMPTY_COLLECTION : result;
    }

    private List flatten(Collection values) {
        ArrayList result = new ArrayList();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Iterator j = ((HashSet)i.next()).iterator();
            while (j.hasNext()) {
                result.add(j.next());
            }
        }
        return result;
    }

    public void merge(IPublisherResult result, int mode) {
        if (mode == 0) {
            this.addIUs(result.getIUs(null, "root"), "root");
            this.addIUs(result.getIUs(null, "non_root"), "non_root");
        } else if (mode == 1) {
            this.addIUs(result.getIUs(null, "root"), "root");
            this.addIUs(result.getIUs(null, "non_root"), "root");
        } else if (mode == 2) {
            this.addIUs(result.getIUs(null, "root"), "non_root");
            this.addIUs(result.getIUs(null, "non_root"), "non_root");
        }
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        QueryableMap nonRootQueryable = new QueryableMap(this.nonRootIUs);
        QueryableMap rootQueryable = new QueryableMap(this.rootIUs);
        return new CompoundQueryable(new IQueryable[]{nonRootQueryable, rootQueryable}).query(query, collector, monitor);
    }

    class QueryableMap
    implements IQueryable {
        private Map map;

        public QueryableMap(Map map) {
            this.map = map;
        }

        public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
            return query.perform(PublisherResult.this.flatten(this.map.values()).iterator(), collector);
        }
    }
}

