/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalInterpreterInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.Tuple;
import org.python.pydev.plugin.PydevPlugin;

public class AdditionalSystemInterpreterInfo
extends AbstractAdditionalDependencyInfo {
    private IInterpreterManager manager;
    private String additionalInfoInterpreter;
    private static Map<Tuple<String, String>, AbstractAdditionalInterpreterInfo> additionalSystemInfo = new HashMap<Tuple<String, String>, AbstractAdditionalInterpreterInfo>();

    public AdditionalSystemInterpreterInfo(IInterpreterManager manager, String interpreter) throws MisconfigurationException {
        super(false);
        this.manager = manager;
        this.additionalInfoInterpreter = interpreter;
        this.init();
    }

    public IInterpreterManager getManager() {
        return this.manager;
    }

    public String getAdditionalInfoInterpreter() {
        return this.additionalInfoInterpreter;
    }

    protected File getPersistingFolder() throws MisconfigurationException {
        File base;
        try {
            char c;
            IPath stateLocation = AnalysisPlugin.getDefault().getStateLocation();
            String osString = stateLocation.toOSString();
            if (osString.length() > 0 && (c = osString.charAt(osString.length() - 1)) != '\\' && c != '/') {
                osString = String.valueOf(osString) + '/';
            }
            base = new File(osString);
        }
        catch (NullPointerException e) {
            PydevPlugin.log((int)4, (String)"Error getting persisting folder", (Throwable)e, (boolean)false);
            base = new File(".");
        }
        File file = new File(base, this.getInterpreterRelatedName());
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    protected File getPersistingLocation() throws MisconfigurationException {
        return new File(this.getPersistingFolder(), String.valueOf(this.manager.getManagerRelatedName()) + ".pydevsysteminfo");
    }

    private String getInterpreterRelatedName() throws MisconfigurationException {
        IInterpreterInfo info = this.manager.getInterpreterInfo(this.additionalInfoInterpreter, (IProgressMonitor)new NullProgressMonitor());
        return String.valueOf(this.manager.getManagerRelatedName()) + "_" + info.getExeAsFileSystemValidPath();
    }

    protected void setAsDefaultInfo() {
        AdditionalSystemInterpreterInfo.setAdditionalSystemInfo(this.manager, this.additionalInfoInterpreter, this);
    }

    public static boolean loadAdditionalSystemInfo(IInterpreterManager manager, String interpreter) throws MisconfigurationException {
        AdditionalSystemInterpreterInfo info = new AdditionalSystemInterpreterInfo(manager, interpreter);
        return info.load();
    }

    public static AbstractAdditionalInterpreterInfo getAdditionalSystemInfo(IInterpreterManager manager, String interpreter) throws MisconfigurationException {
        Tuple key = new Tuple((Object)manager.getManagerRelatedName(), (Object)interpreter);
        AbstractAdditionalInterpreterInfo info = additionalSystemInfo.get(key);
        if (info == null) {
            return new AdditionalSystemInterpreterInfo(manager, interpreter);
        }
        return info;
    }

    public static void setAdditionalSystemInfo(IInterpreterManager manager, String interpreter, AbstractAdditionalInterpreterInfo additionalSystemInfoToSet) {
        additionalSystemInfo.put((Tuple<String, String>)new Tuple((Object)manager.getManagerRelatedName(), (Object)interpreter), additionalSystemInfoToSet);
    }
}

