/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class LineCoder
extends SDFTransformer {
    public Parameter table;
    public Parameter wordLength;
    private int _wordLength;
    private Token[] _table;

    public LineCoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.BOOLEAN);
        this.table = new Parameter((NamedObj)this, "table");
        this.table.setExpression("{-1.0, 1.0}");
        this.attributeChanged((Attribute)this.table);
        this.wordLength = new Parameter((NamedObj)this, "wordLength", (Token)new IntToken(1));
        this.wordLength.setTypeEquals((Type)BaseType.INT);
        this.output.setTypeAtLeast(ArrayType.elementType((Typeable)this.table));
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        LineCoder newObject = (LineCoder)((Object)super.clone(workspace));
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType((Typeable)newObject.table));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        int tableAddress = 0;
        Token[] tokens = this.input.get(0, this._wordLength);
        int i = 0;
        while (i < this._wordLength) {
            boolean data = ((BooleanToken)tokens[i]).booleanValue();
            if (data) {
                tableAddress |= 1 << i;
            }
            ++i;
        }
        this.output.send(0, this._table[tableAddress]);
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._wordLength = ((IntToken)this.wordLength.getToken()).intValue();
        this.input_tokenConsumptionRate.setToken((Token)new IntToken(this._wordLength));
        ArrayToken tableToken = (ArrayToken)this.table.getToken();
        int size = (int)Math.pow(2.0, this._wordLength);
        if (tableToken.length() < size) {
            throw new IllegalActionException((Nameable)this, "Table parameter must have at least " + size + " entries, but only has " + tableToken.length());
        }
        this._table = tableToken.arrayValue();
    }
}

