/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.kernel;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.Scheduler;
import ptolemy.actor.util.ConstVariableModelAnalysis;
import ptolemy.actor.util.DFUtilities;
import ptolemy.actor.util.DependencyDeclaration;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public abstract class BaseSDFScheduler
extends Scheduler {
    protected static final boolean VERBOSE = false;

    public BaseSDFScheduler() {
    }

    public BaseSDFScheduler(Workspace workspace) {
        super(workspace);
    }

    public BaseSDFScheduler(Director container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public abstract void declareRateDependency() throws IllegalActionException;

    protected void _declareDependency(ConstVariableModelAnalysis analysis, Port port, String name, List dependents) throws IllegalActionException {
        Variable variable = DFUtilities.getRateVariable((Port)port, (String)name);
        DependencyDeclaration declaration = (DependencyDeclaration)variable.getAttribute("_SDFRateDependencyDeclaration", DependencyDeclaration.class);
        if (declaration == null) {
            try {
                declaration = new DependencyDeclaration(variable, "_SDFRateDependencyDeclaration");
            }
            catch (NameDuplicationException nameDuplicationException) {
                throw new InternalErrorException("Failed to construct _SDFRateDependencyDeclaration");
            }
        }
        declaration.setDependents(dependents);
        analysis.addDependencyDeclaration(declaration);
    }

    protected void _saveBufferSizes(final Map minimumBufferSizes) {
        Director director = (Director)this.getContainer();
        final CompositeActor container = (CompositeActor)director.getContainer();
        ChangeRequest request = new ChangeRequest((Object)this, "Record buffer sizes"){

            protected void _execute() throws KernelException {
                for (Relation relation : container.relationList()) {
                    Object bufferSizeObject = minimumBufferSizes.get(relation);
                    if (bufferSizeObject instanceof Integer) {
                        int bufferSize = (Integer)bufferSizeObject;
                        DFUtilities.setOrCreate((NamedObj)relation, (String)"bufferSize", (int)bufferSize);
                        if (!((NamedObj)BaseSDFScheduler.this)._debugging) continue;
                        BaseSDFScheduler.this._debug("Adding bufferSize parameter to " + relation.getName() + " with value " + bufferSize);
                        continue;
                    }
                    if (bufferSizeObject instanceof String) {
                        String bufferSizeExpression = (String)bufferSizeObject;
                        DFUtilities.setOrCreate((NamedObj)relation, (String)"bufferSize", (String)("\"" + bufferSizeExpression + "\""));
                        if (!((NamedObj)BaseSDFScheduler.this)._debugging) continue;
                        BaseSDFScheduler.this._debug("Adding bufferSize parameter to " + relation.getName() + " with expression " + bufferSizeExpression);
                        continue;
                    }
                    if (bufferSizeObject == null) continue;
                    throw new InternalErrorException("Invalid value found in buffer size map.\nValue is of type " + bufferSizeObject.getClass().getName() + ".\nIt should be of type Integer or String.\n");
                }
            }
        };
        request.setPersistent(false);
        container.requestChange(request);
    }

    protected void _saveContainerRates(Map externalRates) throws NotSchedulableException, IllegalActionException {
        Director director = (Director)this.getContainer();
        CompositeActor container = (CompositeActor)director.getContainer();
        for (IOPort port : container.portList()) {
            Integer rate = (Integer)externalRates.get(port);
            if (port.isInput() && port.isOutput()) {
                throw new NotSchedulableException((Nameable)port, "External port is both an input and an output, which is not allowed in SDF.");
            }
            if (port.isInput()) {
                DFUtilities.setIfNotDefined((Port)port, (String)"tokenConsumptionRate", (int)rate);
                continue;
            }
            if (port.isOutput()) {
                DFUtilities.setIfNotDefined((Port)port, (String)"tokenProductionRate", (int)rate);
                Iterator connectedPorts = port.insideSourcePortList().iterator();
                IOPort foundOutputPort = null;
                int inferredRate = 0;
                while (connectedPorts.hasNext()) {
                    IOPort connectedPort = (IOPort)connectedPorts.next();
                    int newRate = connectedPort.isOutput() ? DFUtilities.getTokenInitProduction((IOPort)connectedPort) : 0;
                    if (foundOutputPort != null && newRate != inferredRate) {
                        throw new NotSchedulableException("External output port " + port + " is connected on the inside to ports " + "with different initial production: " + foundOutputPort + " and " + connectedPort);
                    }
                    foundOutputPort = connectedPort;
                    inferredRate = newRate;
                }
                DFUtilities.setIfNotDefined((Port)port, (String)"tokenInitProduction", (int)inferredRate);
                continue;
            }
            throw new NotSchedulableException((Nameable)port, "External port is neither an input and an output, which is not allowed in SDF.");
        }
    }

    protected void _saveFiringCounts(final Map entityToFiringsPerIteration) {
        Director director = (Director)this.getContainer();
        CompositeActor container = (CompositeActor)director.getContainer();
        ChangeRequest request = new ChangeRequest((Object)this, "Record firings per iteration"){

            protected void _execute() throws KernelException {
                for (Entity entity : entityToFiringsPerIteration.keySet()) {
                    int firingCount = (Integer)entityToFiringsPerIteration.get(entity);
                    DFUtilities.setOrCreate((NamedObj)entity, (String)"firingsPerIteration", (int)firingCount);
                    if (!((NamedObj)BaseSDFScheduler.this)._debugging) continue;
                    BaseSDFScheduler.this._debug("Adding firingsPerIteration parameter to " + entity.getName() + " with value " + firingCount);
                }
            }
        };
        request.setPersistent(false);
        container.requestChange(request);
    }
}

