/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.pn.kernel;

import ptolemy.actor.Actor;
import ptolemy.actor.TimedDirector;
import ptolemy.actor.util.CQComparator;
import ptolemy.actor.util.CalendarQueue;
import ptolemy.actor.util.Time;
import ptolemy.actor.util.TimedEvent;
import ptolemy.domains.pn.kernel.PNDirector;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class TimedPNDirector
extends PNDirector
implements TimedDirector {
    protected CalendarQueue _eventQueue = new CalendarQueue((CQComparator)new TimedEvent.TimeComparator());
    private int _delayBlockCount = 0;

    public TimedPNDirector() throws IllegalActionException, NameDuplicationException {
        this.timeResolution.setVisibility(Settable.FULL);
    }

    public TimedPNDirector(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this.timeResolution.setVisibility(Settable.FULL);
    }

    public TimedPNDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.timeResolution.setVisibility(Settable.FULL);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        TimedPNDirector newObject = (TimedPNDirector)((Object)super.clone(workspace));
        newObject._eventQueue = new CalendarQueue((CQComparator)new TimedEvent.TimeComparator());
        newObject._delayBlockCount = 0;
        return newObject;
    }

    public synchronized void fireAt(Actor actor, Time newFiringTime) throws IllegalActionException {
        if (newFiringTime.compareTo((Object)this.getModelTime()) < 0) {
            throw new IllegalActionException((Nameable)this, "The process wants to  get fired in the past!");
        }
        this._eventQueue.put((Object)new TimedEvent(newFiringTime, (Object)actor));
        this._informOfDelayBlock();
        try {
            while (this.getModelTime().compareTo((Object)newFiringTime) < 0) {
                ((Object)((Object)this)).wait();
            }
        }
        catch (InterruptedException e) {
            System.err.println(e.toString());
        }
    }

    public void setModelTime(Time newTime) throws IllegalActionException {
        if (newTime.compareTo((Object)this.getModelTime()) < 0) {
            throw new IllegalActionException((Nameable)this, "Attempt to set the time to past.");
        }
        super.setModelTime(newTime);
    }

    protected synchronized boolean _areThreadsDeadlocked() {
        return this._readBlockedQueues.size() + this._writeBlockedQueues.size() + this._delayBlockCount >= this._getActiveThreadsCount();
    }

    protected synchronized void _informOfDelayBlock() {
        ++this._delayBlockCount;
        ((Object)((Object)this)).notifyAll();
    }

    protected synchronized void _informOfDelayUnblock() {
        --this._delayBlockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _resolveDeadlock() throws IllegalActionException {
        if (this._writeBlockedQueues.size() != 0) {
            this._incrementLowestWriteCapacityPort();
            return true;
        }
        if (this._delayBlockCount == 0) {
            return false;
        }
        TimedPNDirector timedPNDirector = this;
        synchronized (timedPNDirector) {
            if (this._eventQueue.isEmpty()) {
                throw new InternalErrorException("Inconsistency in number of actors blocked on delays count and the entries in the CalendarQueue");
            }
            TimedEvent event = (TimedEvent)this._eventQueue.take();
            this.setModelTime(event.timeStamp);
            this._informOfDelayUnblock();
            boolean sameTime = true;
            while (sameTime) {
                if (!this._eventQueue.isEmpty()) {
                    TimedEvent event2 = (TimedEvent)this._eventQueue.take();
                    Actor actor = (Actor)event2.contents;
                    Time newTime = event2.timeStamp;
                    if (newTime.equals((Object)this.getModelTime())) {
                        this._informOfDelayUnblock();
                        continue;
                    }
                    this._eventQueue.put((Object)new TimedEvent(newTime, (Object)actor));
                    sameTime = false;
                    continue;
                }
                sameTime = false;
            }
            ((Object)((Object)this)).notifyAll();
        }
        return true;
    }
}

