/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel;

import java.util.Iterator;
import ptolemy.actor.Actor;
import ptolemy.domains.ct.kernel.CTBaseIntegrator;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTSchedule;
import ptolemy.domains.ct.kernel.CTScheduler;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public abstract class ODESolver
extends NamedObj {
    private CTDirector _director = null;
    private boolean _isConverged = false;
    private int _roundCount = 0;

    public ODESolver(Workspace workspace) {
        super(workspace);
    }

    public void fireDynamicActors() throws IllegalActionException {
        if (this._debugging) {
            this._debug(String.valueOf(this.getFullName()) + " firing dynamic actors ...");
        }
        CTSchedule schedule = this._getSchedule();
        Iterator actors = schedule.get(2).actorIterator();
        while (actors.hasNext()) {
            Actor next = (Actor)actors.next();
            if (this._debugging) {
                this._debug("  firing..." + next.getFullName());
            }
            next.fire();
        }
        this._advanceModelTime();
    }

    public void fireStateTransitionActors() throws IllegalActionException {
        if (this._debugging) {
            this._debug(String.valueOf(this.getFullName()) + " firing state transition actors ...");
        }
        CTSchedule schedule = this._getSchedule();
        Iterator actors = schedule.get(6).actorIterator();
        while (actors.hasNext()) {
            Actor next = (Actor)actors.next();
            if (!next.prefire()) {
                throw new IllegalActionException((Nameable)next, "Expected prefire() to return true!\nPerhaps a continuous input is being driven by a discrete output?");
            }
            if (this._debugging) {
                this._debug("  firing..." + next.getFullName());
            }
            next.fire();
        }
    }

    public abstract int getAmountOfHistoryInformation();

    public final NamedObj getContainer() {
        return this._director;
    }

    public abstract int getIntegratorAuxVariableCount();

    public abstract void integratorFire(CTBaseIntegrator var1) throws IllegalActionException;

    public abstract boolean integratorIsAccurate(CTBaseIntegrator var1);

    public abstract double integratorPredictedStepSize(CTBaseIntegrator var1);

    public boolean resolveStates() throws IllegalActionException {
        return true;
    }

    protected void _advanceModelTime() throws IllegalActionException {
    }

    protected int _getRoundCount() {
        return this._roundCount;
    }

    protected CTSchedule _getSchedule() throws IllegalActionException {
        CTDirector director = (CTDirector)this.getContainer();
        if (director == null) {
            throw new IllegalActionException((Nameable)this, " must have a CT director.");
        }
        CTScheduler scheduler = (CTScheduler)director.getScheduler();
        if (scheduler == null) {
            throw new IllegalActionException((Nameable)director, " does not contain a valid scheduler.");
        }
        return (CTSchedule)scheduler.getSchedule();
    }

    protected void _incrementRoundCount() {
        ++this._roundCount;
    }

    protected boolean _isConverged() {
        return this._isConverged;
    }

    protected void _makeSolverOf(CTDirector director) {
        this._director = director;
        if (director != null) {
            this.workspace().remove((NamedObj)this);
        }
    }

    protected void _resetRoundCount() {
        this._roundCount = 0;
    }

    protected void _setConverged(boolean converged) {
        this._isConverged = converged;
    }

    protected void _voteForConverged(boolean converged) {
        this._setConverged(converged && this._isConverged());
    }
}

