/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.io;

import java.io.BufferedReader;
import java.io.IOException;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Source;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class LineReader
extends Source {
    public TypedIOPort endOfFile;
    public FileParameter fileOrURL;
    public Parameter numberOfLinesToSkip;
    protected String _currentLine;
    protected BufferedReader _reader;
    private boolean _firedSinceWrapup = false;
    private String _previousFileOrURL;
    private boolean _reachedEOF = false;

    public LineReader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals((Type)BaseType.STRING);
        this.endOfFile = new TypedIOPort((ComponentEntity)this, "endOfFile", false, true);
        this.endOfFile.setTypeEquals((Type)BaseType.BOOLEAN);
        this.fileOrURL = new FileParameter((NamedObj)this, "fileOrURL");
        this.numberOfLinesToSkip = new Parameter((NamedObj)this, "numberOfLinesToSkip");
        this.numberOfLinesToSkip.setExpression("0");
        this.numberOfLinesToSkip.setTypeEquals((Type)BaseType.INT);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-25\" y=\"-20\" width=\"50\" height=\"40\" style=\"fill:white\"/>\n<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10 15,-10 15,10, -15,10\" style=\"fill:red\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.fileOrURL) {
            String newFileOrURL = ((StringToken)this.fileOrURL.getToken()).stringValue();
            if (this._previousFileOrURL != null && !newFileOrURL.equals(this._previousFileOrURL)) {
                this._previousFileOrURL = newFileOrURL;
                this.fileOrURL.close();
                this._reader = this.fileOrURL.getExpression().trim().equals("") ? null : this.fileOrURL.openForReading();
                this._reachedEOF = false;
            }
        } else if (attribute == this.numberOfLinesToSkip) {
            int linesToSkip = ((IntToken)this.numberOfLinesToSkip.getToken()).intValue();
            if (linesToSkip < 0) {
                throw new IllegalActionException((Nameable)this, "The number of lines to skip cannot be negative.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        LineReader newObject = (LineReader)((Object)super.clone(workspace));
        newObject._currentLine = null;
        newObject._reachedEOF = false;
        newObject._reader = null;
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this._currentLine != null) {
            this.output.broadcast((Token)new StringToken(this._currentLine));
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this._firedSinceWrapup) {
            this.fileOrURL.close();
            this._reader = null;
            this._openAndReadFirstLine();
        }
    }

    public boolean postfire() throws IllegalActionException {
        block4: {
            if (this._reader == null) {
                return false;
            }
            try {
                this._currentLine = this._reader.readLine();
                if (this._currentLine != null) break block4;
                this._currentLine = "EOF";
                this._reachedEOF = true;
                this.endOfFile.broadcast((Token)BooleanToken.TRUE);
                return false;
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, (Throwable)ex, "Postfire failed");
            }
        }
        this.endOfFile.broadcast((Token)BooleanToken.FALSE);
        return super.postfire();
    }

    public boolean prefire() throws IllegalActionException {
        this._firedSinceWrapup = true;
        if (this._reachedEOF) {
            return false;
        }
        return super.prefire();
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._openAndReadFirstLine();
    }

    public void wrapup() throws IllegalActionException {
        this.fileOrURL.close();
        this._reader = null;
        this._firedSinceWrapup = false;
    }

    private void _openAndReadFirstLine() throws IllegalActionException {
        this._reader = this.fileOrURL.openForReading();
        this._reachedEOF = false;
        try {
            int numberOfLines = ((IntToken)this.numberOfLinesToSkip.getToken()).intValue();
            int i = 0;
            while (i <= numberOfLines) {
                this._currentLine = this._reader.readLine();
                if (this._currentLine == null) {
                    throw new IllegalActionException((Nameable)this, "The file '" + this.fileOrURL.stringValue() + "' does not " + "have enough lines.");
                }
                ++i;
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, (Throwable)ex, "Preinitialize failed.");
        }
    }
}

