/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.QueueReceiver;
import ptolemy.actor.Receiver;
import ptolemy.actor.lib.hoc.MirrorComposite;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.util.MessageHandler;

public class RealTimeComposite
extends MirrorComposite {
    public Parameter delay;
    private double _delayValue = 0.0;
    private List<Time> _fireAtTimes = Collections.synchronizedList(new LinkedList());
    private DelayQueue<InputFrame> _inputFrames = new DelayQueue();
    private List<OutputFrame> _outputFrames = Collections.synchronizedList(new LinkedList());
    private long _realStartTime = 0L;
    private Queue<Time> _responseTimes = new LinkedList<Time>();

    public RealTimeComposite(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setClassName("ptolemy.actor.lib.hoc.RealTimeComposite");
        new RealTimeDirector((CompositeEntity)this, "RealTimeDirector");
        Parameter UNDEFINED = new Parameter((NamedObj)this, "UNDEFINED");
        UNDEFINED.setVisibility(Settable.EXPERT);
        UNDEFINED.setPersistent(false);
        UNDEFINED.setExpression("-1.0");
        this.delay = new Parameter((NamedObj)this, "delay");
        this.delay.setTypeEquals((Type)BaseType.DOUBLE);
        this.delay.setExpression("UNDEFINED");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.delay) {
            this._delayValue = ((DoubleToken)this.delay.getToken()).doubleValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    public boolean fireContainedActors() throws IllegalActionException {
        Iterator actors = this.entityList().iterator();
        boolean postfireReturns = true;
        block0: while (actors.hasNext() && !this._stopRequested) {
            Actor actor = (Actor)actors.next();
            if (!((ComponentEntity)actor).isOpaque()) {
                throw new IllegalActionException((Nameable)this, "Inside actor is not opaque (perhaps it needs a director).");
            }
            int result = 0;
            while (result != 1) {
                if (this._debugging) {
                    this._debug("Iterating actor: " + actor.getFullName());
                }
                if (this._debugging) {
                    this._debug("---- Iterating actor in associated thread: " + actor.getFullName());
                }
                result = actor.iterate(1);
                boolean outOfData = true;
                block2: for (IOPort port : actor.inputPortList()) {
                    int i = 0;
                    while (i < port.getWidth()) {
                        if (port.hasToken(i)) {
                            outOfData = false;
                            continue block2;
                        }
                        ++i;
                    }
                }
                if (outOfData) continue block0;
                if (result != 2) continue;
                if (this._debugging) {
                    this._debug("---- Actor requests halt: " + actor.getFullName());
                }
                postfireReturns = false;
                continue block0;
            }
        }
        return postfireReturns;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InputFrame
    implements Delayed {
        public final Time time;
        public final List<QueuedToken> tokens;

        public InputFrame(Time theTime, List<QueuedToken> theTokens) {
            this.tokens = theTokens;
            this.time = theTime;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long elapsedTime = System.currentTimeMillis() - RealTimeComposite.this._realStartTime;
            double elapsedTimeInSeconds = (double)elapsedTime / 1000.0;
            long timeToWait = (long)(this.time.subtract(elapsedTimeInSeconds).getDoubleValue() * 1000.0);
            return unit.convert(timeToWait, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed frame) {
            return this.time.compareTo((Object)((InputFrame)frame).time);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputFrame {
        public final Time time;
        public final List<QueuedToken> tokens;

        public OutputFrame(Time theTime, List<QueuedToken> theTokens) {
            this.tokens = theTokens;
            this.time = theTime;
        }
    }

    private static class QueuedToken {
        public final int channel;
        public final Token token;
        public final IOPort port;

        public QueuedToken(IOPort thePort, int theChannel, Token theToken) {
            this.token = theToken;
            this.channel = theChannel;
            this.port = thePort;
        }

        public String toString() {
            return "token " + this.token + " for port " + this.port.getFullName() + "(" + this.channel + ")";
        }
    }

    private class RealTimeDirector
    extends Director {
        private List<QueuedToken> _inputTokens;
        private Thread _thread;

        public RealTimeDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            this.setPersistent(false);
        }

        public void fire() throws IllegalActionException {
            if (RealTimeComposite.this._realStartTime < 0L) {
                RealTimeComposite.this._realStartTime = System.currentTimeMillis();
            }
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            if (RealTimeComposite.this._delayValue == 0.0) {
                long modelTimeMillis;
                long realTimeMillis = System.currentTimeMillis() - RealTimeComposite.this._realStartTime;
                if (realTimeMillis < (modelTimeMillis = Math.round(environmentTime.getDoubleValue() * 1000.0))) {
                    try {
                        Thread.sleep(modelTimeMillis - realTimeMillis);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                super.fire();
            } else {
                Time responseTime;
                if (RealTimeComposite.this._delayValue > 0.0 && (responseTime = (Time)RealTimeComposite.this._responseTimes.peek()) != null && responseTime.equals((Object)environmentTime)) {
                    RealTimeComposite.this._responseTimes.poll();
                    long realTimeMillis = System.currentTimeMillis() - RealTimeComposite.this._realStartTime;
                    long modelTimeMillis = Math.round(environmentTime.getDoubleValue() * 1000.0);
                    if (realTimeMillis < modelTimeMillis) {
                        try {
                            Thread.sleep(modelTimeMillis - realTimeMillis);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (RealTimeComposite.this._outputFrames.size() > 0) {
                    OutputFrame frame = (OutputFrame)RealTimeComposite.this._outputFrames.get(0);
                    if (frame.time.equals((Object)environmentTime)) {
                        for (QueuedToken token : frame.tokens) {
                            if (token.channel >= token.port.getWidth()) continue;
                            token.port.send(token.channel, token.token);
                        }
                    }
                }
                Thread.yield();
            }
        }

        public void fireAt(Actor actor, Time time) throws IllegalActionException {
            Director director = RealTimeComposite.this.getExecutiveDirector();
            if (director != null) {
                if (((NamedObj)RealTimeComposite.this)._debugging) {
                    RealTimeComposite.this._debug("---- Actor requests firing at time " + time + ": " + actor.getFullName());
                }
                director.fireAt((Actor)RealTimeComposite.this, time);
            }
            if (actor != RealTimeComposite.this) {
                RealTimeComposite.this._fireAtTimes.add(time);
            }
        }

        public void fireAtCurrentTime(Actor actor) throws IllegalActionException {
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, new LinkedList<QueuedToken>()));
            Director director = RealTimeComposite.this.getExecutiveDirector();
            if (director != null) {
                Time time = new Time((Director)this, (double)(System.currentTimeMillis() - RealTimeComposite.this._realStartTime) / 1000.0);
                if (((NamedObj)RealTimeComposite.this)._debugging) {
                    RealTimeComposite.this._debug("----- fireAtCurrentTime() request by actor " + actor.getFullName() + ". Model time is " + environmentTime + ", and real time is " + time);
                }
                director.fireAt((Actor)RealTimeComposite.this, time);
            }
        }

        public Time getModelTime() {
            if (RealTimeComposite.this._delayValue == 0.0) {
                return ((Actor)this.getContainer()).getExecutiveDirector().getModelTime();
            }
            return this._currentTime;
        }

        public void initialize() throws IllegalActionException {
            RealTimeComposite.this._fireAtTimes.clear();
            super.initialize();
            RealTimeComposite.this._realStartTime = -1L;
            if (RealTimeComposite.this._delayValue != 0.0) {
                RealTimeComposite.this._inputFrames.clear();
                RealTimeComposite.this._outputFrames.clear();
                RealTimeComposite.this._responseTimes.clear();
                this._thread = new RealTimeThread();
                this._thread.setPriority(10);
                this._thread.start();
            }
        }

        public Receiver newReceiver() {
            return new QueueReceiver();
        }

        public boolean prefire() throws IllegalActionException {
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            if (((NamedObj)RealTimeComposite.this)._debugging) {
                RealTimeComposite.this._debug("----- Current environment time is: " + environmentTime);
            }
            if (RealTimeComposite.this._delayValue != 0.0) {
                this._inputTokens = new LinkedList<QueuedToken>();
                return this._thread.isAlive();
            }
            return true;
        }

        public boolean postfire() throws IllegalActionException {
            boolean result = super.postfire();
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            if (RealTimeComposite.this._delayValue != 0.0) {
                Time fireAtTime;
                if (this._inputTokens.size() > 0) {
                    if (((NamedObj)RealTimeComposite.this)._debugging) {
                        RealTimeComposite.this._debug("Queueing input tokens for the associated thread: " + this._inputTokens.toString() + " to be processed at time " + environmentTime);
                    }
                    RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, this._inputTokens));
                    if (RealTimeComposite.this._delayValue > 0.0) {
                        Time responseTime = environmentTime.add(RealTimeComposite.this._delayValue);
                        this.fireAt((Actor)RealTimeComposite.this, responseTime);
                        RealTimeComposite.this._responseTimes.add(responseTime);
                    }
                }
                if (RealTimeComposite.this._fireAtTimes.size() > 0 && (fireAtTime = (Time)RealTimeComposite.this._fireAtTimes.get(0)).equals((Object)environmentTime)) {
                    RealTimeComposite.this._fireAtTimes.remove(0);
                    if (this._inputTokens.size() == 0) {
                        if (((NamedObj)RealTimeComposite.this)._debugging) {
                            RealTimeComposite.this._debug("Queueing pure event for the associated thread,  to be processed at time " + environmentTime);
                        }
                        RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, this._inputTokens));
                        if (RealTimeComposite.this._delayValue > 0.0) {
                            Time responseTime = environmentTime.add(RealTimeComposite.this._delayValue);
                            this.fireAt((Actor)RealTimeComposite.this, responseTime);
                            RealTimeComposite.this._responseTimes.add(responseTime);
                        }
                    }
                }
                if (RealTimeComposite.this._outputFrames.size() > 0) {
                    OutputFrame frame = (OutputFrame)RealTimeComposite.this._outputFrames.get(0);
                    if (frame.time.equals((Object)environmentTime)) {
                        RealTimeComposite.this._outputFrames.remove(0);
                    }
                }
                result = this._thread.isAlive();
            }
            return result;
        }

        public void stop() {
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            if (RealTimeComposite.this._delayValue != 0.0) {
                if (((NamedObj)RealTimeComposite.this)._debugging) {
                    RealTimeComposite.this._debug("Queueing a stop-frame token for the associated thread with time: " + environmentTime);
                }
                RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, null));
            } else {
                super.stop();
            }
        }

        public boolean transferInputs(IOPort port) throws IllegalActionException {
            if (RealTimeComposite.this._delayValue == 0.0) {
                return super.transferInputs(port);
            }
            boolean result = false;
            int i = 0;
            while (i < port.getWidth()) {
                try {
                    if (port.isKnown(i) && port.hasToken(i)) {
                        Token token = port.get(i);
                        this._inputTokens.add(new QueuedToken(port, i, token));
                        if (((NamedObj)RealTimeComposite.this)._debugging) {
                            RealTimeComposite.this._debug(this.getName(), "transferring input from " + port.getName());
                        }
                        result = true;
                    }
                }
                catch (NoTokenException ex) {
                    throw new InternalErrorException((Nameable)this, (Throwable)ex, null);
                }
                ++i;
            }
            return result;
        }

        public boolean transferOutputs(IOPort port) throws IllegalActionException {
            if (RealTimeComposite.this._delayValue == 0.0) {
                return super.transferOutputs(port);
            }
            Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
            double realTimeInSeconds = (double)(System.currentTimeMillis() - RealTimeComposite.this._realStartTime) / 1000.0;
            if (environmentTime.getDoubleValue() >= realTimeInSeconds) {
                return super.transferOutputs(port);
            }
            environmentTime = new Time((Director)this, realTimeInSeconds);
            LinkedList<QueuedToken> outputTokens = new LinkedList<QueuedToken>();
            int i = 0;
            while (i < port.getWidth()) {
                try {
                    if (port.isKnownInside(i) && port.hasTokenInside(i)) {
                        Token token = port.getInside(i);
                        outputTokens.add(new QueuedToken(port, i, token));
                        if (((NamedObj)RealTimeComposite.this)._debugging) {
                            RealTimeComposite.this._debug(this.getName(), "transferring output from " + port.getName() + " with value " + token);
                        }
                    }
                }
                catch (NoTokenException ex) {
                    throw new InternalErrorException((Nameable)this, (Throwable)ex, null);
                }
                ++i;
            }
            if (outputTokens.size() > 0) {
                OutputFrame frame = new OutputFrame(environmentTime, outputTokens);
                RealTimeComposite.this._outputFrames.add(frame);
                this.fireAt((Actor)RealTimeComposite.this, environmentTime);
            }
            return false;
        }

        public void wrapup() throws IllegalActionException {
            if (RealTimeComposite.this._delayValue != 0.0) {
                Time environmentTime = RealTimeComposite.this.getExecutiveDirector().getModelTime();
                if (((NamedObj)RealTimeComposite.this)._debugging) {
                    RealTimeComposite.this._debug("Queueing a stop-frame token for the associated thread with time: " + environmentTime);
                }
                RealTimeComposite.this._inputFrames.put(new InputFrame(environmentTime, null));
                try {
                    if (((NamedObj)RealTimeComposite.this)._debugging) {
                        RealTimeComposite.this._debug("Waiting for associated thread to stop.");
                    }
                    this._thread.join();
                    if (((NamedObj)RealTimeComposite.this)._debugging) {
                        RealTimeComposite.this._debug("Associated thread has stopped.");
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            super.wrapup();
        }

        private class RealTimeThread
        extends Thread {
            public RealTimeThread() {
                super("RealTimeThread");
            }

            public void run() {
                while (!RealTimeDirector.this._stopRequested) {
                    try {
                        if (((NamedObj)RealTimeComposite.this)._debugging) {
                            RealTimeComposite.this._debug("---- Waiting for inputs in the associated thread.");
                        }
                        InputFrame frame = (InputFrame)RealTimeComposite.this._inputFrames.take();
                        if (frame.tokens == null) {
                            if (!((NamedObj)RealTimeComposite.this)._debugging) break;
                            RealTimeComposite.this._debug("---- Read a stop frame in associated thread.");
                            break;
                        }
                        if (((NamedObj)RealTimeComposite.this)._debugging) {
                            RealTimeComposite.this._debug("---- Reading input tokens in associated thread with time " + frame.time + " and value " + frame.tokens);
                        }
                        RealTimeDirector.this._currentTime = frame.time;
                        for (QueuedToken token : frame.tokens) {
                            if (token.channel >= token.port.getWidthInside()) continue;
                            token.port.sendInside(token.channel, token.token);
                        }
                        boolean postfireReturnsTrue = RealTimeComposite.this.fireContainedActors();
                        if (RealTimeComposite.this._delayValue != 0.0) {
                            for (IOPort port : RealTimeComposite.this.outputPortList()) {
                                boolean hasOutputs = false;
                                int i = 0;
                                while (i < port.getWidth()) {
                                    if (port.isKnownInside(i) && port.hasTokenInside(i)) {
                                        hasOutputs = true;
                                    }
                                    ++i;
                                }
                                if (!hasOutputs) continue;
                                RealTimeDirector.this.transferOutputs(port);
                            }
                        }
                        if (postfireReturnsTrue) continue;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    catch (IllegalActionException ex) {
                        MessageHandler.error((String)"Error in real-time thread.", (Throwable)ex);
                    }
                }
            }
        }
    }
}

