/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.XMLToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class StringToXML
extends Transformer {
    private XMLToken _outToken;

    public StringToXML(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeEquals((Type)BaseType.STRING);
        this.output.setMultiport(true);
        this.output.setTypeEquals((Type)BaseType.XMLTOKEN);
    }

    public void fire() throws IllegalActionException {
        super.fire();
        int i = 0;
        while (i < this.input.getWidth()) {
            if (this.input.hasToken(i)) {
                StringToken in = (StringToken)this.input.get(i);
                try {
                    this._outToken = new XMLToken(in.stringValue());
                    this.output.broadcast((Token)this._outToken);
                }
                catch (Exception ex) {
                    throw new IllegalActionException((Nameable)this, (Throwable)ex, "Can't construct an XML Token from '" + in + "'");
                }
            }
            ++i;
        }
    }

    public boolean prefire() throws IllegalActionException {
        int i = 0;
        while (i < this.input.getWidth()) {
            if (this.input.hasToken(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

