/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.math.Complex;

public class Slicer
extends Transformer {
    public Parameter table;
    public Parameter wordLength;
    private int _wordLength;
    private int _size;
    private Complex[] _table;
    private Parameter _outputRate;

    public Slicer(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.COMPLEX);
        new Parameter((NamedObj)this.input, "tokenConsumptionRate", (Token)new IntToken(1));
        this.output.setTypeEquals((Type)BaseType.BOOLEAN);
        this._outputRate = new Parameter((NamedObj)this.output, "tokenProductionRate", (Token)new IntToken(1));
        this.table = new Parameter((NamedObj)this, "table");
        this.table.setTypeEquals((Type)new ArrayType((Type)BaseType.COMPLEX));
        this.table.setExpression("{-1.0, 1.0}");
        this.wordLength = new Parameter((NamedObj)this, "wordLength", (Token)new IntToken(1));
        this.wordLength.setTypeEquals((Type)BaseType.INT);
    }

    public void fire() throws IllegalActionException {
        super.fire();
        ComplexToken inputToken = (ComplexToken)this.input.get(0);
        int index = 0;
        double distance = this._computeEuclideanDistance(this._table[0], inputToken.complexValue());
        int i = 1;
        while (i < this._size) {
            double tempDistance = this._computeEuclideanDistance(this._table[i], inputToken.complexValue());
            if (tempDistance < distance) {
                index = i;
                distance = tempDistance;
            }
            ++i;
        }
        BooleanToken[] result = new BooleanToken[this._wordLength];
        int i2 = 0;
        while (i2 < this._wordLength) {
            result[i2] = new BooleanToken((index & 1) == 1);
            index >>= 1;
            ++i2;
        }
        this.output.broadcast((Token[])result, this._wordLength);
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._wordLength = ((IntToken)this.wordLength.getToken()).intValue();
        this._outputRate.setToken((Token)new IntToken(this._wordLength));
        ArrayToken tableToken = (ArrayToken)this.table.getToken();
        this._size = 1 << this._wordLength;
        if (tableToken.length() < this._size) {
            this._size = tableToken.length();
        }
        this._table = new Complex[this._size];
        int i = 0;
        while (i < this._size) {
            this._table[i] = ((ComplexToken)tableToken.getElement(i)).complexValue();
            ++i;
        }
    }

    private double _computeEuclideanDistance(Complex x, Complex y) {
        Complex z = x.subtract(y);
        return z.magnitude();
    }
}

