/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.statistics;

import com.isencia.passerelle.statistics.InsufficientDataException;
import com.isencia.passerelle.statistics.StatisticalLongData;
import java.util.Date;

final class CycleStatistics {
    private boolean idle = true;
    private Date lastCycleStartTime;
    private Date lastCycleEndTime = new Date();
    private StatisticalLongData idleData = new StatisticalLongData();
    private StatisticalLongData cycleData = new StatisticalLongData();

    CycleStatistics() {
    }

    public void reset() {
        this.lastCycleStartTime = null;
        this.lastCycleEndTime = new Date();
        this.idle = true;
        this.idleData.reset();
        this.cycleData.reset();
    }

    public void acceptCycleBegin() throws IllegalStateException {
        if (!this.idle) {
            throw new IllegalStateException("Not idle");
        }
        this.idle = false;
        this.lastCycleStartTime = new Date();
        this.idleData.acceptData(this.lastCycleStartTime.getTime() - this.lastCycleEndTime.getTime());
    }

    public void acceptCycleEnd() throws IllegalStateException {
        if (this.idle) {
            throw new IllegalStateException("Idle");
        }
        this.idle = true;
        this.lastCycleEndTime = new Date();
        this.cycleData.acceptData(this.lastCycleEndTime.getTime() - this.lastCycleStartTime.getTime());
    }

    public long getAvgIdleTime() throws InsufficientDataException {
        return this.idleData.getAvgData();
    }

    public long getMinIdleTime() throws InsufficientDataException {
        return this.idleData.getMinData();
    }

    public long getMaxIdleTime() throws InsufficientDataException {
        return this.idleData.getMaxData();
    }

    public long getAvgProcessingTime() throws InsufficientDataException {
        return this.cycleData.getAvgData();
    }

    public long getMinProcessingTime() throws InsufficientDataException {
        return this.cycleData.getMinData();
    }

    public long getMaxProcessingTime() throws InsufficientDataException {
        return this.cycleData.getMaxData();
    }

    public long getNrCycles() {
        return this.cycleData.getCount();
    }
}

