/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.model;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.engine.activator.Activator;
import com.isencia.passerelle.ext.ErrorCollector;
import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.model.FlowAlreadyExecutingException;
import com.isencia.passerelle.model.FlowHandle;
import com.isencia.passerelle.model.FlowNotExecutingException;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.model.util.RESTFacade;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;

public class FlowManager {
    private Map<Flow, Manager> flowExecutions = new HashMap<Flow, Manager>();
    private static RESTFacade restFacade;

    public static void writeMoml(Flow flow, Writer writer) throws IOException {
        String string = flow.exportMoML();
        writer.append(string);
        writer.flush();
    }

    public static Collection<FlowHandle> getFlowsFromResourceLocation(URL uRL) throws PasserelleException {
        if (uRL == null) {
            return null;
        }
        ArrayList<FlowHandle> arrayList = null;
        String string = uRL.getProtocol();
        if ("http".equals(string) || "https".equals(string)) {
            if (restFacade == null) {
                FlowManager.initRESTFacade();
            }
            arrayList = restFacade.getAllRemoteFlowHandles(uRL);
        } else if ("file".equals(string)) {
            arrayList = new ArrayList<FlowHandle>();
            try {
                File file = new File(uRL.toURI());
                if (file != null && file.exists()) {
                    File[] fileArray;
                    FilenameFilter filenameFilter = new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string) {
                            return string.endsWith(".moml");
                        }
                    };
                    File[] fileArray2 = fileArray = file.listFiles(filenameFilter);
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file2 = fileArray2[n2];
                        FlowHandle flowHandle = new FlowHandle(null, file2.getName(), file2.toURL());
                        arrayList.add(flowHandle);
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                throw new PasserelleException("Error reading flows from " + uRL, null, exception);
            }
        }
        return arrayList != null ? arrayList : new ArrayList<FlowHandle>();
    }

    public static Flow readMoml(Reader reader) throws Exception {
        return FlowManager.readMoml(reader, Activator.class.getClassLoader());
    }

    public static Flow readMoml(Reader reader, ClassLoader classLoader) throws Exception {
        MoMLParser moMLParser = new MoMLParser(null, classLoader);
        NamedObj namedObj = moMLParser.parse(null, reader);
        return (Flow)namedObj;
    }

    public static Flow readMoml(URL uRL) throws Exception {
        ClassLoader classLoader = null;
        try {
            classLoader = Activator.class.getClassLoader();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            classLoader = FlowManager.class.getClassLoader();
        }
        return FlowManager.readMoml(uRL, classLoader);
    }

    public static Flow readMoml(URL uRL, ClassLoader classLoader) throws Exception {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getProtocol();
        if ("file".equals(string) || "jar".equals(string)) {
            MoMLParser moMLParser = new MoMLParser(null, classLoader);
            MoMLParser.purgeModelRecord(uRL);
            Flow flow = (Flow)moMLParser.parse(null, uRL);
            return flow;
        }
        if ("http".equals(string) || "https".equals(string)) {
            if (restFacade == null) {
                FlowManager.initRESTFacade();
            }
            FlowHandle flowHandle = restFacade.getRemoteFlowHandle(uRL);
            Flow flow = FlowManager.readMoml(new StringReader(flowHandle.getMoml()));
            flow.setHandle(flowHandle);
            return flow;
        }
        throw new IllegalArgumentException("Unsupported URL protocol " + string);
    }

    public static Flow readXmi(Reader reader) throws IOException {
        return null;
    }

    public static void writeXmi(Flow flow, Writer writer) throws IOException {
    }

    public void executeBlocking(Flow flow, Map<String, String> map) throws FlowAlreadyExecutingException, PasserelleException {
        if (this.flowExecutions.get((Object)flow) != null) {
            throw new FlowAlreadyExecutingException("", (Object)flow, null);
        }
        if (map != null) {
            this.applyParameterSettings(flow, map);
        }
        try {
            Manager manager = new Manager(flow.workspace(), flow.getName());
            flow.setManager(manager);
            this.flowExecutions.put(flow, manager);
            manager.execute();
            this.stopExecution(flow);
        }
        catch (IllegalActionException illegalActionException) {
            throw new FlowAlreadyExecutingException("", (Object)flow, illegalActionException);
        }
        catch (KernelException kernelException) {
            throw new PasserelleException("", (Object)flow, kernelException);
        }
    }

    public void executeBlockingError(Flow flow, Map<String, String> map) throws FlowAlreadyExecutingException, PasserelleException {
        if (this.flowExecutions.get((Object)flow) != null) {
            throw new FlowAlreadyExecutingException("", (Object)flow, null);
        }
        if (map != null) {
            this.applyParameterSettings(flow, map);
        }
        ModelExecutionListener modelExecutionListener = new ModelExecutionListener();
        try {
            Manager manager = new Manager(flow.workspace(), flow.getName());
            flow.setManager(manager);
            this.flowExecutions.put(flow, manager);
            com.isencia.passerelle.domain.cap.Director director = (com.isencia.passerelle.domain.cap.Director)flow.getDirector();
            director.removeAllErrorCollectors();
            director.addErrorCollector(modelExecutionListener);
            manager.addExecutionListener((ExecutionListener)modelExecutionListener);
            manager.execute();
            this.stopExecution(flow);
        }
        catch (IllegalActionException illegalActionException) {
            throw new FlowAlreadyExecutingException("", (Object)flow, illegalActionException);
        }
        catch (KernelException kernelException) {
            throw new PasserelleException("", (Object)flow, kernelException);
        }
        try {
            modelExecutionListener.illegalActionExceptionOccured();
        }
        catch (IllegalActionException illegalActionException) {
            throw new PasserelleException("Execution Error", (Object)flow, illegalActionException);
        }
        modelExecutionListener.passerelleExceptionOccured();
        try {
            modelExecutionListener.otherExceptionOccured();
        }
        catch (Throwable throwable) {
            throw new PasserelleException("UNKNOWN Execution Error", (Object)flow, throwable);
        }
    }

    public void executeNonBlocking(Flow flow, Map<String, String> map) throws FlowAlreadyExecutingException {
        if (this.flowExecutions.get((Object)flow) != null) {
            throw new FlowAlreadyExecutingException("", (Object)flow, null);
        }
        if (map != null) {
            this.applyParameterSettings(flow, map);
        }
        try {
            Manager manager = new Manager(flow.workspace(), flow.getName());
            flow.setManager(manager);
            this.flowExecutions.put(flow, manager);
            manager.startRun();
        }
        catch (IllegalActionException illegalActionException) {
            throw new FlowAlreadyExecutingException("", (Object)flow, illegalActionException);
        }
    }

    public void executeOnServer(Flow flow, Map<String, String> map) throws IllegalStateException, IllegalArgumentException, PasserelleException {
        if (restFacade == null) {
            FlowManager.initRESTFacade();
        }
        restFacade.startFlowRemotely(flow.getHandle());
    }

    public Manager.State getExecutionState(Flow flow) throws FlowNotExecutingException {
        Manager manager = this.flowExecutions.get((Object)flow);
        if (manager == null) {
            throw new FlowNotExecutingException("", (Object)flow, null);
        }
        return manager.getState();
    }

    public void stopExecution(Flow flow) throws FlowNotExecutingException {
        Manager manager = this.flowExecutions.get((Object)flow);
        if (manager == null) {
            throw new FlowNotExecutingException("", (Object)flow, null);
        }
        manager.stop();
        try {
            manager.wrapup();
        }
        catch (IllegalActionException illegalActionException) {
        }
        catch (KernelException kernelException) {}
        this.flowExecutions.remove((Object)flow);
        try {
            flow.setManager(null);
        }
        catch (IllegalActionException illegalActionException) {}
    }

    public void applyParameterSettings(Flow flow, Map<String, String> map) {
        this.applyParameterSettings(flow, map, null);
    }

    public void applyParameterSettings(Flow flow, Map<String, String> map, Map<String, Object> map2) {
        block4: for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String[] stringArray = string.split("[\\.]");
            if (stringArray.length < 2) continue;
            Flow flow2 = flow;
            int n = 0;
            while (n < stringArray.length - 1) {
                Director director;
                if (!(flow2 instanceof CompositeActor)) continue block4;
                ComponentEntity componentEntity = ((CompositeActor)flow2).getEntity(stringArray[n]);
                if (componentEntity == null) {
                    try {
                        Parameter parameter;
                        director = ((CompositeActor)flow2).getDirector();
                        if (director != null && (parameter = (Parameter)director.getAttribute(stringArray[stringArray.length - 1], Parameter.class)) != null) {
                            parameter.setExpression(string2);
                        }
                    }
                    catch (IllegalActionException illegalActionException) {}
                } else if ((flow2 = ((CompositeActor)flow2).getEntity(stringArray[n])) != null) {
                    try {
                        director = (Parameter)flow2.getAttribute(stringArray[stringArray.length - 1], Parameter.class);
                        if (director != null) {
                            director.setExpression(string2);
                        }
                    }
                    catch (IllegalActionException illegalActionException) {}
                }
                ++n;
            }
        }
    }

    private static void initRESTFacade() {
        restFacade = new RESTFacade(10000, 10000);
    }

    protected class ModelExecutionListener
    implements ExecutionListener,
    ErrorCollector {
        private Throwable throwable;

        protected ModelExecutionListener() {
        }

        @Override
        public void acceptError(PasserelleException passerelleException) {
            this.executionError(null, passerelleException);
        }

        public void executionError(Manager manager, Throwable throwable) {
            this.throwable = throwable;
            System.out.println("executionError :" + throwable.getClass());
        }

        public void executionFinished(Manager manager) {
        }

        public void managerStateChanged(Manager manager) {
        }

        public void illegalActionExceptionOccured() throws IllegalActionException {
            Throwable throwable;
            if (this.throwable != null && (throwable = this.throwable) instanceof IllegalActionException) {
                this.throwable = null;
                throw (IllegalActionException)throwable;
            }
        }

        public void passerelleExceptionOccured() throws PasserelleException {
            Throwable throwable;
            if (this.throwable != null && (throwable = this.throwable) instanceof PasserelleException) {
                this.throwable = null;
                throw (PasserelleException)throwable;
            }
        }

        public void otherExceptionOccured() throws Throwable {
            Throwable throwable;
            if (this.throwable != null && !((throwable = this.throwable) instanceof IllegalActionException) && !(throwable instanceof PasserelleException)) {
                this.throwable = null;
                throw throwable;
            }
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

