/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.type;

import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.type.ConverterBase;
import java.lang.reflect.Constructor;
import ptolemy.data.LongToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class LongConverter
extends ConverterBase {
    @Override
    protected boolean areTypesCompatible(Class clazz, Type type) {
        boolean bl = BaseType.LONG.equals((Object)type);
        if (clazz != null) {
            bl = bl && (String.class.equals((Object)clazz) || Boolean.class.equals((Object)clazz) || Number.class.isAssignableFrom(clazz));
        }
        return bl;
    }

    @Override
    protected boolean areTypesCompatible(Type type, Class clazz) {
        return BaseType.LONG.equals((Object)type);
    }

    @Override
    protected Token convertContentToToken(Object object, Type type) throws UnsupportedOperationException, MessageException {
        LongToken longToken;
        if (object == null) {
            longToken = new LongToken();
        } else if (Long.class.isInstance(object)) {
            longToken = new LongToken(((Long)object).longValue());
        } else {
            try {
                longToken = new LongToken(object.toString());
            }
            catch (IllegalActionException illegalActionException) {
                throw new UnsupportedOperationException();
            }
        }
        return longToken;
    }

    @Override
    protected Object convertTokenToContent(Token token, Class clazz) throws MessageException {
        if (clazz != null && !Long.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(Long.toString(((LongToken)token).longValue()));
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return new Long(((LongToken)token).longValue());
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected boolean areTypesCompatible(Class clazz, Class clazz2) {
        return clazz2 == null || Long.class.isAssignableFrom(clazz2);
    }

    @Override
    protected Object convertContentToType(Object object, Class clazz) throws UnsupportedOperationException, MessageException {
        if (clazz != null && !Long.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(object.toString());
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return new Long(Long.parseLong(object.toString()));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException();
        }
    }
}

