/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.internal;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.AuditTrailEntry;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.internal.PasserelleBodyPart;
import com.isencia.passerelle.message.internal.SettableMessage;
import com.isencia.passerelle.message.xml.XmlMessageHelper;
import com.isencia.util.ArrayUtil;
import com.isencia.util.MapOfLists;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageContainer
implements ManagedMessage,
SettableMessage {
    private static Logger logger = LoggerFactory.getLogger(MessageContainer.class);
    protected Map headers = new MapOfLists();
    private PasserelleBodyPart body = new PasserelleBodyPart();

    public MessageContainer() {
        try {
            this.body.setText("");
            this.body.setDisposition("inline");
        }
        catch (MessagingException messagingException) {
            logger.error("", (Throwable)messagingException);
        }
    }

    public MessageContainer copy() throws MessageException {
        MessageContainer messageContainer = new MessageContainer();
        messageContainer.headers = ((MapOfLists)this.headers).copy();
        messageContainer.setBodyContent(this.getBodyContent(), this.getBodyContentType());
        for (Header header : this.getAllBodyHeaders()) {
            messageContainer.setBodyHeader(header.getName(), header.getValue());
        }
        return messageContainer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List getAllBodyHeaders() throws MessageException {
        try {
            ArrayList<Header> arrayList = new ArrayList<Header>();
            Enumeration enumeration = this.body.getAllHeaders();
            if (enumeration == null) {
                return arrayList;
            }
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return arrayList;
                }
                arrayList.add((Header)enumeration.nextElement());
            }
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public Collection getAllHeaders() {
        return this.headers.values();
    }

    @Override
    public void setBody(PasserelleBodyPart passerelleBodyPart) {
        this.body = passerelleBodyPart;
    }

    @Override
    public PasserelleBodyPart getBody() {
        return this.body;
    }

    @Override
    public void setBodyContent(Multipart multipart) throws MessageException {
        try {
            this.body.setContent(multipart);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public void setBodyContentPlainText(String string) throws MessageException {
        try {
            this.body.setContent(string, "text/plain");
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public void setBodyContent(Object object, String string) throws MessageException {
        try {
            this.body.setContent(object, string);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public Object getBodyContent() throws MessageException {
        if (this.body == null) {
            return null;
        }
        try {
            return this.body.getContent();
        }
        catch (IOException iOException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, iOException);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public String getBodyContentAsString() throws MessageException {
        Object object;
        block6: {
            try {
                object = this.getBodyContent();
                if (object != null) break block6;
                return null;
            }
            catch (MessageException messageException) {
                logger.error("", (Throwable)messageException);
                return null;
            }
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Multipart) {
            return XmlMessageHelper.getXMLFromMessageContent((Multipart)object);
        }
        if (object.getClass().isArray()) {
            return ArrayUtil.toString((Object)object, (String)"", (String)"", (String)System.getProperty("line.separator"), (String)"");
        }
        return object.toString();
    }

    @Override
    public String getBodyContentType() throws MessageException {
        try {
            return this.body.getContentType();
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public void setBodyHeader(String string, String string2) throws MessageException {
        try {
            this.body.setHeader(string, string2);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public String[] getBodyHeader(String string) throws MessageException {
        try {
            return this.body.getHeader(string);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public void setHeader(String string, String string2) {
        Collection collection = (Collection)this.headers.remove(string);
        if (collection != null) {
            collection.clear();
        }
        this.headers.put(string, new Header(string, string2));
    }

    @Override
    public String[] getHeader(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = (Collection)this.headers.get(string);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Header)iterator.next()).getValue());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public void addBodyHeader(String string, String string2) throws MessageException {
        try {
            this.body.addHeader(string, string2);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public void addHeader(String string, String string2) {
        this.headers.put(string, new Header(string, string2));
    }

    @Override
    public boolean hasBodyHeader(String string) throws MessageException {
        try {
            String[] stringArray = this.body.getHeader(string);
            return stringArray != null;
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    @Override
    public boolean hasHeader(String string) {
        return this.headers.containsKey(string);
    }

    @Override
    public void removeBodyHeader(String string) throws MessageException {
        try {
            this.body.removeHeader(string);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "Error removing body header " + string, this, messagingException);
        }
    }

    @Override
    public void removeHeader(String string) {
        Collection collection = (Collection)this.headers.remove(string);
        if (collection != null) {
            collection.clear();
        }
    }

    @Override
    public void saveChanges() throws MessageException {
        try {
            this.getBody().saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", this, messagingException);
        }
    }

    public String toString() {
        try {
            return XmlMessageHelper.getXMLFromMessage(this);
        }
        catch (MessageException messageException) {
            logger.error("", (Throwable)messageException);
            return null;
        }
    }

    @Override
    public Long getID() {
        return this.getSingleHeaderLongValue("__PSRL_ID");
    }

    @Override
    public String getSourceRef() {
        return this.getSingleHeaderStringValue("__PSRL_SRC_REF");
    }

    @Override
    public String[] getSourceExtraInfo() {
        return this.getMultiHeaderStringValue("__PSRL_SRC_INFO");
    }

    @Override
    public Date getCreationTimeStamp() {
        return this.getSingleHeaderDateValue("__PSRL_TIMESTAMP_CREATION");
    }

    @Override
    public Long getVersion() {
        return this.getSingleHeaderLongValue("__PSRL_VERSION");
    }

    @Override
    public AuditTrailEntry[] getAuditTrail() {
        return null;
    }

    @Override
    public boolean isCorrelated() {
        return this.getCorrelationID() != null;
    }

    @Override
    public Long getCorrelationID() {
        return this.getSingleHeaderLongValue("__PSRL_CORRELATION_ID");
    }

    @Override
    public boolean isPartOfSequence() {
        return this.getSequenceID() != null;
    }

    @Override
    public Long getSequenceID() {
        return this.getSingleHeaderLongValue("__PSRL_SEQ_ID");
    }

    @Override
    public void setSequenceID(Long l) {
        this.setHeader("__PSRL_SEQ_ID", l.toString());
    }

    @Override
    public Long getSequencePosition() {
        return this.getSingleHeaderLongValue("__PSRL_SEQ_POS");
    }

    @Override
    public void setSequencePosition(Long l) {
        this.setHeader("__PSRL_SEQ_POS", l.toString());
    }

    @Override
    public boolean isSequenceEnd() {
        return this.getSingleHeaderBooleanValue("__PSRL_SEQ_END");
    }

    @Override
    public void setSequenceEnd(boolean bl) {
        this.setHeader("__PSRL_SEQ_END", Boolean.toString(bl));
    }

    @Override
    public boolean hasCauses() {
        return this.getCauseIDs() != null && this.getCauseIDs().length > 0;
    }

    @Override
    public Long[] getCauseIDs() {
        return this.getMultiHeaderLongValue("__PSRL_CAUSES_IDS");
    }

    @Override
    public void addCauseID(Long l) {
        if (l != null) {
            this.addHeader("__PSRL_CAUSES_IDS", l.toString());
        }
    }

    private Boolean getSingleHeaderBooleanValue(String string) {
        Boolean bl = Boolean.FALSE;
        String[] stringArray = this.getHeader(string);
        if (stringArray != null && stringArray.length > 0) {
            try {
                bl = new Boolean(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Header " + string + " contains illegal value " + stringArray[0]);
            }
        }
        return bl;
    }

    private Long getSingleHeaderLongValue(String string) {
        Long l = null;
        String[] stringArray = this.getHeader(string);
        if (stringArray != null && stringArray.length > 0) {
            try {
                l = new Long(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Header " + string + " contains illegal value " + stringArray[0]);
            }
        }
        return l;
    }

    private Long[] getMultiHeaderLongValue(String string) {
        Long[] longArray = null;
        String[] stringArray = this.getHeader(string);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                longArray = new Long[stringArray.length];
                try {
                    longArray[n] = new Long(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warn("Header " + string + " contains illegal value " + stringArray[n]);
                }
                ++n;
            }
        }
        return longArray;
    }

    private String getSingleHeaderStringValue(String string) {
        String string2 = null;
        String[] stringArray = this.getHeader(string);
        if (stringArray != null && stringArray.length > 0) {
            string2 = stringArray[0];
        }
        return string2;
    }

    private String[] getMultiHeaderStringValue(String string) {
        String[] stringArray = null;
        String[] stringArray2 = this.getHeader(string);
        if (stringArray2 != null && stringArray2.length > 0) {
            stringArray = new String[stringArray2.length];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        }
        return stringArray;
    }

    private Date getSingleHeaderDateValue(String string) {
        Date date = null;
        String[] stringArray = this.getHeader(string);
        if (stringArray != null && stringArray.length > 0) {
            String string2 = stringArray[0];
            try {
                date = MessageFactory.timestampFormat.parse(string2);
            }
            catch (ParseException parseException) {
                logger.warn("Header " + string + " contains illegal value " + stringArray[0]);
            }
        }
        return date;
    }
}

