/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message;

import com.isencia.passerelle.message.ManagedMessage;
import java.util.ArrayList;
import java.util.List;

public class MessageFlowElement {
    private MessageAndPort input;
    private List outputs;
    private int amountOfOutputPorts;

    public MessageFlowElement(MessageAndPort messageAndPort, int n) throws IllegalArgumentException {
        if (messageAndPort == null || messageAndPort.message == null) {
            throw new IllegalArgumentException("Message input data are invalid");
        }
        this.input = messageAndPort;
        this.outputs = new ArrayList();
        this.amountOfOutputPorts = n;
    }

    public int getInputPortNr() {
        return this.input.portNr;
    }

    public ManagedMessage getInputMessage() {
        return this.input.message;
    }

    public int getOutputPortNr() {
        if (this.outputs.isEmpty()) {
            return 0;
        }
        return ((MessageAndPort)this.outputs.get((int)0)).portNr;
    }

    public ManagedMessage getOutputMessage() {
        if (this.outputs.isEmpty()) {
            return this.getInputMessage();
        }
        return ((MessageAndPort)this.outputs.get((int)0)).message;
    }

    public MessageAndPort[] getAllOutputSpecs() {
        if (this.outputs.isEmpty()) {
            return new MessageAndPort[]{new MessageAndPort(0, this.getInputMessage())};
        }
        return this.outputs.toArray(new MessageAndPort[0]);
    }

    public void setOutputSpec(int n, ManagedMessage managedMessage) throws IllegalArgumentException {
        this.setOutputSpec(new MessageAndPort(n, managedMessage));
    }

    public void setOutputSpec(MessageAndPort messageAndPort) throws IllegalArgumentException {
        if (messageAndPort == null) {
            throw new IllegalArgumentException("Null specs are not allowed");
        }
        if (messageAndPort.portNr < 0 || messageAndPort.portNr >= this.amountOfOutputPorts) {
            throw new IllegalArgumentException("An impossible outputPortNr, port " + messageAndPort.portNr + " doesn't exist.");
        }
        if (messageAndPort.message == null) {
            throw new IllegalArgumentException("Null messages are not allowed");
        }
        this.outputs.clear();
        this.outputs.add(messageAndPort);
    }

    public void addOutputSpec(int n, ManagedMessage managedMessage) throws IllegalArgumentException {
        this.addOutputSpec(new MessageAndPort(n, managedMessage));
    }

    public void addOutputSpec(MessageAndPort messageAndPort) throws IllegalArgumentException {
        if (messageAndPort == null) {
            throw new IllegalArgumentException("Null specs are not allowed");
        }
        if (messageAndPort.portNr < 0 || messageAndPort.portNr >= this.amountOfOutputPorts) {
            throw new IllegalArgumentException("An impossible outputPortNr, port " + messageAndPort.portNr + " doesn't exist.");
        }
        if (messageAndPort.message == null) {
            throw new IllegalArgumentException("Null messages are not allowed");
        }
        this.outputs.add(messageAndPort);
    }

    public static class MessageAndPort {
        public ManagedMessage message = null;
        public int portNr = 0;

        public MessageAndPort() {
        }

        public MessageAndPort(int n, ManagedMessage managedMessage) {
            this.portNr = n;
            this.message = managedMessage;
        }
    }
}

