/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.executor.engine;

import com.isencia.passerelle.executor.SyncModelExecutor;
import com.isencia.passerelle.executor.engine.EngineExecutorMBean;
import com.isencia.util.StringConvertor;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineExecutor
implements EngineExecutorMBean {
    private static Logger logger = LoggerFactory.getLogger(EngineExecutor.class);
    private ArrayList activeModels = new ArrayList();
    private HashMap modelExecutors = new HashMap();
    private ModelWatchDog modelWatchDog = null;
    private String modelPath = null;

    @Override
    public void setModelPath(String string) {
        this.modelPath = StringConvertor.substituteSystemProperties((String)string);
    }

    @Override
    public String getModelPath() {
        return this.modelPath;
    }

    public File[] getModels() {
        return this.activeModels.toArray(new File[0]);
    }

    public boolean isStarted() {
        return this.modelWatchDog != null;
    }

    @Override
    public synchronized void start() {
        if (this.modelWatchDog == null) {
            logger.info("Starting Engine");
            this.modelWatchDog = new ModelWatchDog();
            new Thread(this.modelWatchDog).start();
        } else {
            logger.info("Try to start engine, but engine is already running");
        }
    }

    @Override
    public synchronized void stop() {
        if (this.modelWatchDog != null) {
            logger.info("Stopping Engine");
            this.modelWatchDog.terminate();
            this.modelWatchDog = null;
        } else {
            logger.info("Try to stop engine, but engine is not running");
        }
    }

    private void startModel(File file) {
        try {
            if (!this.activeModels.contains(file)) {
                SyncModelExecutor syncModelExecutor = new SyncModelExecutor(new String[]{file.getPath()});
                syncModelExecutor.run();
                this.modelExecutors.put(file.getPath(), syncModelExecutor);
                this.activeModels.add(file);
                logger.info("Starting model: " + file.getPath());
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
    }

    private void stopModel(File file) {
        try {
            SyncModelExecutor syncModelExecutor = (SyncModelExecutor)this.modelExecutors.get(file.getPath());
            if (syncModelExecutor != null && syncModelExecutor.isRunning()) {
                syncModelExecutor.finish();
            }
            this.modelExecutors.remove(file.getPath());
            this.activeModels.remove(file);
            logger.info("Stopping model: " + file.getPath());
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
    }

    class ModelWatchDog
    implements Runnable {
        boolean terminate = false;

        ModelWatchDog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.terminate) {
                File file = new File(EngineExecutor.this.modelPath);
                Object object = new MomlFileNameFilter();
                File[] fileArray = file.listFiles((FilenameFilter)object);
                this.checkForUpdatedModels(fileArray);
                this.checkForRemovedModels(fileArray);
                ModelWatchDog modelWatchDog = this;
                synchronized (modelWatchDog) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.terminate = true;
                    }
                }
            }
            logger.info("Stopping models");
            for (Object object : EngineExecutor.this.activeModels) {
                logger.info("Stopping model : " + ((File)object).getPath());
            }
        }

        private void checkForRemovedModels(File[] fileArray) {
            HashMap<String, File> hashMap = new HashMap<String, File>();
            int n = 0;
            while (fileArray != null && n < fileArray.length) {
                hashMap.put(fileArray[n].getPath(), fileArray[n]);
                ++n;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file : EngineExecutor.this.activeModels) {
                if (hashMap.containsKey(file.getPath())) continue;
                arrayList.add(file);
            }
            for (File file : arrayList) {
                logger.info("Stopping removed model : " + file.getPath());
                EngineExecutor.this.stopModel(file);
            }
        }

        private void checkForUpdatedModels(File[] fileArray) {
            int n = 0;
            while (fileArray != null && n < fileArray.length) {
                File file = fileArray[n];
                try {
                    File file2 = (File)EngineExecutor.this.activeModels.get(EngineExecutor.this.activeModels.indexOf(file));
                    if (file2.lastModified() != file.lastModified()) {
                        logger.info("Restarting modified model : " + file2.getPath());
                        EngineExecutor.this.stopModel(file2);
                        EngineExecutor.this.startModel(file);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    logger.info("Starting new model : " + file.getPath());
                    EngineExecutor.this.startModel(file);
                }
                ++n;
            }
        }

        private void terminate() {
            this.terminate = true;
        }
    }

    class MomlFileNameFilter
    implements FilenameFilter {
        MomlFileNameFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string != null && string.length() > 5 && string.substring(string.length() - 5, string.length()).equalsIgnoreCase(".moml");
        }
    }
}

