/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.executor;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.util.StringUtils;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;

public class ModelExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ModelExecutor.class);
    private String name;

    public ModelExecutor() {
    }

    public ModelExecutor(String string) {
        this.name = string;
    }

    public synchronized String getName() {
        return this.name;
    }

    public Manager executeModel(String string, ExecutionListener executionListener) throws PasserelleException {
        if (logger.isTraceEnabled()) {
            logger.trace("executeModel() - entry :" + StringUtils.chop(string, 50));
        }
        try {
            MoMLParser moMLParser = new MoMLParser();
            CompositeActor compositeActor = (CompositeActor)moMLParser.parse(string);
            Manager manager = this.executeModel(compositeActor, executionListener);
            if (logger.isTraceEnabled()) {
                logger.trace("executeModel() - exit");
            }
            return manager;
        }
        catch (PasserelleException passerelleException) {
            throw passerelleException;
        }
        catch (Exception exception) {
            throw new PasserelleException("Could not execute model", string, exception);
        }
    }

    public Manager executeModel(File file, ExecutionListener executionListener) throws PasserelleException {
        if (logger.isTraceEnabled()) {
            logger.trace("executeModel() - entry :" + file);
        }
        try {
            Manager manager = this.executeModel(file.toURL(), executionListener);
            if (logger.isTraceEnabled()) {
                logger.trace("executeModel() - exit");
            }
            return manager;
        }
        catch (PasserelleException passerelleException) {
            throw passerelleException;
        }
        catch (Exception exception) {
            throw new PasserelleException("Could not execute model", file, exception);
        }
    }

    public Manager executeModel(URL uRL, ExecutionListener executionListener) throws PasserelleException {
        if (logger.isTraceEnabled()) {
            logger.trace("executeModel() - entry :" + uRL);
        }
        try {
            MoMLParser moMLParser = new MoMLParser();
            CompositeActor compositeActor = (CompositeActor)moMLParser.parse(null, uRL);
            Manager manager = this.executeModel(compositeActor, executionListener);
            if (logger.isTraceEnabled()) {
                logger.trace("executeModel() - exit");
            }
            return manager;
        }
        catch (PasserelleException passerelleException) {
            throw passerelleException;
        }
        catch (Exception exception) {
            throw new PasserelleException("Could not execute model", uRL, exception);
        }
    }

    public Manager executeModel(CompositeActor compositeActor, ExecutionListener executionListener) throws PasserelleException {
        if (logger.isTraceEnabled()) {
            logger.trace("executeModel() - entry :" + compositeActor != null ? compositeActor.getFullName() : null);
        }
        try {
            Manager manager = new Manager(compositeActor.workspace(), this.getName() != null ? this.getName() : compositeActor.getName());
            compositeActor.setManager(manager);
            if (executionListener != null) {
                manager.addExecutionListener(executionListener);
            }
            manager.execute();
            if (logger.isTraceEnabled()) {
                logger.trace("executeModel() - exit");
            }
            return manager;
        }
        catch (Exception exception) {
            throw new PasserelleException("Could not execute model", compositeActor, exception);
        }
    }
}

