/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.domain;

import com.isencia.passerelle.domain.ProcessDirector;
import com.isencia.passerelle.executor.ExecutionContext;
import com.isencia.passerelle.ext.ExecutionControlStrategy;
import com.isencia.passerelle.util.LoggerManager;
import java.io.InterruptedIOException;
import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.Manager;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class ProcessThread
extends ptolemy.actor.process.ProcessThread {
    public static final String ACTOR_MDC_NAME = "actor";
    private ExecutionContext ctxt = null;
    private ProcessDirector _director;
    private Manager _manager;
    private FiringEvent[] firingEventCache;

    public ProcessThread(Actor actor, ProcessDirector processDirector) {
        super(actor, (ptolemy.actor.process.ProcessDirector)processDirector);
        this._director = processDirector;
        this._manager = actor.getManager();
        if (actor != null) {
            String string = "none";
            string = actor instanceof NamedObj ? String.valueOf(actor.getManager().getName()) + ((NamedObj)actor).getFullName() : String.valueOf(actor.getManager().getName()) + "." + actor.getClass().getName();
            this.ctxt = ExecutionContext.getExecutionContext(actor.getManager());
            if (this.ctxt != null) {
                this.ctxt.setAttribute(ACTOR_MDC_NAME, string);
            }
        }
        this.firingEventCache = new FiringEvent[]{new FiringEvent((Director)this._director, actor, FiringEvent.BEFORE_ITERATE), new FiringEvent((Director)this._director, actor, FiringEvent.BEFORE_PREFIRE), new FiringEvent((Director)this._director, actor, FiringEvent.AFTER_PREFIRE), new FiringEvent((Director)this._director, actor, FiringEvent.BEFORE_FIRE), new FiringEvent((Director)this._director, actor, FiringEvent.AFTER_FIRE), new FiringEvent((Director)this._director, actor, FiringEvent.BEFORE_POSTFIRE), new FiringEvent((Director)this._director, actor, FiringEvent.AFTER_POSTFIRE), new FiringEvent((Director)this._director, actor, FiringEvent.AFTER_ITERATE)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block169: {
            LoggerManager.setContext(this.ctxt);
            this._debug("-- Starting thread.");
            Workspace workspace = this._director.workspace();
            boolean bl = true;
            Throwable throwable = null;
            IllegalActionException illegalActionException = null;
            try {
                try {
                    this.getActor().initialize();
                    while (bl) {
                        ExecutionControlStrategy.IterationPermission iterationPermission = this._director.requestNextIteration(this.getActor());
                        try {
                            if (this._director.isStopFireRequested()) {
                                this._debug("-- Thread pause requested. Get lock on director.");
                                ProcessDirector processDirector = this._director;
                                synchronized (processDirector) {
                                    this._director.threadHasPaused((Thread)((Object)this));
                                    while (this._director.isStopFireRequested()) {
                                        if (this._director.isStopRequested()) {
                                            this._debug("-- Thread stop requested, so cancel iteration.");
                                            break;
                                        }
                                        this._debug("-- Thread waiting for canceled pause request.");
                                        try {
                                            workspace.wait((Object)this._director);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            this._debug("-- Thread interrupted, so cancel iteration.");
                                            break;
                                        }
                                    }
                                    this._director.threadHasResumed((Thread)((Object)this));
                                }
                                this._debug("-- Thread resuming.");
                            }
                            if (!this._director.isStopRequested()) {
                                if (((Entity)this.getActor()).getContainer() == null) continue;
                                if (this._director.hasFiringEventListeners()) {
                                    bl = this.doActorIterationWithEvents();
                                    continue;
                                }
                                bl = this.doActorIterationWithoutEvents();
                                continue;
                            }
                            break;
                        }
                        finally {
                            this._director.iterationFinished(this.getActor(), iterationPermission);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    ProcessDirector processDirector = this._director;
                    synchronized (processDirector) {
                        block168: {
                            this._director.removeThread((Thread)((Object)this));
                            try {
                                try {
                                    this.wrapup();
                                }
                                catch (IllegalActionException illegalActionException2) {
                                    illegalActionException = illegalActionException2;
                                    this._debug("-- Thread stopped.");
                                    boolean bl2 = false;
                                    if (throwable instanceof TerminateProcessException) {
                                        this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                                    } else if (throwable instanceof InterruptedException) {
                                        this._debug("-- Thread was interrupted: " + throwable);
                                    } else if (throwable instanceof InterruptedIOException || throwable != null && throwable.getCause() instanceof InterruptedIOException) {
                                        this._debug("-- IO was interrupted: " + throwable);
                                    } else if (throwable instanceof IllegalActionException) {
                                        this._debug("-- Exception: " + throwable);
                                        this._manager.notifyListenersOfException((Exception)((Object)((IllegalActionException)throwable)));
                                    } else if (throwable != null) {
                                        bl2 = true;
                                    }
                                    if (illegalActionException instanceof IllegalActionException) {
                                        this._debug("-- Exception: " + (Object)((Object)illegalActionException));
                                        this._manager.notifyListenersOfException((Exception)((Object)illegalActionException));
                                    } else if (illegalActionException != null) {
                                        this._manager.notifyListenersOfThrowable((Throwable)illegalActionException);
                                    } else if (bl2) {
                                        this._manager.notifyListenersOfThrowable(throwable);
                                    }
                                    break block168;
                                }
                            }
                            catch (Throwable throwable3) {
                                this._debug("-- Thread stopped.");
                                boolean bl3 = false;
                                if (throwable instanceof TerminateProcessException) {
                                    this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                                } else if (throwable instanceof InterruptedException) {
                                    this._debug("-- Thread was interrupted: " + throwable);
                                } else if (throwable instanceof InterruptedIOException || throwable != null && throwable.getCause() instanceof InterruptedIOException) {
                                    this._debug("-- IO was interrupted: " + throwable);
                                } else if (throwable instanceof IllegalActionException) {
                                    this._debug("-- Exception: " + throwable);
                                    this._manager.notifyListenersOfException((Exception)((Object)((IllegalActionException)throwable)));
                                } else if (throwable != null) {
                                    bl3 = true;
                                }
                                if (illegalActionException instanceof IllegalActionException) {
                                    this._debug("-- Exception: " + (Object)((Object)illegalActionException));
                                    this._manager.notifyListenersOfException((Exception)((Object)illegalActionException));
                                } else if (illegalActionException != null) {
                                    this._manager.notifyListenersOfThrowable((Throwable)illegalActionException);
                                } else if (bl3) {
                                    this._manager.notifyListenersOfThrowable(throwable);
                                }
                                throw throwable3;
                            }
                            this._debug("-- Thread stopped.");
                            boolean bl4 = false;
                            if (throwable instanceof TerminateProcessException) {
                                this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                            } else if (throwable instanceof InterruptedException) {
                                this._debug("-- Thread was interrupted: " + throwable);
                            } else if (throwable instanceof InterruptedIOException || throwable != null && throwable.getCause() instanceof InterruptedIOException) {
                                this._debug("-- IO was interrupted: " + throwable);
                            } else if (throwable instanceof IllegalActionException) {
                                this._debug("-- Exception: " + throwable);
                                this._manager.notifyListenersOfException((Exception)((Object)((IllegalActionException)throwable)));
                            } else if (throwable != null) {
                                bl4 = true;
                            }
                            if (illegalActionException instanceof IllegalActionException) {
                                this._debug("-- Exception: " + (Object)((Object)illegalActionException));
                                this._manager.notifyListenersOfException((Exception)((Object)illegalActionException));
                            } else if (illegalActionException != null) {
                                this._manager.notifyListenersOfThrowable((Throwable)illegalActionException);
                            } else if (bl4) {
                                this._manager.notifyListenersOfThrowable(throwable);
                            }
                        }
                        break block169;
                    }
                }
            }
            catch (Throwable throwable4) {
                ProcessDirector processDirector = this._director;
                synchronized (processDirector) {
                    block171: {
                        this._director.removeThread((Thread)((Object)this));
                        try {
                            try {
                                this.wrapup();
                            }
                            catch (IllegalActionException illegalActionException3) {
                                illegalActionException = illegalActionException3;
                                this._debug("-- Thread stopped.");
                                boolean bl5 = false;
                                if (throwable instanceof TerminateProcessException) {
                                    this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                                } else if (throwable instanceof InterruptedException) {
                                    this._debug("-- Thread was interrupted: " + throwable);
                                } else if (throwable instanceof InterruptedIOException || throwable != null && throwable.getCause() instanceof InterruptedIOException) {
                                    this._debug("-- IO was interrupted: " + throwable);
                                } else if (throwable instanceof IllegalActionException) {
                                    this._debug("-- Exception: " + throwable);
                                    this._manager.notifyListenersOfException((Exception)((Object)((IllegalActionException)throwable)));
                                } else if (throwable != null) {
                                    bl5 = true;
                                }
                                if (illegalActionException instanceof IllegalActionException) {
                                    this._debug("-- Exception: " + (Object)((Object)illegalActionException));
                                    this._manager.notifyListenersOfException((Exception)((Object)illegalActionException));
                                } else if (illegalActionException != null) {
                                    this._manager.notifyListenersOfThrowable((Throwable)illegalActionException);
                                } else if (bl5) {
                                    this._manager.notifyListenersOfThrowable(throwable);
                                }
                                break block171;
                            }
                        }
                        catch (Throwable throwable5) {
                            this._debug("-- Thread stopped.");
                            boolean bl6 = false;
                            if (throwable instanceof TerminateProcessException) {
                                this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                            } else if (throwable instanceof InterruptedException) {
                                this._debug("-- Thread was interrupted: " + throwable);
                            } else if (throwable instanceof InterruptedIOException || throwable != null && throwable.getCause() instanceof InterruptedIOException) {
                                this._debug("-- IO was interrupted: " + throwable);
                            } else if (throwable instanceof IllegalActionException) {
                                this._debug("-- Exception: " + throwable);
                                this._manager.notifyListenersOfException((Exception)((Object)((IllegalActionException)throwable)));
                            } else if (throwable != null) {
                                bl6 = true;
                            }
                            if (illegalActionException instanceof IllegalActionException) {
                                this._debug("-- Exception: " + (Object)((Object)illegalActionException));
                                this._manager.notifyListenersOfException((Exception)((Object)illegalActionException));
                            } else if (illegalActionException != null) {
                                this._manager.notifyListenersOfThrowable((Throwable)illegalActionException);
                            } else if (bl6) {
                                this._manager.notifyListenersOfThrowable(throwable);
                            }
                            throw throwable5;
                        }
                        this._debug("-- Thread stopped.");
                        boolean bl7 = false;
                        if (throwable instanceof TerminateProcessException) {
                            this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                        } else if (throwable instanceof InterruptedException) {
                            this._debug("-- Thread was interrupted: " + throwable);
                        } else if (throwable instanceof InterruptedIOException || throwable != null && throwable.getCause() instanceof InterruptedIOException) {
                            this._debug("-- IO was interrupted: " + throwable);
                        } else if (throwable instanceof IllegalActionException) {
                            this._debug("-- Exception: " + throwable);
                            this._manager.notifyListenersOfException((Exception)((Object)((IllegalActionException)throwable)));
                        } else if (throwable != null) {
                            bl7 = true;
                        }
                        if (illegalActionException instanceof IllegalActionException) {
                            this._debug("-- Exception: " + (Object)((Object)illegalActionException));
                            this._manager.notifyListenersOfException((Exception)((Object)illegalActionException));
                        } else if (illegalActionException != null) {
                            this._manager.notifyListenersOfThrowable((Throwable)illegalActionException);
                        } else if (bl7) {
                            this._manager.notifyListenersOfThrowable(throwable);
                        }
                    }
                }
                throw throwable4;
            }
            ProcessDirector processDirector = this._director;
            synchronized (processDirector) {
                block173: {
                    this._director.removeThread((Thread)((Object)this));
                    try {
                        try {
                            this.wrapup();
                        }
                        catch (IllegalActionException illegalActionException4) {
                            illegalActionException = illegalActionException4;
                            this._debug("-- Thread stopped.");
                            boolean bl8 = false;
                            if (throwable instanceof TerminateProcessException) {
                                this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                            } else if (throwable instanceof InterruptedException) {
                                this._debug("-- Thread was interrupted: " + throwable);
                            } else if (throwable instanceof InterruptedIOException || throwable != null && throwable.getCause() instanceof InterruptedIOException) {
                                this._debug("-- IO was interrupted: " + throwable);
                            } else if (throwable instanceof IllegalActionException) {
                                this._debug("-- Exception: " + throwable);
                                this._manager.notifyListenersOfException((Exception)((Object)((IllegalActionException)throwable)));
                            } else if (throwable != null) {
                                bl8 = true;
                            }
                            if (illegalActionException instanceof IllegalActionException) {
                                this._debug("-- Exception: " + (Object)((Object)illegalActionException));
                                this._manager.notifyListenersOfException((Exception)((Object)illegalActionException));
                            } else if (illegalActionException != null) {
                                this._manager.notifyListenersOfThrowable((Throwable)illegalActionException);
                            } else if (bl8) {
                                this._manager.notifyListenersOfThrowable(throwable);
                            }
                            break block173;
                        }
                    }
                    catch (Throwable throwable6) {
                        this._debug("-- Thread stopped.");
                        boolean bl9 = false;
                        if (throwable instanceof TerminateProcessException) {
                            this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                        } else if (throwable instanceof InterruptedException) {
                            this._debug("-- Thread was interrupted: " + throwable);
                        } else if (throwable instanceof InterruptedIOException || throwable != null && throwable.getCause() instanceof InterruptedIOException) {
                            this._debug("-- IO was interrupted: " + throwable);
                        } else if (throwable instanceof IllegalActionException) {
                            this._debug("-- Exception: " + throwable);
                            this._manager.notifyListenersOfException((Exception)((Object)((IllegalActionException)throwable)));
                        } else if (throwable != null) {
                            bl9 = true;
                        }
                        if (illegalActionException instanceof IllegalActionException) {
                            this._debug("-- Exception: " + (Object)((Object)illegalActionException));
                            this._manager.notifyListenersOfException((Exception)((Object)illegalActionException));
                        } else if (illegalActionException != null) {
                            this._manager.notifyListenersOfThrowable((Throwable)illegalActionException);
                        } else if (bl9) {
                            this._manager.notifyListenersOfThrowable(throwable);
                        }
                        throw throwable6;
                    }
                    this._debug("-- Thread stopped.");
                    boolean bl10 = false;
                    if (throwable instanceof TerminateProcessException) {
                        this._debug("-- Blocked Receiver call threw TerminateProcessException.");
                    } else if (throwable instanceof InterruptedException) {
                        this._debug("-- Thread was interrupted: " + throwable);
                    } else if (throwable instanceof InterruptedIOException || throwable != null && throwable.getCause() instanceof InterruptedIOException) {
                        this._debug("-- IO was interrupted: " + throwable);
                    } else if (throwable instanceof IllegalActionException) {
                        this._debug("-- Exception: " + throwable);
                        this._manager.notifyListenersOfException((Exception)((Object)((IllegalActionException)throwable)));
                    } else if (throwable != null) {
                        bl10 = true;
                    }
                    if (illegalActionException instanceof IllegalActionException) {
                        this._debug("-- Exception: " + (Object)((Object)illegalActionException));
                        this._manager.notifyListenersOfException((Exception)((Object)illegalActionException));
                    } else if (illegalActionException != null) {
                        this._manager.notifyListenersOfThrowable((Throwable)illegalActionException);
                    } else if (bl10) {
                        this._manager.notifyListenersOfThrowable(throwable);
                    }
                }
            }
        }
        LoggerManager.clearContext(this.ctxt);
    }

    private boolean doActorIterationWithoutEvents() throws IllegalActionException {
        boolean bl = false;
        boolean bl2 = this.getActor().prefire();
        if (bl2) {
            this.getActor().fire();
            bl = this.getActor().postfire();
        }
        return bl;
    }

    private boolean doActorIterationWithEvents() throws IllegalActionException {
        boolean bl = false;
        this._director.notifyFiringEventListeners(this.firingEventCache[0]);
        this._director.notifyFiringEventListeners(this.firingEventCache[1]);
        boolean bl2 = this.getActor().prefire();
        this._director.notifyFiringEventListeners(this.firingEventCache[2]);
        if (bl2) {
            this._director.notifyFiringEventListeners(this.firingEventCache[3]);
            this.getActor().fire();
            this._director.notifyFiringEventListeners(this.firingEventCache[4]);
            this._director.notifyFiringEventListeners(this.firingEventCache[5]);
            bl = this.getActor().postfire();
            this._director.notifyFiringEventListeners(this.firingEventCache[6]);
            this._director.notifyFiringEventListeners(this.firingEventCache[7]);
        }
        return bl;
    }
}

