/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.core;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.core.ControlPort;
import com.isencia.passerelle.core.ErrorPort;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortMode;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class PortFactory {
    private static final PortFactory instance = new PortFactory();

    public static PortFactory getInstance() {
        return instance;
    }

    private PortFactory() {
    }

    public Port createOutputPort(Actor actor) throws IllegalActionException, NameDuplicationException {
        return this.createOutputPort(actor, "output");
    }

    public Port createOutputPort(Actor actor, String string) throws IllegalActionException, NameDuplicationException {
        Port port = new Port((ComponentEntity)actor, string, false, true);
        return port;
    }

    public ErrorPort createOutputErrorPort(Actor actor) throws IllegalActionException, NameDuplicationException {
        return this.createOutputErrorPort(actor, "error");
    }

    public ControlPort createInputControlPort(Actor actor, String string) throws IllegalActionException, NameDuplicationException {
        ControlPort controlPort = new ControlPort((ComponentEntity)actor, string, true, false);
        return controlPort;
    }

    public ControlPort createOutputControlPort(Actor actor, String string) throws IllegalActionException, NameDuplicationException {
        ControlPort controlPort = new ControlPort((ComponentEntity)actor, string, false, true);
        return controlPort;
    }

    public ErrorPort createInputErrorPort(Actor actor, String string) throws IllegalActionException, NameDuplicationException {
        ErrorPort errorPort = new ErrorPort((ComponentEntity)actor, string, true, false);
        return errorPort;
    }

    public ErrorPort createOutputErrorPort(Actor actor, String string) throws IllegalActionException, NameDuplicationException {
        ErrorPort errorPort = new ErrorPort((ComponentEntity)actor, string, false, true);
        return errorPort;
    }

    public Port createInputPort(Actor actor, Class clazz) throws IllegalActionException, NameDuplicationException {
        return this.createInputPort(actor, "input", PortMode.PULL, clazz);
    }

    public Port createInputPort(Actor actor, String string, Class clazz) throws IllegalActionException, NameDuplicationException {
        return this.createInputPort(actor, string, PortMode.PULL, clazz);
    }

    public Port createInputPort(Actor actor, PortMode portMode, Class clazz) throws IllegalActionException, NameDuplicationException {
        return this.createInputPort(actor, "input", portMode, clazz);
    }

    public Port createInputPort(Actor actor, String string, PortMode portMode, Class clazz) throws IllegalActionException, NameDuplicationException {
        Port port = new Port((ComponentEntity)actor, string, portMode, true, false);
        port.setExpectedMessageContentType(clazz);
        return port;
    }
}

