/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.core;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.PasserelleToken;
import com.isencia.passerelle.core.PasserelleType;
import com.isencia.passerelle.core.PortMode;
import com.isencia.passerelle.message.type.TypeConversionChain;
import com.isencia.passerelle.statistics.PortStatistics;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.data.Token;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class Port
extends TypedIOPort {
    private static Logger logger = LoggerFactory.getLogger(Port.class);
    private static final Receiver[][] _EMPTY_RECEIVER_ARRAY = new Receiver[0][0];
    private PortStatistics statistics;
    private Class expectedMessageContentType;
    private PortMode mode = PortMode.PULL;
    private Set<IOPort> operationalSourcePorts = new HashSet<IOPort>();

    public Port() {
    }

    public Port(ComponentEntity componentEntity, String string) throws IllegalActionException, NameDuplicationException {
        this(componentEntity, string, false, false);
    }

    public Port(ComponentEntity componentEntity, String string, boolean bl, boolean bl2) throws IllegalActionException, NameDuplicationException {
        this(componentEntity, string, PortMode.PULL, bl, bl2);
    }

    public Port(ComponentEntity componentEntity, String string, PortMode portMode, boolean bl, boolean bl2) throws IllegalActionException, NameDuplicationException {
        super(componentEntity.workspace());
        this.setName(string);
        this.setInput(bl);
        this.setOutput(bl2);
        this.setTypeEquals(PasserelleType.PASSERELLE_MSG_TYPE);
        this.setMultiport(true);
        this.statistics = new PortStatistics(this);
        this.setMode(portMode);
        this.setContainer((Entity)componentEntity);
    }

    public Class getExpectedMessageContentType() {
        return this.expectedMessageContentType;
    }

    public void setExpectedMessageContentType(Class clazz) {
        this.expectedMessageContentType = clazz;
    }

    public PortMode getMode() {
        return this.mode;
    }

    public void setMode(PortMode portMode) {
        this.mode = portMode;
    }

    public void broadcast(Token token) throws IllegalActionException, NoRoomException {
        Receiver[][] receiverArray;
        if (logger.isTraceEnabled()) {
            logger.trace("broadcast() - entry : " + token);
        }
        this.statistics.acceptSentMessage(null);
        if (this._debugging) {
            this._debug("broadcast " + token);
        }
        try {
            this._workspace.getReadAccess();
            this._checkType(token);
            receiverArray = this.getRemoteReceivers();
            if (receiverArray == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        int n = 0;
        while (n < receiverArray.length) {
            if (receiverArray[n] != null) {
                this.putAtFarReceivers(token, receiverArray[n]);
            }
            ++n;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("broadcast() - exit");
        }
    }

    public void broadcast(Token[] tokenArray, int n) throws IllegalActionException, NoRoomException {
        Receiver[][] receiverArray;
        int n2;
        if (logger.isTraceEnabled()) {
            logger.trace("broadcast(array) - entry : " + tokenArray + " length :" + n);
        }
        if (this._debugging) {
            this._debug("broadcast token array of length " + n);
        }
        Token token = null;
        try {
            this._workspace.getReadAccess();
            n2 = 0;
            while (n2 < tokenArray.length) {
                token = tokenArray[n2];
                this._checkType(token);
                ++n2;
            }
            receiverArray = this.getRemoteReceivers();
            if (receiverArray == null) {
                return;
            }
        }
        finally {
            this._workspace.doneReading();
        }
        n2 = 0;
        while (n2 < receiverArray.length) {
            if (receiverArray[n2] != null) {
                this.putAtFarReceivers(tokenArray, n, receiverArray[n2]);
            }
            ++n2;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("broadcast(array) - exit");
        }
    }

    public void send(int n, Token token) throws IllegalActionException, NoRoomException {
        if (logger.isTraceEnabled()) {
            logger.trace("send() - entry : channel : " + n + " token : " + token);
        }
        if (token == null) {
            throw new IllegalActionException((Nameable)this, "Cannot send a null token.");
        }
        this.statistics.acceptSentMessage(null);
        if (this._debugging) {
            this._debug("send to channel " + n + ": " + token);
        }
        try {
            Receiver[][] receiverArray;
            try {
                this._workspace.getReadAccess();
                this._checkType(token);
                receiverArray = this.getRemoteReceivers();
                if (receiverArray == null || receiverArray.length <= n || receiverArray[n] == null) {
                    return;
                }
            }
            finally {
                this._workspace.doneReading();
            }
            this.putAtFarReceivers(token, receiverArray[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (logger.isTraceEnabled()) {
            logger.trace("send() - exit");
        }
    }

    public void send(int n, Token[] tokenArray, int n2) throws IllegalActionException, NoRoomException {
        if (logger.isTraceEnabled()) {
            logger.trace("send(array) - entry : channel : " + n + " token : " + tokenArray + " length : " + n2);
        }
        if (n2 > tokenArray.length) {
            throw new IllegalActionException((Nameable)this, "Not enough data supplied to send specified number of samples.");
        }
        if (this._debugging) {
            this._debug("send to channel " + n + " token array of length " + n2);
        }
        Token token = null;
        try {
            Receiver[][] receiverArray;
            try {
                this._workspace.getReadAccess();
                int n3 = 0;
                while (n3 < n2) {
                    token = tokenArray[n3];
                    this._checkType(token);
                    ++n3;
                }
                receiverArray = this.getRemoteReceivers();
                if (receiverArray == null || receiverArray[n] == null) {
                    return;
                }
            }
            finally {
                this._workspace.doneReading();
            }
            this.putAtFarReceivers(tokenArray, n2, receiverArray[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (logger.isTraceEnabled()) {
            logger.trace("send(array) - exit");
        }
    }

    public Token get(int n) throws NoTokenException, IllegalActionException {
        Receiver[][] receiverArray;
        if (logger.isTraceEnabled()) {
            logger.trace("get() - entry : channel : " + n);
        }
        try {
            this._workspace.getReadAccess();
            receiverArray = this.getReceivers();
            if (n >= receiverArray.length) {
                if (!this.isInput()) {
                    throw new IllegalActionException((Nameable)this, "Port is not an input port!");
                }
                throw new IllegalActionException((Nameable)this, "Channel index " + n + " is out of range, because width is only " + this.getWidth() + ".");
            }
            if (receiverArray[n] == null) {
                throw new NoTokenException((Nameable)this, "No receiver at index: " + n + ".");
            }
        }
        finally {
            this._workspace.doneReading();
        }
        Token token = null;
        int n2 = 0;
        while (n2 < receiverArray[n].length) {
            Token token2 = receiverArray[n][n2].get();
            if (token == null) {
                token = token2;
            }
            ++n2;
        }
        if (token == null) {
            throw new NoTokenException((Nameable)this, "No token to return.");
        }
        if (this._debugging) {
            this._debug("get from channel " + n + ": " + token);
        }
        token = this.convertTokenForMe(token);
        this.statistics.acceptReceivedMessage(null);
        if (logger.isTraceEnabled()) {
            logger.trace("get() - exit - result : " + token);
        }
        return token;
    }

    public Token[] get(int n, int n2) throws NoTokenException, IllegalActionException {
        Receiver[][] receiverArray;
        if (logger.isTraceEnabled()) {
            logger.trace("get(array) - entry : channel : " + n + " length : " + n2);
        }
        try {
            this._workspace.getReadAccess();
            receiverArray = this.getReceivers();
        }
        finally {
            this._workspace.doneReading();
        }
        if (n >= receiverArray.length) {
            throw new IllegalActionException((Nameable)this, "get: channel index is out of range.");
        }
        if (receiverArray[n] == null) {
            throw new NoTokenException((Nameable)this, "get: no receiver at index: " + n + ".");
        }
        Token[] tokenArray = receiverArray[n][0].getArray(n2);
        if (tokenArray == null) {
            throw new NoTokenException((Nameable)this, "get: No token array to return.");
        }
        if (this._debugging) {
            this._debug("get vector from channel " + n + " of length " + n2);
        }
        int n3 = 0;
        while (n3 < tokenArray.length) {
            Token token;
            Token token2 = tokenArray[n3];
            tokenArray[n3] = token = this.convertTokenForMe(token2);
            ++n3;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("get(array) - exit - result : " + tokenArray);
        }
        return tokenArray;
    }

    public Receiver[][] getRemoteReceivers(IORelation iORelation) throws IllegalActionException {
        try {
            this._workspace.getReadAccess();
            if (!this.isInsideLinked((Relation)iORelation)) {
                throw new IllegalActionException((Nameable)this, (Nameable)iORelation, "not linked from the inside.");
            }
            if (!this.isOutput()) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            int n = iORelation.getWidth();
            if (n <= 0) {
                Receiver[][] receiverArray = _EMPTY_RECEIVER_ARRAY;
                return receiverArray;
            }
            Receiver[][] receiverArray = this.getRemoteReceivers();
            if (receiverArray == null) {
                Receiver[][] receiverArray2 = _EMPTY_RECEIVER_ARRAY;
                return receiverArray2;
            }
            Receiver[][] receiverArray3 = receiverArray;
            return receiverArray3;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    private void putAtFarReceivers(Token token, Receiver[] receiverArray) throws IllegalActionException {
        int n = 0;
        while (n < receiverArray.length) {
            TypedIOPort typedIOPort = (TypedIOPort)receiverArray[n].getContainer();
            Token token2 = this.convertTokenForFarPort(token, typedIOPort);
            receiverArray[n].put(token2);
            ++n;
        }
    }

    private void putAtFarReceivers(Token[] tokenArray, int n, Receiver[] receiverArray) throws IllegalActionException {
        int n2 = 0;
        while (n2 < receiverArray.length) {
            TypedIOPort typedIOPort = (TypedIOPort)receiverArray[n2].getContainer();
            Type type = typedIOPort.getType();
            boolean bl = false;
            int n3 = 0;
            while (n3 < tokenArray.length) {
                if (!type.equals((Object)tokenArray[n3].getType())) {
                    bl = true;
                }
                ++n3;
            }
            if (!bl) {
                receiverArray[n2].putArray(tokenArray, n);
            } else {
                n3 = 0;
                while (n3 < n) {
                    Token token = this.convertTokenForFarPort(tokenArray[n3], typedIOPort);
                    receiverArray[n2].put(token);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private Token convertTokenForMe(Token token) throws IllegalActionException {
        Token token2 = token;
        if (this.getContainer() instanceof Actor && PasserelleType.PASSERELLE_MSG_TYPE.equals((Object)this.getType()) && token != null) {
            Class clazz = null;
            if (token instanceof PasserelleToken) {
                if (this.getExpectedMessageContentType() == null) {
                    return token;
                }
                clazz = this.getExpectedMessageContentType();
            }
            try {
                token2 = TypeConversionChain.getInstance().convertPtolemyTokenToPasserelleToken(token, clazz);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (PasserelleException passerelleException) {
                throw new IllegalActionException((Nameable)this, (Throwable)passerelleException, "token type conversion failed");
            }
        }
        return token2;
    }

    private Token convertTokenForFarPort(Token token, TypedIOPort typedIOPort) throws IllegalActionException {
        NamedObj namedObj = typedIOPort.getContainer();
        NamedObj namedObj2 = this.getContainer();
        Token token2 = token;
        if (namedObj2 instanceof Actor) {
            if (!(namedObj instanceof Actor) || !PasserelleType.PASSERELLE_MSG_TYPE.equals((Object)typedIOPort.getType())) {
                Token token3 = null;
                try {
                    token3 = TypeConversionChain.getInstance().convertPasserelleTokenToPtolemyToken((PasserelleToken)token, typedIOPort.getType());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (Exception exception) {
                    throw new IllegalActionException((Nameable)this, (Throwable)exception, "token type conversion failed");
                }
                if (token3 != null) {
                    token2 = token3;
                }
            }
        } else {
            token2 = typedIOPort.convert(token);
        }
        return token2;
    }

    public void initialize() {
        this.operationalSourcePorts.addAll(this.sourcePortList());
    }

    public void notifySourcePortFinished(Port port) {
        if (logger.isTraceEnabled()) {
            logger.trace("notifySourcePortFinished() - entry - srcPort : " + port.getFullName());
        }
        this.operationalSourcePorts.remove((Object)port);
        if (this.operationalSourcePorts.size() == 0) {
            Receiver[][] receiverArray;
            if (logger.isInfoEnabled()) {
                logger.info("All source ports exhausted for " + this.getFullName());
            }
            Receiver[][] receiverArray2 = receiverArray = this.getReceivers();
            int n = receiverArray.length;
            int n2 = 0;
            while (n2 < n) {
                Receiver[] receiverArray3;
                Receiver[] receiverArray4 = receiverArray3 = receiverArray2[n2];
                int n3 = receiverArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    Receiver receiver = receiverArray4[n4];
                    if (receiver instanceof ProcessReceiver) {
                        ((ProcessReceiver)receiver).requestFinish();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("notifySourcePortFinished() - exit");
        }
    }
}

