/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui.graph;

import java.awt.Container;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;

public class EditPreferencesConfigurer
extends Query
implements ChangeListener,
QueryListener {
    private static final String PARAMETERS_CHECK_BOX = "parametersCheckBox";
    private static final String PORT_NAMES_CHECK_BOX = "portNamesCheckBox";
    private static String _SINGLETON_PARAMETER = "ptolemy.data.expr.SingletonParameter";
    private CompositeEntity target;
    private Configuration _configuration;
    private boolean _changed;
    private PtolemyPreferences preferences = null;
    private Parameter showPortNamesParameter;
    private StringParameter showParametersParameter;

    public EditPreferencesConfigurer(Configuration configuration, CompositeEntity compositeEntity) {
        this._configuration = configuration;
        this.target = compositeEntity;
        this.addQueryListener(this);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        try {
            this.preferences = (PtolemyPreferences)this._configuration.getAttribute(PtolemyPreferences.PREFERENCES_WITHIN_CONFIGURATION, PtolemyPreferences.class);
            this.showPortNamesParameter = (Parameter)this.preferences.getAttribute("_showPortNames");
            if (this.showPortNamesParameter == null) {
                this.showPortNamesParameter = new Parameter((NamedObj)this.preferences, "_showPortNames");
                this.showPortNamesParameter.setToken((Token)new BooleanToken(false));
            }
            this.showParametersParameter = (StringParameter)this.preferences.getAttribute("_showParameters");
            this.addCheckBox(PORT_NAMES_CHECK_BOX, "Show port names", ((BooleanToken)this.showPortNamesParameter.getToken()).booleanValue());
            this.addCheckBox(PARAMETERS_CHECK_BOX, "Show parameters", "All".equals(this.showParametersParameter.getExpression()));
        }
        catch (Exception exception) {
            MessageHandler.error((String)"Error reading preferences", (Throwable)exception);
        }
    }

    public void apply() {
        try {
            boolean bl = this.getBooleanValue(PORT_NAMES_CHECK_BOX);
            boolean bl2 = this.getBooleanValue(PARAMETERS_CHECK_BOX);
            if (bl2) {
                this.showParametersParameter.setExpression("All");
            } else {
                this.showParametersParameter.setExpression("None");
            }
            this.showPortNamesParameter.setToken((Token)new BooleanToken(bl));
            this.preferences.setAsDefault();
            this.handleShowPortNames(bl);
        }
        catch (Exception exception) {
            MessageHandler.error((String)"Error setting preferences", (Throwable)exception);
        }
    }

    private void handleShowPortNames(boolean bl) {
        List list = this.target.entityList();
        for (Entity entity : list) {
            StringBuffer stringBuffer = new StringBuffer("<group>");
            stringBuffer.append(this.getShowNameChangeForPortCollection(bl, entity.portList()));
            stringBuffer.append("</group>");
            MoMLChangeRequest moMLChangeRequest = new MoMLChangeRequest((Object)this, (NamedObj)entity, stringBuffer.toString(), null);
            moMLChangeRequest.setUndoable(true);
            entity.requestChange((ChangeRequest)moMLChangeRequest);
        }
    }

    private String getShowNameChangeForPortCollection(boolean bl, Collection<Port> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Port port : collection) {
            stringBuffer.append("<port name=\"" + port.getName() + "\">");
            boolean bl2 = this._isPropertySet((NamedObj)port, "_showName");
            if (bl) {
                if (!bl2) {
                    stringBuffer.append(this._momlProperty("_showName", _SINGLETON_PARAMETER, "true"));
                }
            } else {
                Attribute attribute = port.getAttribute("_showName");
                if (attribute == null) {
                    stringBuffer.append(this._momlProperty("_showName", _SINGLETON_PARAMETER, "false"));
                } else {
                    stringBuffer.append(this._momlDeleteProperty("_showName"));
                }
            }
            stringBuffer.append("</port>");
        }
        return stringBuffer.toString();
    }

    private boolean _isPropertySet(NamedObj namedObj, String string) {
        Attribute attribute = namedObj.getAttribute(string);
        if (attribute == null) {
            return false;
        }
        if (attribute instanceof Parameter) {
            try {
                Token token = ((Parameter)attribute).getToken();
                if (token instanceof BooleanToken && !((BooleanToken)token).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalActionException illegalActionException) {}
        }
        return true;
    }

    private String _momlProperty(String string, String string2, String string3) {
        if (string2 != null) {
            return "<property name=\"" + string + "\" " + "class = \"" + string2 + "\" " + "value = \"" + string3 + "\"/>";
        }
        return "<property name=\"" + string + "\" " + "value = \"" + string3 + "\"/>";
    }

    private String _momlDeleteProperty(String string) {
        return "<deleteProperty name=\"" + string + "\"/>";
    }

    public void changeExecuted(ChangeRequest changeRequest) {
    }

    public void changeFailed(ChangeRequest changeRequest, Exception exception) {
        if (changeRequest != null && changeRequest.getSource() != this) {
            return;
        }
        if (changeRequest != null && !changeRequest.isErrorReported()) {
            changeRequest.setErrorReported(true);
            MessageHandler.error((String)"Rename failed: ", (Throwable)exception);
        }
    }

    public void changed(String string) {
        this._changed = true;
    }
}

