/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.gui.IOptionsFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public abstract class OptionsFactory
extends Attribute
implements IOptionsFactory {
    private Map options = new HashMap();
    private Map defaultOptions = new HashMap();

    public OptionsFactory(Actor actor, String string) throws IllegalActionException, NameDuplicationException {
        super((NamedObj)actor, string);
    }

    protected IOptionsFactory.Option addOption(String string, String string2, Object object) {
        if (string == null) {
            return null;
        }
        IOptionsFactory.Option option = new IOptionsFactory.Option(string2, object);
        this.getOptionsForParameter(string, true).put(string2, option);
        return option;
    }

    protected IOptionsFactory.Option removeOption(String string, String string2) {
        if (string == null || this.getOptionsForParameter(string, false) == null) {
            return null;
        }
        IOptionsFactory.Option option = (IOptionsFactory.Option)this.getOptionsForParameter(string, false).remove(string2);
        return option;
    }

    protected void setDefaultOption(String string, IOptionsFactory.Option option) throws IllegalArgumentException {
        if (string == null || option == null || this.getOptionsForParameter(string, false) == null || !this.getOptionsForParameter(string, false).containsKey(option.getLabel())) {
            throw new IllegalArgumentException("invalid default option " + option + " for parameter " + string);
        }
        this.defaultOptions.put(string, option);
    }

    @Override
    public IOptionsFactory.Option getDefaultOption(Parameter parameter) {
        Iterator iterator;
        if (parameter == null) {
            return null;
        }
        IOptionsFactory.Option option = (IOptionsFactory.Option)this.defaultOptions.get(parameter.getName());
        if (option == null && this.getOptionsForParameter(parameter.getName(), false) != null && (iterator = this.getOptionsForParameter(parameter.getName(), false).values().iterator()).hasNext()) {
            option = (IOptionsFactory.Option)iterator.next();
            this.defaultOptions.put(parameter.getName(), option);
        }
        return option;
    }

    @Override
    public IOptionsFactory.Option getOption(Parameter parameter, String string) {
        if (parameter == null || this.getOptionsForParameter(parameter.getName(), false) == null) {
            return null;
        }
        return (IOptionsFactory.Option)this.getOptionsForParameter(parameter.getName(), false).get(string);
    }

    @Override
    public void setOptionsForParameter(Parameter parameter) {
        IOptionsFactory.Option option2;
        if (parameter == null || this.getOptionsForParameter(parameter.getName(), false) == null) {
            return;
        }
        parameter.removeAllChoices();
        for (IOptionsFactory.Option option2 : this.getOptionsForParameter(parameter.getName(), false).values()) {
            parameter.addChoice(option2.getLabel());
        }
        if ((parameter.getExpression() == null || parameter.getExpression().length() == 0) && (option2 = this.getDefaultOption(parameter)) != null) {
            parameter.setExpression(option2.getLabel());
        }
    }

    private Map getOptionsForParameter(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = (HashMap)this.options.get(string);
        if (hashMap == null && bl) {
            hashMap = new HashMap();
            this.options.put(string, hashMap);
        }
        return hashMap;
    }

    protected abstract void initializeOptions();
}

