/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.message.IMessageReceiver;
import com.isencia.message.IReceiverChannel;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Source;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class MessageReceiverSource
extends Source {
    private static Logger logger = LoggerFactory.getLogger(MessageReceiverSource.class);
    private IMessageReceiver messageReceiver = null;

    public MessageReceiverSource(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    public IMessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInitialize() throws InitializationException {
        Collection collection;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        this.messageReceiver = this.createMessageReceiver();
        if (this.messageReceiver == null) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "MessageReceiver for " + this.getInfo() + " not created correctly.", this, null);
        }
        IMessageInterceptorChain iMessageInterceptorChain = this.createInterceptorChainOnLeave();
        Collection collection2 = collection = this.messageReceiver.getChannels();
        synchronized (collection2) {
            for (IReceiverChannel iReceiverChannel : collection) {
                iReceiverChannel.setInterceptorChainOnLeave(iMessageInterceptorChain);
            }
        }
        this.messageReceiver.open();
        if (logger.isInfoEnabled()) {
            logger.info(String.valueOf(this.getInfo()) + " - Opened :" + this.getMessageReceiver());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected void doWrapUp() throws TerminationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doWrapUp();
        this.getMessageReceiver().close();
        if (logger.isInfoEnabled()) {
            logger.info(String.valueOf(this.getInfo()) + " - Closed :" + this.getMessageReceiver());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected abstract IMessageInterceptorChain createInterceptorChainOnLeave();

    protected abstract IMessageReceiver createMessageReceiver();

    @Override
    protected ManagedMessage getMessage() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        ManagedMessage managedMessage = null;
        try {
            if (this.messageReceiver != null) {
                managedMessage = (ManagedMessage)this.messageReceiver.getMessage();
            }
        }
        catch (Exception exception) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " - getMessage() generated an exception in messageReceiver.getMessage() :" + exception, managedMessage, exception);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " - Received :" + managedMessage);
        }
        return managedMessage;
    }
}

