/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.FilterException;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class Filter
extends Actor {
    private static Logger logger = LoggerFactory.getLogger(Filter.class);
    private ManagedMessage message = null;
    private Token token = null;
    public Port input = PortFactory.getInstance().createInputPort(this, String.class);
    private PortHandler inputHandler = null;
    public Port outputOk = PortFactory.getInstance().createOutputPort(this, "outputOk");
    public Port outputNotOk = PortFactory.getInstance().createOutputPort(this, "outputNotOk");

    public Filter(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-20\" width=\"40\" height=\"40\" style=\"fill:lightgrey;stroke:lightgrey\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"19\" y2=\"-19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"-19\" x2=\"-19\" y2=\"19\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"20\" y1=\"-19\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-19\" y1=\"20\" x2=\"20\" y2=\"20\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"19\" y1=\"-18\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"-18\" y1=\"19\" x2=\"19\" y2=\"19\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"10\" y1=\"-15\" x2=\"10\" y2=\"-8\" style=\"stroke-width:3.0\"/>\n<line x1=\"10\" y1=\"8\" x2=\"10\" y2=\"15\" style=\"stroke-width:3.0\"/>\n<line x1=\"-10\" y1=\"0\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"-3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"10\" y1=\"3\" x2=\"15\" y2=\"0\" style=\"stroke-width:2.0;stroke:blue\"/>\n<line x1=\"-10\" y1=\"-10\" x2=\"5\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"-13\" x2=\"5\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"-7\" x2=\"5\" y2=\"-10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"-10\" y1=\"10\" x2=\"5\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"7\" x2=\"5\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n<line x1=\"0\" y1=\"13\" x2=\"5\" y2=\"10\" style=\"stroke-width:1.0;stroke:red\"/>\n</svg>\n");
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        if (this.input.getWidth() > 0) {
            this.inputHandler = new PortHandler((IOPort)this.input);
            this.inputHandler.start();
        } else {
            this.requestFinish();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected abstract boolean isMatchingFilter(Object var1) throws FilterException;

    @Override
    protected boolean doPreFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - entry");
        }
        this.token = this.inputHandler.getToken();
        if (this.token != null) {
            try {
                this.message = MessageHelper.getMessageFromToken(this.token);
            }
            catch (PasserelleException passerelleException) {
                throw new ProcessingException("Error handling token", this.token, passerelleException);
            }
        } else {
            this.message = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - exit");
        }
        return super.doPreFire();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doFire() throws ProcessingException {
        if (Filter.logger.isTraceEnabled()) {
            Filter.logger.trace(this.getInfo());
        }
        if (this.message != null) {
            this.notifyStartingFireProcessing();
            try {
                if (Filter.logger.isDebugEnabled()) {
                    Filter.logger.debug(String.valueOf(this.getInfo()) + " - Filter received message :" + this.message);
                }
                var1_1 = false;
                try {
                    var1_1 = this.isMatchingFilter(this.message);
                }
                catch (FilterException var2_2) {
                    Filter.logger.error(this.getInfo(), (Throwable)var2_2);
                }
                if (var1_1) {
                    try {
                        this.outputOk.broadcast(this.token);
                    }
                    catch (Throwable var2_3) {
                        throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception during sending to output OK port " + var2_3, this.message, var2_3);
                    }
                    if (Filter.logger.isInfoEnabled()) {
                        Filter.logger.info(String.valueOf(this.getInfo()) + " - Sent message OK :" + this.token);
                    }
                    if (!Filter.getAuditLogger().isInfoEnabled()) ** GOTO lbl39
                    Filter.getAuditLogger().info("Sent message OK");
                }
                try {
                    this.outputNotOk.broadcast(this.token);
                }
                catch (Throwable var2_4) {
                    throw new ProcessingException(String.valueOf(this.getInfo()) + " - doFire() generated exception during sending to output NOT OK port " + var2_4, this.message, var2_4);
                }
                if (Filter.logger.isInfoEnabled()) {
                    Filter.logger.info(String.valueOf(this.getInfo()) + " - Sent message NOT OK :" + this.token);
                }
                if (!Filter.getAuditLogger().isInfoEnabled()) ** GOTO lbl39
                Filter.getAuditLogger().info("Sent message NOT OK");
            }
            finally {
                this.notifyFinishedFireProcessing();
            }
        } else {
            this.requestFinish();
        }
lbl39:
        // 5 sources

        if (Filter.logger.isTraceEnabled()) {
            Filter.logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }
}

