/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.actor.ValidationException;
import com.isencia.passerelle.actor.gui.EditorIcon;
import com.isencia.passerelle.actor.gui.IOptionsFactory;
import com.isencia.passerelle.actor.gui.OptionsFactory;
import com.isencia.passerelle.core.ControlPort;
import com.isencia.passerelle.core.ErrorPort;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.PasserelleToken;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListenerAdapter;
import com.isencia.passerelle.domain.cap.BlockingQueueReceiver;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.ext.ErrorControlStrategy;
import com.isencia.passerelle.ext.impl.DefaultActorErrorControlStrategy;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageAndPort;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.interceptor.IMessageCreator;
import com.isencia.passerelle.statistics.ActorStatistics;
import com.isencia.passerelle.statistics.StatisticsServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public abstract class Actor
extends TypedAtomicActor
implements IMessageCreator {
    private static Logger logger = LoggerFactory.getLogger(Actor.class);
    private static Logger auditLogger = LoggerFactory.getLogger((String)"audit");
    private ActorStatistics statistics;
    private ErrorControlStrategy errorControlStrategy;
    private boolean finishRequested = false;
    private boolean mockMode = false;
    private ControlPort requestFinishPort = null;
    private PortHandler requestFinishHandler;
    protected ErrorPort errorPort = null;
    private ControlPort hasFinishedPort = null;
    private ControlPort hasFiredPort = null;
    protected boolean isFiring = false;
    public static final String OPTIONS_FACTORY_CFG_NAME = "_optionsFactory";
    private IOptionsFactory optionsFactory;
    private Collection<Parameter> configurableParameters = new ArrayList<Parameter>();
    private Collection<Parameter> expertParameters = new ArrayList<Parameter>();
    protected Map<String, String> actorMsgHeaders = new HashMap<String, String>();
    public Parameter receiverQueueWarningSizeParam;
    public Parameter receiverQueueCapacityParam;

    public Actor(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.createPaneFactory();
        this.requestFinishPort = PortFactory.getInstance().createInputControlPort(this, "requestFinish");
        this.errorPort = PortFactory.getInstance().createOutputErrorPort(this);
        this.hasFiredPort = PortFactory.getInstance().createOutputControlPort(this, "hasFired");
        this.hasFinishedPort = PortFactory.getInstance().createOutputControlPort(this, "hasFinished");
        this.receiverQueueCapacityParam = new Parameter((NamedObj)this, "Receiver Q Capacity (-1)", (Token)new IntToken(-1));
        this.receiverQueueWarningSizeParam = new Parameter((NamedObj)this, "Receiver Q warning size (-1)", (Token)new IntToken(-1));
        this.registerExpertParameter(this.receiverQueueCapacityParam);
        this.registerExpertParameter(this.receiverQueueWarningSizeParam);
        try {
            new EditorIcon((NamedObj)this, "_icon");
        }
        catch (Throwable throwable) {}
        this.actorMsgHeaders.put("__PSRL_SRC_REF", this.getFullName());
        this.statistics = new ActorStatistics(this);
    }

    public String getFullNameButWithoutModelName() {
        String string = this.getFullName();
        int n = string.indexOf(".", 1);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public final String getInfo() {
        return String.valueOf(this.getName()) + " - " + this.getExtendedInfo();
    }

    protected abstract String getExtendedInfo();

    protected void createPaneFactory() throws IllegalActionException, NameDuplicationException {
    }

    public IOptionsFactory getOptionsFactory() {
        try {
            Attribute attribute = this.getAttribute(OPTIONS_FACTORY_CFG_NAME, OptionsFactory.class);
            if (attribute != this.optionsFactory) {
                this.optionsFactory = (OptionsFactory)attribute;
            }
        }
        catch (IllegalActionException illegalActionException) {
            logger.error("Error during getting of OptionsFactory attribute", (Throwable)illegalActionException);
        }
        return this.optionsFactory;
    }

    protected void setOptionsFactory(IOptionsFactory iOptionsFactory) {
        this.optionsFactory = iOptionsFactory;
    }

    public final void preinitialize() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " preinitialize() - entry");
        }
        super.preinitialize();
        try {
            this.doPreInitialize();
        }
        catch (InitializationException initializationException) {
            logger.error(String.valueOf(this.getInfo()) + " generated exception during doPreInitialize()", (Throwable)initializationException);
            throw new IllegalActionException((Nameable)this, initializationException.toString());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " preinitialize() - exit ");
        }
    }

    public Receiver newReceiver() throws IllegalActionException {
        Receiver receiver = super.newReceiver();
        if (receiver instanceof BlockingQueueReceiver) {
            BlockingQueueReceiver blockingQueueReceiver = (BlockingQueueReceiver)receiver;
            int n = ((IntToken)this.receiverQueueCapacityParam.getToken()).intValue();
            blockingQueueReceiver.setCapacity(n);
            int n2 = ((IntToken)this.receiverQueueWarningSizeParam.getToken()).intValue();
            blockingQueueReceiver.setSizeWarningThreshold(n2);
        }
        return receiver;
    }

    protected void doPreInitialize() throws InitializationException {
    }

    public final void initialize() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " initialize() - entry");
        }
        super.initialize();
        this.finishRequested = false;
        this.mockMode = false;
        try {
            this.mockMode = ((Director)this.getDirector()).isMockMode();
        }
        catch (ClassCastException classCastException) {}
        if (this.requestFinishPort.getWidth() > 0) {
            this.requestFinishHandler = new PortHandler((IOPort)this.requestFinishPort, new PortListenerAdapter(){

                @Override
                public void tokenReceived() {
                    if (logger.isTraceEnabled()) {
                        logger.trace(String.valueOf(Actor.this.getInfo()) + " - requestFinishHandler.tokenReceived()");
                    }
                    Actor.this.requestFinishHandler.getToken();
                    Actor.this.requestFinish();
                    if (logger.isTraceEnabled()) {
                        logger.trace(String.valueOf(Actor.this.getInfo()) + " - requestFinishHandler.tokenReceived()");
                    }
                }
            });
            this.requestFinishHandler.start();
        }
        try {
            this.doInitialize();
        }
        catch (InitializationException initializationException) {
            this.getErrorControlStrategy().handleInitializationException(this, initializationException);
        }
        this.statistics.reset();
        StatisticsServiceFactory.getService().registerStatistics(this.statistics);
        List list = this.portList();
        for (ptolemy.kernel.Port port : list) {
            if (!(port instanceof Port)) continue;
            ((Port)port).initialize();
        }
        if (Actor.getAuditLogger().isDebugEnabled()) {
            Actor.getAuditLogger().debug(String.valueOf(this.getInfo()) + " - INITIALIZED");
        }
        if (this.mustValidateInitialization()) {
            try {
                this.validateInitialization();
                if (Actor.getAuditLogger().isDebugEnabled()) {
                    Actor.getAuditLogger().debug(String.valueOf(this.getInfo()) + " - INITIALIZATION VALIDATED");
                }
            }
            catch (ValidationException validationException) {
                this.getErrorControlStrategy().handleInitializationValidationException(this, validationException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " initialize() - exit ");
        }
    }

    protected boolean mustValidateInitialization() {
        try {
            return ((Director)this.getDirector()).mustValidateInitialization();
        }
        catch (ClassCastException classCastException) {
            return true;
        }
    }

    protected void doInitialize() throws InitializationException {
    }

    protected void validateInitialization() throws ValidationException {
    }

    public final boolean isFiring() {
        return this.isFiring;
    }

    public final boolean prefire() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " prefire() - entry");
        }
        boolean bl = true;
        if (!this.isFinishRequested()) {
            try {
                bl = this.doPreFire();
            }
            catch (ProcessingException processingException) {
                this.getErrorControlStrategy().handlePreFireException(this, processingException);
            }
            catch (TerminateProcessException terminateProcessException) {
                throw terminateProcessException;
            }
            catch (RuntimeException runtimeException) {
                this.getErrorControlStrategy().handlePreFireRuntimeException(this, runtimeException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " prefire() - exit :" + bl);
        }
        return bl;
    }

    protected boolean doPreFire() throws ProcessingException {
        return true;
    }

    public final void fire() throws IllegalActionException {
        this.isFiring = true;
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(this.getInfo()) + " fire() - entry");
            }
            if (!this.isFinishRequested()) {
                try {
                    if (!this.mockMode) {
                        this.doFire();
                    } else {
                        this.doMockFire();
                    }
                }
                catch (ProcessingException processingException) {
                    this.getErrorControlStrategy().handleFireException(this, processingException);
                }
                catch (TerminateProcessException terminateProcessException) {
                    this.requestFinish();
                    throw terminateProcessException;
                }
                catch (RuntimeException runtimeException) {
                    this.getErrorControlStrategy().handleFireRuntimeException(this, runtimeException);
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(this.getInfo()) + " fire() - exit ");
            }
        }
        finally {
            this.isFiring = false;
            if (this.hasFiredPort.getWidth() > 0) {
                try {
                    this.hasFiredPort.broadcast(new PasserelleToken(MessageFactory.getInstance().createTriggerMessage()));
                }
                catch (Exception exception) {
                    logger.error(this.getInfo(), (Throwable)exception);
                }
            }
        }
    }

    protected abstract void doFire() throws ProcessingException;

    protected void doMockFire() throws ProcessingException {
        this.doFire();
    }

    public final boolean postfire() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " postfire() - entry");
        }
        boolean bl = true;
        try {
            bl = this.doPostFire();
        }
        catch (ProcessingException processingException) {
            this.getErrorControlStrategy().handlePostFireException(this, processingException);
        }
        catch (TerminateProcessException terminateProcessException) {
            throw terminateProcessException;
        }
        catch (RuntimeException runtimeException) {
            this.getErrorControlStrategy().handlePostFireRuntimeException(this, runtimeException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " postfire() - exit :" + bl);
        }
        return bl;
    }

    protected boolean doPostFire() throws ProcessingException {
        return !this.isFinishRequested();
    }

    public final void wrapup() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " wrapup() - entry");
        }
        try {
            this.doWrapUp();
        }
        catch (TerminationException terminationException) {
            this.getErrorControlStrategy().handleTerminationException(this, terminationException);
        }
        try {
            this.hasFinishedPort.broadcast(new PasserelleToken(MessageFactory.getInstance().createTriggerMessage()));
        }
        catch (Exception exception) {
            logger.error(this.getInfo(), (Throwable)exception);
        }
        for (Port port : this.outputPortList()) {
            Receiver[][] receiverArray = port.getRemoteReceivers();
            int n = 0;
            while (n < receiverArray.length) {
                if (receiverArray[n] != null) {
                    int n2 = 0;
                    while (n2 < receiverArray[n].length) {
                        if (receiverArray[n][n2].getContainer() instanceof Port) {
                            ((Port)receiverArray[n][n2].getContainer()).notifySourcePortFinished(port);
                        }
                        ++n2;
                    }
                } else {
                    logger.warn(String.valueOf(this.getInfo()) + " wrapup() - port " + port.getName() + " has a remote receiver null on channel " + n);
                }
                ++n;
            }
        }
        super.wrapup();
        if (Actor.getAuditLogger().isDebugEnabled()) {
            Actor.getAuditLogger().debug(String.valueOf(this.getInfo()) + " - WRAPPED UP");
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " wrapup() - exit ");
        }
    }

    protected void doWrapUp() throws TerminationException {
    }

    public final void terminate() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " terminate() - entry");
        }
        super.terminate();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " terminate() - exit ");
        }
    }

    public final void stopFire() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " stopfire() - entry()");
        }
        this.doStopFire();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " stopfire() - exit ");
        }
    }

    public final void stop() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " stop() - entry()");
        }
        super.stop();
        if (!this.isFinishRequested()) {
            this.requestFinish();
        }
        this.doStop();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " stop() - exit ");
        }
    }

    protected void doStopFire() {
    }

    protected void doStop() {
    }

    public final void requestFinish() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " requestfinish() - entry");
        }
        this.finishRequested = true;
        this.stopFire();
        logger.info(String.valueOf(this.getInfo()) + " FINISH REQUESTED !!");
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " requestfinish() - exit ");
        }
    }

    public final boolean isFinishRequested() {
        return this.finishRequested;
    }

    public final boolean isMockMode() {
        return this.mockMode;
    }

    public final Parameter[] getConfigurableParameters() {
        return this.configurableParameters.toArray(new Parameter[0]);
    }

    protected final void registerConfigurableParameter(Parameter parameter) {
        if (parameter != null && !this.configurableParameters.contains(parameter) && parameter.getContainer().equals(this)) {
            this.configurableParameters.add(parameter);
        }
        parameter.setVisibility(Settable.FULL);
    }

    protected final void registerExpertParameter(Parameter parameter) {
        if (parameter != null && parameter.getContainer().equals(this)) {
            if (!this.expertParameters.contains(parameter)) {
                this.expertParameters.add(parameter);
            }
            parameter.setVisibility(Settable.EXPERT);
        }
    }

    public static final Logger getAuditLogger() {
        return auditLogger;
    }

    protected final ErrorControlStrategy getErrorControlStrategy() {
        if (this.errorControlStrategy != null) {
            return this.errorControlStrategy;
        }
        try {
            ErrorControlStrategy errorControlStrategy = ((Director)this.getDirector()).getErrorControlStrategy();
            return errorControlStrategy;
        }
        catch (ClassCastException classCastException) {
            this.errorControlStrategy = new DefaultActorErrorControlStrategy();
            return this.errorControlStrategy;
        }
    }

    @Override
    public ManagedMessage createMessage() {
        return MessageFactory.getInstance().createMessage(this.getStandardMessageHeaders());
    }

    public ManagedMessage createMessage(Object object, String string) throws MessageException {
        ManagedMessage managedMessage = MessageFactory.getInstance().createMessage(this.getStandardMessageHeaders());
        managedMessage.setBodyContent(object, string);
        return managedMessage;
    }

    @Override
    public ManagedMessage createTriggerMessage() {
        return MessageFactory.getInstance().createTriggerMessage(this.getStandardMessageHeaders());
    }

    @Override
    public ManagedMessage createErrorMessage(PasserelleException passerelleException) {
        return MessageFactory.getInstance().createErrorMessage(passerelleException, this.getStandardMessageHeaders());
    }

    protected final Map<String, String> getStandardMessageHeaders() {
        return this.actorMsgHeaders;
    }

    public final void sendErrorMessage(PasserelleException passerelleException) throws IllegalActionException {
        if (logger.isInfoEnabled()) {
            logger.info(String.valueOf(this.getInfo()) + " sendErrorMessage() - generatinq error msg for exception", (Throwable)passerelleException);
        }
        if (this.errorPort.getWidth() > 0) {
            ManagedMessage managedMessage = this.createErrorMessage(passerelleException);
            PasserelleToken passerelleToken = new PasserelleToken(managedMessage);
            this.errorPort.broadcast(passerelleToken);
        } else {
            try {
                ((Director)this.getDirector()).reportError(passerelleException);
            }
            catch (ClassCastException classCastException) {
                logger.error(String.valueOf(this.getInfo()) + " sendErrorMessage() - used without Passerelle Director!!, so automated error collecting does NOT work !!");
                logger.error(String.valueOf(this.getInfo()) + " sendErrorMessage() - received exception", (Throwable)passerelleException);
            }
        }
    }

    protected void sendOutputMsg(Port port, ManagedMessage managedMessage) throws ProcessingException, IllegalArgumentException {
        this.sendOutputMsg(MessageAndPort.create(this, port, managedMessage));
    }

    protected void sendOutputMsg(MessageAndPort messageAndPort) throws ProcessingException, IllegalArgumentException {
        if (messageAndPort.getPort().getContainer() != this) {
            throw new IllegalArgumentException("port " + messageAndPort.getPort().getFullName() + " not defined in actor " + this.getFullName());
        }
        try {
            PasserelleToken passerelleToken = new PasserelleToken(messageAndPort.getMessage());
            messageAndPort.getPort().broadcast(passerelleToken);
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getInfo()) + " sendOutputMsg() - Message " + messageAndPort.getMessage().getID() + " sent on port " + messageAndPort.getPort().getName());
            }
            String string = null;
            try {
                string = this.getAuditTrailMessage(messageAndPort.getMessage(), messageAndPort.getPort());
            }
            catch (Exception exception) {
                string = "sent message on port " + messageAndPort.getPort().getFullName();
            }
            if (string != null && Actor.getAuditLogger().isInfoEnabled()) {
                Actor.getAuditLogger().info(string);
            }
        }
        catch (Exception exception) {
            throw new ProcessingException(String.valueOf(this.getInfo()) + " sendOutputMsg() - generated exception for sending msg on port " + (Object)((Object)messageAndPort.getPort()), messageAndPort.getMessage(), exception);
        }
    }

    protected String getAuditTrailMessage(ManagedMessage managedMessage, Port port) throws Exception {
        return String.valueOf(this.getInfo()) + " sent message on port " + port.getFullName();
    }

    protected final void sendOutputMsgs(MessageAndPort[] messageAndPortArray) throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " sendMessages() - entry");
        }
        if (messageAndPortArray == null || messageAndPortArray.length == 0) {
            return;
        }
        if (messageAndPortArray.length > 1) {
            Long l = MessageFactory.getInstance().createSequenceID();
            int n = 0;
            while (n < messageAndPortArray.length) {
                MessageAndPort messageAndPort = messageAndPortArray[n];
                boolean bl = n == messageAndPortArray.length - 1;
                try {
                    ManagedMessage managedMessage = MessageFactory.getInstance().createMessageCopyInSequence(messageAndPort.getMessage(), l, new Long(n), bl);
                    this.sendOutputMsg(messageAndPort.getPort(), managedMessage);
                }
                catch (MessageException messageException) {
                    throw new ProcessingException("Error creating output sequence msg for msg " + messageAndPort.getMessage().getID(), messageAndPort.getMessage(), messageException);
                }
                ++n;
            }
        } else {
            this.sendOutputMsg(messageAndPortArray[0].getPort(), messageAndPortArray[0].getMessage());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " sendMessages() - exit");
        }
    }

    protected void notifyStartingFireProcessing() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " notifyStartingFireProcessing() - entry");
        }
        this.statistics.beginCycle();
        this.isFiring = true;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " notifyStartingFireProcessing() - exit");
        }
    }

    protected void notifyFinishedFireProcessing() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " notifyFinishedFireProcessing() - entry");
        }
        this.statistics.endCycle();
        this.isFiring = false;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " notifyFinishedFireProcessing() - exit");
        }
    }
}

