/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.requestreply;

import com.isencia.message.ChannelException;
import com.isencia.message.IMessageListener;
import com.isencia.message.IReceiverChannel;
import com.isencia.message.ISenderChannel;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.message.requestreply.IMessage;
import com.isencia.message.requestreply.IRequestReplyChannel;
import com.isencia.message.requestreply.RequestMessage;
import java.util.Collection;

public class ReceiverSenderChannelPair
implements IRequestReplyChannel {
    private IReceiverChannel rcvChannel;
    private ISenderChannel sndChannel;

    public ReceiverSenderChannelPair(IReceiverChannel iReceiverChannel, ISenderChannel iSenderChannel) {
        this.rcvChannel = iReceiverChannel;
        this.sndChannel = iSenderChannel;
    }

    protected IReceiverChannel getReceiverChannel() {
        return this.rcvChannel;
    }

    protected ISenderChannel getSenderChannel() {
        return this.sndChannel;
    }

    @Override
    public void open() throws ChannelException {
        this.getReceiverChannel().open();
        try {
            this.getSenderChannel().open();
        }
        catch (ChannelException channelException) {
            try {
                this.getReceiverChannel().close();
            }
            catch (ChannelException channelException2) {}
            throw channelException;
        }
    }

    @Override
    public void close() throws ChannelException {
        ChannelException channelException = null;
        try {
            this.getReceiverChannel().close();
        }
        catch (ChannelException channelException2) {
            channelException = channelException2;
        }
        this.getSenderChannel().close();
        if (channelException != null) {
            throw channelException;
        }
    }

    @Override
    public void sendResponse(Object object, Object object2) throws ChannelException {
        try {
            this.getSenderChannel().sendMessage(object);
        }
        catch (InterruptedException interruptedException) {
            throw new ChannelException("Interrupted :" + interruptedException.getMessage());
        }
    }

    @Override
    public void setInterceptorChainForResponse(IMessageInterceptorChain iMessageInterceptorChain) {
        this.getSenderChannel().setInterceptorChainOnEnter(iMessageInterceptorChain);
    }

    @Override
    public Collection getListeners() {
        return this.getReceiverChannel().getListeners();
    }

    @Override
    public void addListener(IMessageListener iMessageListener) {
        this.getReceiverChannel().addListener(iMessageListener);
    }

    @Override
    public void addListeners(Collection collection) {
        this.getReceiverChannel().addListeners(collection);
    }

    @Override
    public boolean removeListener(IMessageListener iMessageListener) {
        return this.getReceiverChannel().removeListener(iMessageListener);
    }

    @Override
    public boolean isOpen() {
        return this.getReceiverChannel().isOpen();
    }

    @Override
    public IMessage receiveRequest() throws NoMoreMessagesException, ChannelException {
        return new RequestMessage(this.getMessage());
    }

    @Override
    public Object getMessage() throws ChannelException, NoMoreMessagesException {
        return this.getReceiverChannel().getMessage();
    }

    @Override
    public void setInterceptorChainOnLeave(IMessageInterceptorChain iMessageInterceptorChain) {
        this.getReceiverChannel().setInterceptorChainOnLeave(iMessageInterceptorChain);
    }

    @Override
    public void run() {
        this.getReceiverChannel().run();
    }
}

