/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import com.isencia.message.ChannelException;
import com.isencia.message.SenderChannel;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramSenderChannel
extends SenderChannel {
    private static final Logger logger = LoggerFactory.getLogger(DatagramSenderChannel.class);
    private static final int defaultByteBufferSize = 8192;
    private DatagramSocket socket = null;
    private int remotePort = -1;
    private String remoteHostName = "";
    private InetAddress remoteHost = null;

    public DatagramSenderChannel(String string, int n) throws ChannelException {
        this.setRemoteHostName(string);
        this.setRemotePort(n);
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (this.socket == null) {
            try {
                this.socket = new DatagramSocket();
            }
            catch (SocketException socketException) {
                throw new ChannelException("Socket construction failed " + socketException.getMessage());
            }
        }
        if (!this.isOpen()) {
            super.open();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        if (this.isOpen()) {
            super.close();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int n) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("setRemotePort() - entry :" + n);
        }
        if (n < 0) {
            throw new ChannelException("Remote port (" + n + ") not set correctly");
        }
        this.remotePort = n;
        if (logger.isTraceEnabled()) {
            logger.trace("setRemotePort() - exit");
        }
    }

    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    public void setRemoteHostName(String string) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("setRemoteHostName() - entry :" + string);
        }
        if (string == null || this.remotePort < 0) {
            throw new ChannelException("Remote host (" + string + ") not set correctly");
        }
        this.remoteHostName = string;
        try {
            this.remoteHost = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ChannelException("Unknown host " + string);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("setRemoteHostName() - exit");
        }
    }

    public void setDestination(String string, int n) throws ChannelException {
        this.setRemoteHostName(string);
        this.setRemotePort(n);
    }

    @Override
    protected void doSendMessage(Object object) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("doSendMessage() - entry :" + object);
        }
        byte[] byArray = object.toString().getBytes();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.getRemoteHost(), this.getRemotePort());
        this.socket.send(datagramPacket);
        if (logger.isTraceEnabled()) {
            logger.trace("doSendMessage() - exit");
        }
    }

    protected InetAddress getRemoteHost() {
        return this.remoteHost;
    }
}

