/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;

public class DatagramReader
extends Reader {
    private static final Logger logger = LoggerFactory.getLogger(DatagramReader.class);
    private ByteToCharConverter btc;
    private static final int defaultByteBufferSize = 8192;
    private byte[] bb;
    private DatagramSocket socket = null;
    private int nBytes = 0;
    private int nextByte = 0;

    public DatagramReader(DatagramSocket datagramSocket) {
        this(datagramSocket, ByteToCharConverter.getDefault());
    }

    public DatagramReader(DatagramSocket datagramSocket, String string) throws UnsupportedEncodingException {
        this(datagramSocket, ByteToCharConverter.getConverter((String)string));
    }

    public DatagramReader(DatagramSocket datagramSocket, ByteToCharConverter byteToCharConverter) {
        super(datagramSocket);
        if (datagramSocket == null) {
            throw new NullPointerException("socket is null");
        }
        this.socket = datagramSocket;
        this.btc = byteToCharConverter;
        this.bb = new byte[8192];
    }

    protected int readNext(byte[] byArray) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.socket.receive(datagramPacket);
        logger.debug("readNext() - Received datagram packet:\n" + datagramPacket.getData());
        return datagramPacket.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            if (this.btc != null) {
                return this.btc.getCharacterEncoding();
            }
            return null;
        }
    }

    private void malfunction() {
        throw new InternalError("Converter malfunction (" + this.btc.getCharacterEncoding() + ") -- please submit a bug report via " + System.getProperty("info@isencia.be"));
    }

    private int convertInto(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.nextByte < this.nBytes) {
            try {
                n3 = this.btc.convert(this.bb, this.nextByte, this.nBytes, cArray, n, n2);
                this.nextByte = this.nBytes;
                if (this.btc.nextByteIndex() != this.nextByte) {
                    this.malfunction();
                }
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                this.nextByte = this.btc.nextByteIndex();
                n3 = this.btc.nextCharIndex() - n;
            }
        }
        return n3;
    }

    private int flushInto(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            n3 = this.btc.flush(cArray, n, n2);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            n3 = this.btc.nextCharIndex() - n;
        }
        return n3;
    }

    private int fill(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.nextByte < this.nBytes) {
            n3 = this.convertInto(cArray, n, n2);
        }
        while (n + n3 < n2 - 1) {
            if (this.nBytes != -1) {
                if (n3 > 0 && !this.inReady()) break;
                this.nBytes = this.readNext(this.bb);
            }
            if (this.nBytes == -1) {
                this.nBytes = 0;
                if ((n3 += this.flushInto(cArray, n + n3, n2)) != 0) break;
                return -1;
            }
            this.nextByte = 0;
            n3 += this.convertInto(cArray, n + n3, n2);
        }
        cArray[n + n3++] = 10;
        return n3;
    }

    private boolean inReady() {
        return false;
    }

    private void ensureOpen() throws IOException {
        if (this.socket == null) {
            throw new IOException("Socket closed");
        }
    }

    @Override
    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.read(cArray, 0, 1) == -1) {
            return -1;
        }
        return cArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                this.ensureOpen();
                if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (n2 != 0) break block5;
                return 0;
            }
            return this.fill(cArray, n, n + n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.nextByte < this.nBytes || this.inReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.socket == null) {
                return;
            }
            this.socket.close();
            this.socket = null;
            this.bb = null;
            this.btc = null;
        }
    }
}

