/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer.u3d;

import de.jreality.geometry.BallAndStickFactory;
import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.Primitives;
import de.jreality.geometry.SphereUtility;
import de.jreality.io.JrScene;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Cylinder;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.shader.CubeMap;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.util.Rectangle3D;
import de.jreality.writer.u3d.U3DClosedCylinder;
import de.jreality.writer.u3d.U3DTexture;
import de.jreality.writer.u3d.texture.SphereMapGenerator;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class U3DSceneUtility {
    static final Geometry POINT_SPHERE = SphereUtility.tessellatedIcosahedronSphere(1);
    static final Geometry LINE_CYLINDER = new U3DClosedCylinder(8, 1.0);
    private static final IndexedFaceSet SPHERE = SphereUtility.tessellatedIcosahedronSphere(2, true);
    private static final IndexedFaceSet CYLINDER = Primitives.cylinder(60);

    public static HashMap<SceneGraphComponent, Collection<SceneGraphComponent>> getParentsMap(Collection<SceneGraphComponent> l) {
        HashMap<SceneGraphComponent, Collection<SceneGraphComponent>> r = new HashMap<SceneGraphComponent, Collection<SceneGraphComponent>>();
        for (SceneGraphComponent c : l) {
            r.put(c, new LinkedList());
        }
        for (SceneGraphComponent c : l) {
            for (int i = 0; i < c.getChildComponentCount(); ++i) {
                SceneGraphComponent child = c.getChildComponent(i);
                Collection<SceneGraphComponent> parents = r.get(child);
                parents.add(c);
            }
        }
        return r;
    }

    private static List<SceneGraphComponent> getFlatScene_R(SceneGraphComponent root) {
        LinkedList<SceneGraphComponent> r = new LinkedList<SceneGraphComponent>();
        r.add(root);
        for (int i = 0; i < root.getChildComponentCount(); ++i) {
            r.addAll(U3DSceneUtility.getFlatScene_R(root.getChildComponent(i)));
        }
        HashSet uniqueSet = new HashSet(r);
        return new LinkedList<SceneGraphComponent>(uniqueSet);
    }

    public static List<SceneGraphComponent> getSceneGraphComponents(JrScene scene) {
        return U3DSceneUtility.getFlatScene_R(scene.getSceneRoot());
    }

    public static <T extends SceneGraphNode> HashMap<T, String> getUniqueNames(Collection<T> l) {
        HashMap<String, LinkedList<SceneGraphNode>> nameMap = new HashMap<String, LinkedList<SceneGraphNode>>();
        HashMap<SceneGraphNode, String> r = new HashMap<SceneGraphNode, String>();
        for (SceneGraphNode c : l) {
            if (c == null) continue;
            String name = c.getName();
            LinkedList<SceneGraphNode> cList = (LinkedList<SceneGraphNode>)nameMap.get(c.getName());
            if (cList == null) {
                cList = new LinkedList<SceneGraphNode>();
                nameMap.put(name, cList);
            }
            cList.add(c);
        }
        for (String name : nameMap.keySet()) {
            List nodes = (List)nameMap.get(name);
            if (nodes.size() > 1) {
                int index = 1;
                DecimalFormat df = new DecimalFormat("000");
                for (SceneGraphNode c : nodes) {
                    String newName = name + df.format(index);
                    r.put(c, newName);
                    ++index;
                }
                continue;
            }
            r.put((SceneGraphNode)nodes.get(0), name);
        }
        return r;
    }

    private static List<SceneGraphComponent> getViewNodes_R(SceneGraphComponent root) {
        LinkedList<SceneGraphComponent> r = new LinkedList<SceneGraphComponent>();
        if (root.getCamera() != null) {
            r.add(root);
        }
        for (int i = 0; i < root.getChildComponentCount(); ++i) {
            List<SceneGraphComponent> subList = U3DSceneUtility.getViewNodes_R(root.getChildComponent(i));
            if (subList.size() == 0) continue;
            r.addAll(subList);
        }
        HashSet uniqueSet = new HashSet(r);
        return new LinkedList<SceneGraphComponent>(uniqueSet);
    }

    public static List<SceneGraphComponent> getViewNodes(JrScene scene) {
        return U3DSceneUtility.getViewNodes_R(scene.getSceneRoot());
    }

    private static List<SceneGraphComponent> getLightNodes_R(SceneGraphComponent root) {
        LinkedList<SceneGraphComponent> r = new LinkedList<SceneGraphComponent>();
        if (root.getLight() != null) {
            r.add(root);
        }
        for (int i = 0; i < root.getChildComponentCount(); ++i) {
            List<SceneGraphComponent> subList = U3DSceneUtility.getLightNodes_R(root.getChildComponent(i));
            if (subList.size() == 0) continue;
            r.addAll(subList);
        }
        HashSet uniqueSet = new HashSet(r);
        return new LinkedList<SceneGraphComponent>(uniqueSet);
    }

    public static List<SceneGraphComponent> getLightNodes(JrScene scene) {
        return U3DSceneUtility.getLightNodes_R(scene.getSceneRoot());
    }

    public static void printComponents(Collection<SceneGraphComponent> l) {
        System.out.println("SceneGraphComponents -------------------");
        for (SceneGraphComponent c : l) {
            System.out.println(c.getName());
        }
        System.out.println("----------------------------------------");
    }

    public static <T extends SceneGraphNode> void printNameMap(HashMap<T, String> map) {
        System.out.println("Names ----------------------------------");
        for (SceneGraphNode c : map.keySet()) {
            System.out.println(c.getName() + " -> " + map.get(c));
        }
        System.out.println("----------------------------------------");
    }

    public static void printNodes(String title, Collection<? extends SceneGraphNode> l) {
        System.out.println(title + " -----------------------------");
        for (SceneGraphNode sceneGraphNode : l) {
            System.out.println(sceneGraphNode.getName());
        }
        System.out.println("----------------------------------------");
    }

    public static void printTextures(Collection<U3DTexture> l) {
        System.out.println("Textures -----------------------------");
        for (U3DTexture g : l) {
            System.out.println(g.getImage());
        }
        System.out.println("----------------------------------------");
    }

    public static <T extends EffectiveAppearance> void printAppearanceNameMap(HashMap<T, String> map) {
        System.out.println("Material Names ----------------------------------");
        for (EffectiveAppearance c : map.keySet()) {
            System.out.println(c + " -> " + map.get(c));
        }
        System.out.println("----------------------------------------");
    }

    public static <T extends U3DTexture> void printTextureNameMap(HashMap<T, String> map) {
        System.out.println("Texture Names ----------------------------------");
        for (U3DTexture c : map.keySet()) {
            System.out.println(c.getImage() + " -> " + map.get(c));
        }
        System.out.println("----------------------------------------");
    }

    private static List<Geometry> getGeometries_R(SceneGraphComponent root) {
        LinkedList<Geometry> r = new LinkedList<Geometry>();
        if (root.getGeometry() != null) {
            r.add(root.getGeometry());
        }
        for (int i = 0; i < root.getChildComponentCount(); ++i) {
            List<Geometry> subList = U3DSceneUtility.getGeometries_R(root.getChildComponent(i));
            if (subList.size() == 0) continue;
            r.addAll(subList);
        }
        HashSet uniqueSet = new HashSet(r);
        return new LinkedList<Geometry>(uniqueSet);
    }

    public static List<Geometry> getGeometries(JrScene scene) {
        return U3DSceneUtility.getGeometries_R(scene.getSceneRoot());
    }

    private static List<Camera> getCameras_R(SceneGraphComponent root) {
        LinkedList<Camera> r = new LinkedList<Camera>();
        if (root.getCamera() != null) {
            r.add(root.getCamera());
        }
        for (int i = 0; i < root.getChildComponentCount(); ++i) {
            List<Camera> subList = U3DSceneUtility.getCameras_R(root.getChildComponent(i));
            if (subList.size() == 0) continue;
            r.addAll(subList);
        }
        HashSet uniqueSet = new HashSet(r);
        return new LinkedList<Camera>(uniqueSet);
    }

    public static List<Camera> getCameras(JrScene scene) {
        return U3DSceneUtility.getCameras_R(scene.getSceneRoot());
    }

    private static List<Light> getLights_R(SceneGraphComponent root) {
        LinkedList<Light> r = new LinkedList<Light>();
        if (root.getLight() != null) {
            r.add(root.getLight());
        }
        for (int i = 0; i < root.getChildComponentCount(); ++i) {
            List<Light> subList = U3DSceneUtility.getLights_R(root.getChildComponent(i));
            if (subList.size() == 0) continue;
            r.addAll(subList);
        }
        HashSet uniqueSet = new HashSet(r);
        return new LinkedList<Light>(uniqueSet);
    }

    public static List<Light> getLights(JrScene scene) {
        return U3DSceneUtility.getLights_R(scene.getSceneRoot());
    }

    public static IndexedFaceSet prepareFaceSet(IndexedFaceSet ifs) {
        IntArrayArray fData = (IntArrayArray)ifs.getFaceAttributes(Attribute.INDICES);
        if (fData == null) {
            return ifs;
        }
        int[][] faces = fData.toIntArrayArray(null);
        boolean needsTreatment = false;
        int numFaces = 0;
        for (int i = 0; i < faces.length; ++i) {
            if (faces[i].length != 3) {
                needsTreatment = true;
                numFaces += faces[i].length - 2;
                continue;
            }
            ++numFaces;
        }
        if (!needsTreatment) {
            return ifs;
        }
        IndexedFaceSet rifs = new IndexedFaceSet();
        int[][] newFaceData = new int[numFaces][];
        int j = 0;
        for (int[] f : faces) {
            if (f.length != 3) {
                int k;
                int v = f.length;
                for (k = 0; k < v / 2 - 1; ++k) {
                    newFaceData[j++] = new int[]{f[k], f[k + 1], f[v - 1 - k]};
                    newFaceData[j++] = new int[]{f[k + 1], f[v - 2 - k], f[v - 1 - k]};
                }
                if (v % 2 == 0) continue;
                k = v / 2 - 1;
                newFaceData[j++] = new int[]{f[k], f[k + 1], f[k + 2]};
                continue;
            }
            newFaceData[j++] = f;
        }
        rifs.setVertexCountAndAttributes(ifs.getVertexAttributes());
        rifs.setFaceCountAndAttributes(Attribute.INDICES, new IntArrayArray.Array(newFaceData).readOnlyList());
        if (ifs.getFaceAttributes(Attribute.NORMALS) != null) {
            IndexedFaceSetUtility.calculateAndSetFaceNormals(rifs);
        }
        return rifs;
    }

    static void prepareTubesAndSpheres(SceneGraphComponent root) {
        SceneGraphComponent dummy = new SceneGraphComponent();
        dummy.addChild(root);
        dummy.childrenWriteAccept(new SceneGraphVisitor(){
            SceneGraphPath p = new SceneGraphPath();

            public void visit(SceneGraphComponent c) {
                this.p.push(c);
                SceneGraphComponent basPoints = null;
                SceneGraphComponent basLines = null;
                Geometry g = c.getGeometry();
                if (g != null && g instanceof PointSet) {
                    IndexedLineSet ils;
                    EffectiveAppearance ea = EffectiveAppearance.create(this.p);
                    DefaultGeometryShader dgs = ShaderUtility.createDefaultGeometryShader(ea);
                    DefaultPointShader dps = (DefaultPointShader)dgs.getPointShader();
                    DefaultPolygonShader dpos = (DefaultPolygonShader)dps.getPolygonShader();
                    if (g instanceof IndexedLineSet) {
                        ils = (IndexedLineSet)g;
                    } else {
                        ils = new IndexedLineSet();
                        ils.setVertexCountAndAttributes(((PointSet)g).getVertexAttributes());
                    }
                    if (dgs.getShowPoints().booleanValue()) {
                        BallAndStickFactory bsf = new BallAndStickFactory(ils);
                        bsf.setBallGeometry(POINT_SPHERE);
                        bsf.setBallColor(dpos.getDiffuseColor());
                        bsf.setBallRadius(dps.getPointRadius());
                        bsf.setShowBalls(true);
                        bsf.setShowSticks(false);
                        bsf.update();
                        basPoints = bsf.getSceneGraphComponent();
                        basPoints.setOwner("foo");
                        basPoints.setName("spheres");
                        Appearance app = basPoints.getAppearance();
                        if (app == null) {
                            app = new Appearance();
                            basPoints.setAppearance(app);
                        }
                        app.setAttribute("showFaces", true);
                        if (TextureUtility.hasReflectionMap(ea, "pointShader.polygonShader")) {
                            CubeMap cm = TextureUtility.readReflectionMap(ea, "pointShader.polygonShader.reflectionMap");
                            CubeMap cmDest = TextureUtility.createReflectionMap(app, "polygonShader", cm.getBack(), cm.getFront(), cm.getBottom(), cm.getTop(), cm.getLeft(), cm.getRight());
                            cmDest.setBlendColor(cm.getBlendColor());
                        } else {
                            app.setAttribute("polygonShader.reflectionMap", Appearance.DEFAULT);
                        }
                    }
                    if (g instanceof IndexedLineSet && dgs.getShowLines().booleanValue()) {
                        DefaultLineShader dls = (DefaultLineShader)dgs.getLineShader();
                        BallAndStickFactory bsf = new BallAndStickFactory(ils);
                        bsf.setStickGeometry(LINE_CYLINDER);
                        bsf.setStickColor(((DefaultPolygonShader)dls.getPolygonShader()).getDiffuseColor());
                        bsf.setStickRadius(dls.getTubeRadius());
                        bsf.setShowBalls(false);
                        bsf.setShowSticks(true);
                        bsf.update();
                        basLines = bsf.getSceneGraphComponent();
                        basLines.setOwner("foo");
                        basLines.setName("tubes");
                        Appearance app = basLines.getAppearance();
                        if (app == null) {
                            app = new Appearance();
                            basLines.setAppearance(app);
                        }
                        app.setAttribute("showFaces", true);
                        if (TextureUtility.hasReflectionMap(ea, "lineShader.polygonShader")) {
                            CubeMap cm = TextureUtility.readReflectionMap(ea, "lineShader.polygonShader.reflectionMap");
                            CubeMap cmDest = TextureUtility.createReflectionMap(app, "polygonShader", cm.getBack(), cm.getFront(), cm.getBottom(), cm.getTop(), cm.getLeft(), cm.getRight());
                            cmDest.setBlendColor(cm.getBlendColor());
                        } else {
                            app.setAttribute("polygonShader.reflectionMap", Appearance.DEFAULT);
                        }
                    }
                }
                c.childrenWriteAccept(this, false, false, false, false, false, true);
                if (basPoints != null) {
                    c.addChild(basPoints);
                }
                if (basLines != null) {
                    c.addChild(basLines);
                }
                this.p.pop();
            }
        }, false, false, false, false, false, true);
    }

    public static HashMap<Geometry, Geometry> prepareGeometry(Collection<Geometry> geometry) {
        HashMap<Geometry, Geometry> r = new HashMap<Geometry, Geometry>();
        for (Geometry g : geometry) {
            if (g instanceof IndexedFaceSet) {
                IndexedFaceSet p = U3DSceneUtility.prepareFaceSet((IndexedFaceSet)g);
                r.put(g, p);
                continue;
            }
            if (g instanceof IndexedLineSet) {
                r.put(g, g);
                continue;
            }
            if (g instanceof PointSet) {
                r.put(g, g);
                continue;
            }
            if (g instanceof Sphere) {
                r.put(g, SPHERE);
                continue;
            }
            if (!(g instanceof Cylinder)) continue;
            r.put(g, CYLINDER);
        }
        return r;
    }

    private static void fillAppearanceMap_R(SceneGraphComponent root, HashMap<SceneGraphComponent, EffectiveAppearance> map) {
        EffectiveAppearance ea = map.get(root);
        for (int i = 0; i < root.getChildComponentCount(); ++i) {
            SceneGraphComponent child = root.getChildComponent(i);
            Appearance app = child.getAppearance();
            if (app != null) {
                EffectiveAppearance childEa = ea.create(child.getAppearance());
                map.put(child, childEa);
            } else {
                map.put(child, ea);
            }
            U3DSceneUtility.fillAppearanceMap_R(child, map);
        }
    }

    public static HashMap<SceneGraphComponent, EffectiveAppearance> getAppearanceMap(JrScene scene) {
        HashMap<SceneGraphComponent, EffectiveAppearance> map = new HashMap<SceneGraphComponent, EffectiveAppearance>();
        SceneGraphComponent root = scene.getSceneRoot();
        EffectiveAppearance ea = EffectiveAppearance.create();
        Appearance app = root.getAppearance();
        if (app != null) {
            EffectiveAppearance rootEa = ea.create(root.getAppearance());
            map.put(root, rootEa);
        } else {
            map.put(root, ea);
        }
        U3DSceneUtility.fillAppearanceMap_R(root, map);
        return map;
    }

    public static HashMap<EffectiveAppearance, String> getAppearanceNames(Collection<EffectiveAppearance> apps) {
        HashMap<EffectiveAppearance, String> map = new HashMap<EffectiveAppearance, String>();
        int number = 1;
        DecimalFormat df = new DecimalFormat("000");
        for (EffectiveAppearance ae : apps) {
            map.put(ae, "Material " + df.format(number));
            ++number;
        }
        return map;
    }

    public static HashMap<EffectiveAppearance, U3DTexture> getSphereMapsMap(Collection<EffectiveAppearance> apps) {
        HashMap<EffectiveAppearance, U3DTexture> r = new HashMap<EffectiveAppearance, U3DTexture>();
        for (EffectiveAppearance a : apps) {
            if (!TextureUtility.hasReflectionMap(a, "polygonShader")) continue;
            CubeMap tex = TextureUtility.readReflectionMap(a, "polygonShader.reflectionMap");
            r.put(a, new U3DTexture(tex));
        }
        return r;
    }

    public static HashMap<CubeMap, byte[]> prepareSphereMap(Collection<CubeMap> maps) {
        HashMap<CubeMap, byte[]> r = new HashMap<CubeMap, byte[]>();
        for (CubeMap cm : maps) {
            BufferedImage bi = SphereMapGenerator.create(cm, 768, 768);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bi, "PNG", buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            r.put(cm, buffer.toByteArray());
        }
        return r;
    }

    public static HashMap<U3DTexture, String> getTextureNames(String prefix, Collection<U3DTexture> l) {
        HashMap<U3DTexture, String> map = new HashMap<U3DTexture, String>();
        int number = 1;
        DecimalFormat df = new DecimalFormat("000");
        for (U3DTexture ae : l) {
            map.put(ae, prefix + " " + df.format(number));
            ++number;
        }
        return map;
    }

    public static HashMap<EffectiveAppearance, U3DTexture> getTextureMap(Collection<EffectiveAppearance> apps) {
        HashMap<EffectiveAppearance, U3DTexture> r = new HashMap<EffectiveAppearance, U3DTexture>();
        for (EffectiveAppearance a : apps) {
            Texture2D tex;
            if (!AttributeEntityUtility.hasAttributeEntity(Texture2D.class, "polygonShader.texture2d", a) || (tex = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, "polygonShader.texture2d", a)) == null || tex.getImage() == null) continue;
            r.put(a, new U3DTexture(tex));
        }
        return r;
    }

    public static BufferedImage getBufferedImage(ImageData img) {
        byte[] byteArray = img.getByteArray();
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 2);
        WritableRaster raster = bi.getRaster();
        int[] pix = new int[4];
        int ptr = 0;
        for (int y = 0; y < h; ++y) {
            int x = 0;
            while (x < w) {
                pix[0] = 0xFF & byteArray[ptr + 0];
                pix[1] = 0xFF & byteArray[ptr + 1];
                pix[2] = 0xFF & byteArray[ptr + 2];
                pix[3] = 0xFF & byteArray[ptr + 3];
                raster.setPixel(x, h - y - 1, pix);
                ++x;
                ptr += 4;
            }
        }
        return bi;
    }

    public static byte[] preparePNGImageData(ImageData img) {
        BufferedImage bi = U3DSceneUtility.getBufferedImage(img);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bi, "PNG", buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toByteArray();
    }

    public static HashMap<U3DTexture, byte[]> preparePNGTextures(Collection<U3DTexture> textures) {
        HashMap<U3DTexture, byte[]> r = new HashMap<U3DTexture, byte[]>();
        for (U3DTexture tex : textures) {
            ImageData img = tex.getImage();
            r.put(tex, U3DSceneUtility.preparePNGImageData(img));
        }
        return r;
    }

    public static HashMap<Geometry, Rectangle3D> getBoundingBoxes(Collection<Geometry> l) {
        HashMap<Geometry, Rectangle3D> r = new HashMap<Geometry, Rectangle3D>();
        for (Geometry g : l) {
            if (g instanceof PointSet) {
                PointSet ps = (PointSet)g;
                r.put(g, BoundingBoxUtility.calculateBoundingBox(ps));
                continue;
            }
            r.put(g, new Rectangle3D(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE));
        }
        return r;
    }

    public static SceneGraphComponent getSkyBox(JrScene scene) {
        Appearance rootApp = scene.getSceneRoot().getAppearance();
        if (rootApp == null) {
            return null;
        }
        CubeMap skyBox = (CubeMap)AttributeEntityUtility.createAttributeEntity(CubeMap.class, "skyBox", rootApp, true);
        if (skyBox == null) {
            return null;
        }
        if (skyBox.getFront() == null || skyBox.getBack() == null || skyBox.getLeft() == null || skyBox.getRight() == null || skyBox.getTop() == null || skyBox.getBottom() == null) {
            return null;
        }
        SceneGraphComponent r = new SceneGraphComponent();
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(4);
        ifsf.setFaceCount(1);
        ifsf.setVertexCoordinates(new double[][]{{1.0, 1.0, 0.0}, {1.0, -1.0, 0.0}, {-1.0, -1.0, 0.0}, {-1.0, 1.0, 0.0}});
        ifsf.setFaceIndices(new int[][]{{0, 1, 2, 3}});
        double o = 0.005;
        ifsf.setVertexTextureCoordinates(new double[][]{{1.0 - o, 1.0 - o}, {1.0 - o, o}, {o, o}, {o, 1.0 - o}});
        ifsf.update();
        SceneGraphComponent front = new SceneGraphComponent();
        Appearance frontApp = new Appearance();
        TextureUtility.createTexture(frontApp, "polygonShader", skyBox.getFront());
        front.setAppearance(frontApp);
        front.setGeometry(ifsf.getGeometry());
        front.setName("front");
        MatrixBuilder.euclidean().translate(0.0, 0.0, 1.0).rotate(Math.PI, 0.0, 1.0, 0.0).assignTo(front);
        SceneGraphComponent back = new SceneGraphComponent();
        Appearance backApp = new Appearance();
        TextureUtility.createTexture(backApp, "polygonShader", skyBox.getBack());
        back.setAppearance(backApp);
        back.setGeometry(ifsf.getGeometry());
        back.setName("back");
        MatrixBuilder.euclidean().translate(0.0, 0.0, -1.0).assignTo(back);
        SceneGraphComponent top = new SceneGraphComponent();
        Appearance topApp = new Appearance();
        TextureUtility.createTexture(topApp, "polygonShader", skyBox.getTop());
        top.setAppearance(topApp);
        top.setGeometry(ifsf.getGeometry());
        top.setName("bottom");
        MatrixBuilder.euclidean().translate(0.0, 1.0, 0.0).rotate(1.5707963267948966, 1.0, 0.0, 0.0).rotate(-1.5707963267948966, 0.0, 0.0, 1.0).assignTo(top);
        SceneGraphComponent bottom = new SceneGraphComponent();
        Appearance bottomApp = new Appearance();
        TextureUtility.createTexture(bottomApp, "polygonShader", skyBox.getBottom());
        bottom.setAppearance(bottomApp);
        bottom.setGeometry(ifsf.getGeometry());
        bottom.setName("top");
        MatrixBuilder.euclidean().translate(0.0, -1.0, 0.0).rotate(-1.5707963267948966, 1.0, 0.0, 0.0).rotate(1.5707963267948966, 0.0, 0.0, 1.0).assignTo(bottom);
        SceneGraphComponent left = new SceneGraphComponent();
        Appearance leftApp = new Appearance();
        TextureUtility.createTexture(leftApp, "polygonShader", skyBox.getLeft());
        left.setAppearance(leftApp);
        left.setGeometry(ifsf.getGeometry());
        left.setName("left");
        MatrixBuilder.euclidean().translate(-1.0, 0.0, 0.0).rotate(1.5707963267948966, 0.0, 1.0, 0.0).assignTo(left);
        SceneGraphComponent right = new SceneGraphComponent();
        Appearance rightApp = new Appearance();
        TextureUtility.createTexture(rightApp, "polygonShader", skyBox.getRight());
        right.setAppearance(rightApp);
        right.setGeometry(ifsf.getGeometry());
        right.setName("right");
        MatrixBuilder.euclidean().translate(1.0, 0.0, 0.0).rotate(-1.5707963267948966, 0.0, 1.0, 0.0).assignTo(right);
        r.addChildren(front, back, top, bottom, left, right);
        r.setName("skybox");
        MatrixBuilder.euclidean().rotate(1.5707963267948966, 0.0, 1.0, 0.0).rotate(Math.PI, 1.0, 0.0, 0.0).scale(1000.0).assignTo(r);
        Appearance skyBoxApp = new Appearance();
        skyBoxApp.setAttribute("polygonShader.lightingEnabled", false);
        skyBoxApp.setAttribute("polygonShader.ambientColor", Color.WHITE);
        skyBoxApp.setAttribute("polygonShader.ambientCoefficient", 1.0);
        skyBoxApp.setAttribute("polygonShader.diffuseCoefficient", 0.0);
        skyBoxApp.setAttribute("polygonShader.specularCoefficient", 0.0);
        r.setAppearance(skyBoxApp);
        return r;
    }

    private static void getVisibility_R(SceneGraphComponent root, HashMap<SceneGraphComponent, Boolean> map, boolean subTreeV, HashMap<SceneGraphComponent, EffectiveAppearance> appMap) {
        boolean visible = root.isVisible() && subTreeV;
        EffectiveAppearance ea = appMap.get(root);
        boolean showFaces = visible && ea.getAttribute("showFaces", true);
        map.put(root, showFaces);
        for (int i = 0; i < root.getChildComponentCount(); ++i) {
            U3DSceneUtility.getVisibility_R(root.getChildComponent(i), map, visible, appMap);
        }
    }

    public static HashMap<SceneGraphComponent, Boolean> getVisibility(JrScene scene, HashMap<SceneGraphComponent, EffectiveAppearance> appMap) {
        HashMap<SceneGraphComponent, Boolean> r = new HashMap<SceneGraphComponent, Boolean>();
        U3DSceneUtility.getVisibility_R(scene.getSceneRoot(), r, true, appMap);
        return r;
    }
}

