/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer.u3d;

import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;
import de.jreality.writer.u3d.U3DAttribute;

public class U3DClosedCylinder
extends IndexedFaceSet {
    private static final double[] zPosNormal = new double[]{0.0, 0.0, 1.0};
    private static final double[] zNegNormal = new double[]{0.0, 0.0, -1.0};

    public U3DClosedCylinder(int resolution, double thickness) {
        this.makeDisk(resolution, thickness);
        this.setVertexAttributes(U3DAttribute.U3D_NONORMALS, U3DAttribute.U3D_FLAG);
    }

    public U3DClosedCylinder(int resolution) {
        this.makeDiskNoThickness(resolution);
        this.setVertexAttributes(U3DAttribute.U3D_NONORMALS, U3DAttribute.U3D_FLAG);
    }

    private void makeDisk(int resolution, double thickness) {
        double[][] verts = new double[resolution * 2 + 2][3];
        double alpha = 0.0;
        double delta = Math.PI * 2 / (double)resolution;
        for (int i = 0; i < resolution * 2; i += 2) {
            double d = Math.cos(alpha);
            verts[i + 1][0] = d;
            verts[i][0] = d;
            double d2 = Math.sin(alpha);
            verts[i + 1][1] = d2;
            verts[i][1] = d2;
            verts[i][2] = -thickness / 2.0;
            verts[i + 1][2] = thickness / 2.0;
            alpha += delta;
        }
        verts[resolution * 2 + 0][2] = -thickness / 2.0;
        verts[resolution * 2 + 1][2] = thickness / 2.0;
        int[][] indices = new int[resolution * 3][];
        double[][] normals = new double[resolution * 3][];
        int v = 0;
        alpha = delta / 2.0;
        for (int i = 0; i < indices.length; i += 3) {
            int[] nArray = new int[3];
            indices[i + 0] = nArray;
            int[] faceUpper = nArray;
            int[] nArray2 = new int[3];
            indices[i + 1] = nArray2;
            int[] faceLower = nArray2;
            int[] nArray3 = new int[4];
            indices[i + 2] = nArray3;
            int[] faceBorder = nArray3;
            normals[i + 0] = zNegNormal;
            normals[i + 1] = zPosNormal;
            normals[i + 2] = new double[]{Math.cos(alpha), Math.sin(alpha), 0.0};
            faceUpper[0] = (v + 2) % (resolution * 2);
            faceUpper[1] = v;
            faceUpper[2] = resolution * 2;
            faceLower[0] = resolution * 2 + 1;
            faceLower[1] = v + 1;
            faceLower[2] = (v + 3) % (resolution * 2);
            faceBorder[0] = faceUpper[1];
            faceBorder[1] = faceUpper[0];
            faceBorder[2] = faceLower[2];
            faceBorder[3] = faceLower[1];
            v += 2;
            alpha += delta;
        }
        this.setNumPoints(verts.length);
        this.setNumFaces(indices.length);
        DataList vList = StorageModel.DOUBLE3_ARRAY.createReadOnly(verts);
        this.setVertexCountAndAttributes(Attribute.COORDINATES, vList);
        DataList iList = StorageModel.INT_ARRAY_ARRAY.createReadOnly(indices);
        this.setFaceCountAndAttributes(Attribute.INDICES, iList);
        this.setName("disk");
    }

    private void makeDiskNoThickness(int resolution) {
        double[][] verts = new double[resolution + 1][3];
        double[][] normals = new double[resolution + 1][];
        double alpha = 0.0;
        double delta = Math.PI * 2 / (double)resolution;
        for (double[] p : verts) {
            p[0] = Math.cos(alpha);
            p[1] = Math.sin(alpha);
            alpha += delta;
        }
        for (int i = 0; i < normals.length; ++i) {
            normals[i] = zPosNormal;
        }
        int[][] indices = new int[resolution][3];
        for (int i = 0; i < indices.length; ++i) {
            int[] face = indices[i];
            face[0] = resolution;
            face[1] = i;
            face[2] = (i + 1) % resolution;
        }
        this.setNumPoints(verts.length);
        this.setNumFaces(indices.length);
        DataList vList = StorageModel.DOUBLE3_ARRAY.createReadOnly(verts);
        this.setVertexCountAndAttributes(Attribute.COORDINATES, vList);
        DataList iList = StorageModel.INT_ARRAY_ARRAY.createReadOnly(indices);
        this.setFaceCountAndAttributes(Attribute.INDICES, iList);
    }
}

