/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Geometry;
import de.jreality.scene.Light;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Transformation;
import de.jreality.scene.Viewer;
import de.jreality.scene.event.AppearanceEvent;
import de.jreality.scene.event.AppearanceListener;
import de.jreality.scene.event.CameraEvent;
import de.jreality.scene.event.CameraListener;
import de.jreality.scene.event.GeometryEvent;
import de.jreality.scene.event.GeometryListener;
import de.jreality.scene.event.LightEvent;
import de.jreality.scene.event.LightListener;
import de.jreality.scene.event.SceneGraphComponentEvent;
import de.jreality.scene.event.SceneGraphComponentListener;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;

public class RenderTrigger
implements SceneGraphComponentListener,
TransformationListener,
AppearanceListener,
GeometryListener,
LightListener,
CameraListener {
    private boolean collect;
    private boolean async = true;
    private RenderTriggerCaster viewer;
    boolean needsRender;

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void forceRender() {
        this.fireRender();
    }

    public void addSceneGraphComponent(SceneGraphComponent c) {
        this.registerNode(c);
    }

    public void removeSceneGraphComponent(SceneGraphComponent c) {
        this.unregisterNode(c);
    }

    private void registerNode(SceneGraphNode n) {
        SceneGraphVisitor v = new SceneGraphVisitor(){

            public void visit(SceneGraphComponent c) {
                c.childrenAccept(this);
                c.addSceneGraphComponentListener(RenderTrigger.this);
            }

            public void visit(Appearance a) {
                a.addAppearanceListener(RenderTrigger.this);
            }

            public void visit(Geometry g) {
                g.addGeometryListener(RenderTrigger.this);
            }

            public void visit(Transformation t) {
                t.addTransformationListener(RenderTrigger.this);
            }

            public void visit(Light l) {
                l.addLightListener(RenderTrigger.this);
            }

            public void visit(Camera c) {
                c.addCameraListener(RenderTrigger.this);
            }
        };
        n.accept(v);
    }

    private void unregisterNode(SceneGraphNode n) {
        SceneGraphVisitor v = new SceneGraphVisitor(){

            public void visit(SceneGraphComponent c) {
                c.removeSceneGraphComponentListener(RenderTrigger.this);
                c.childrenAccept(this);
            }

            public void visit(Appearance a) {
                a.removeAppearanceListener(RenderTrigger.this);
            }

            public void visit(Geometry g) {
                g.removeGeometryListener(RenderTrigger.this);
            }

            public void visit(Transformation t) {
                t.removeTransformationListener(RenderTrigger.this);
            }

            public void visit(Light l) {
                l.removeLightListener(RenderTrigger.this);
            }

            public void visit(Camera c) {
                c.removeCameraListener(RenderTrigger.this);
            }
        };
        n.accept(v);
    }

    private void fireRender() {
        if (this.collect) {
            this.needsRender = true;
        } else if (this.viewer != null) {
            this.viewer.render(this.async);
        }
    }

    public void addViewer(Viewer v) {
        this.viewer = RenderTriggerCaster.add(this.viewer, v);
    }

    public void removeViewer(Viewer v) {
        this.viewer = RenderTriggerCaster.remove(this.viewer, v);
    }

    public void childAdded(SceneGraphComponentEvent ev) {
        this.registerNode(ev.getNewChildElement());
        this.fireRender();
    }

    public void childRemoved(SceneGraphComponentEvent ev) {
        this.unregisterNode(ev.getOldChildElement());
        this.fireRender();
    }

    public void childReplaced(SceneGraphComponentEvent ev) {
        this.unregisterNode(ev.getOldChildElement());
        this.registerNode(ev.getNewChildElement());
        this.fireRender();
    }

    public void visibilityChanged(SceneGraphComponentEvent ev) {
        this.fireRender();
    }

    public void transformationMatrixChanged(TransformationEvent ev) {
        this.fireRender();
    }

    public void appearanceChanged(AppearanceEvent ev) {
        this.fireRender();
    }

    public void geometryChanged(GeometryEvent ev) {
        this.fireRender();
    }

    public void lightChanged(LightEvent ev) {
    }

    public void startCollect() {
        this.collect = true;
        this.needsRender = false;
    }

    public void finishCollect() {
        this.collect = false;
        if (this.needsRender) {
            this.needsRender = false;
            this.fireRender();
        }
    }

    public void cameraChanged(CameraEvent ev) {
        this.fireRender();
        this.fireRender();
    }

    static final class RenderTriggerMulticaster
    extends RenderTriggerCaster {
        private final RenderTriggerCaster a;
        private final RenderTriggerCaster b;

        private RenderTriggerMulticaster(RenderTriggerCaster a, RenderTriggerCaster b) {
            this.a = a;
            this.b = b;
        }

        RenderTriggerCaster remove(Viewer oldl) {
            RenderTriggerCaster a2 = this.a.remove(oldl);
            RenderTriggerCaster b2 = this.b.remove(oldl);
            if (a2 == this.a && b2 == this.b) {
                return this;
            }
            return RenderTriggerMulticaster.add(a2, b2);
        }

        void render(boolean async) {
            this.a.render(async);
            this.b.render(async);
        }
    }

    static final class RenderTriggerSingleCaster
    extends RenderTriggerCaster {
        final Viewer v;
        private boolean rendering;

        RenderTriggerSingleCaster(Viewer viewer) {
            this.v = viewer;
        }

        RenderTriggerCaster remove(Viewer oldl) {
            return oldl != this.v ? this : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void render(boolean async) {
            if (async) {
                this.v.renderAsync();
            } else {
                RenderTriggerSingleCaster renderTriggerSingleCaster = this;
                synchronized (renderTriggerSingleCaster) {
                    if (this.rendering) {
                        return;
                    }
                    this.rendering = true;
                }
                this.v.render();
                renderTriggerSingleCaster = this;
                synchronized (renderTriggerSingleCaster) {
                    this.rendering = false;
                }
            }
        }
    }

    static abstract class RenderTriggerCaster {
        RenderTriggerCaster() {
        }

        abstract RenderTriggerCaster remove(Viewer var1);

        abstract void render(boolean var1);

        static RenderTriggerCaster add(RenderTriggerCaster a, Viewer b) {
            return RenderTriggerCaster.add(a, new RenderTriggerSingleCaster(b));
        }

        static RenderTriggerCaster add(RenderTriggerCaster a, RenderTriggerCaster b) {
            RenderTriggerCaster result = a == null ? b : (b == null ? a : new RenderTriggerMulticaster(a, b));
            return result;
        }

        static RenderTriggerCaster remove(RenderTriggerCaster l, Viewer oldl) {
            return l == null ? null : l.remove(oldl);
        }
    }
}

