/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.math.Matrix;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Secure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationAttributes
extends Properties {
    public static ConfigurationAttributes getDefaultConfiguration() {
        try {
            return new ConfigurationAttributes(Input.getInput(new File(Secure.getProperty("jreality.config", "jreality.props"))), null);
        }
        catch (IOException e) {
            LoggingSystem.getLogger(ConfigurationAttributes.class).log(Level.WARNING, "loading default Configuration", e);
            return new ConfigurationAttributes();
        }
    }

    private ConfigurationAttributes() {
    }

    public ConfigurationAttributes(Input input) {
        this.init(input, null);
    }

    public ConfigurationAttributes(Input input, ConfigurationAttributes parent) {
        this.init(input, parent);
    }

    public boolean getBool(String string) {
        return this.getProperty(string, "false").trim().equalsIgnoreCase("true");
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.getProperty(key));
    }

    public double[] getDoubleArray(String key) {
        String str = this.getProperty(key);
        if (str == null) {
            return null;
        }
        StringTokenizer toki = new StringTokenizer(str);
        double[] ret = new double[toki.countTokens()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Double.parseDouble(toki.nextToken());
        }
        return ret;
    }

    public int getInt(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public String getProperty(String key) {
        return super.getProperty(key);
    }

    public String[] getStringArray(String key, String delimiters) {
        String str = this.getProperty(key);
        if (str == null) {
            return null;
        }
        StringTokenizer toki = new StringTokenizer(str, delimiters);
        String[] ret = new String[toki.countTokens()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = toki.nextToken();
        }
        return ret;
    }

    public Matrix getTransformation(String key) {
        double[] matrix = this.getDoubleArray(key);
        if (matrix == null) {
            return null;
        }
        if (matrix.length != 16) {
            throw new RuntimeException("wrong array length for transformation!");
        }
        return new Matrix(matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Input input, ConfigurationAttributes parentAttr) {
        try {
            InputStream in = input.getInputStream();
            try {
                this.load(in);
            }
            finally {
                in.close();
            }
            this.defaults = parentAttr != null ? parentAttr : new ConfigurationAttributes();
            String parentPropFileName = this.getProperty("parent");
            if (parentPropFileName != null) {
                this.defaults.load(input.getRelativeInput(parentPropFileName).getInputStream());
            }
        }
        catch (FileNotFoundException e) {
            Logger.getLogger("de.jreality").log(Level.WARNING, "file {0} : {1} not found!", new Object[]{input, this.getProperty("parent")});
        }
        catch (IOException e) {
            Logger.getLogger("de.jreality").log(Level.WARNING, input.toString(), e);
        }
    }
}

