/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.renderman.RIBViewer;
import de.jreality.scene.Appearance;
import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ExportRIB
extends AbstractJrAction {
    private Viewer viewer;
    private JComponent options;
    private JComboBox type;
    private JCheckBox shadowsDialog;
    private JCheckBox reflectionDialog;
    private JCheckBox volumeDialog;
    private JButton includeFileDialog;
    private String includeFilePath = "";
    private JLabel includeFileLabel = new JLabel(" ");

    public ExportRIB(String name, Viewer viewer, Component parentComp) {
        super(name, parentComp);
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer is null!");
        }
        this.viewer = viewer;
        this.setShortDescription("Export Renderman file");
    }

    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.options == null) {
            this.options = this.createAccessory();
        }
        if ((file = FileLoaderDialog.selectTargetFile(this.parentComp, this.options, "rib", "RIB files")) == null) {
            return;
        }
        if (this.viewer.getSceneRoot().getAppearance() == null) {
            this.viewer.getSceneRoot().setAppearance(new Appearance());
        }
        this.viewer.getSceneRoot().getAppearance().setAttribute("rendermanShadowsEnabled", this.shadowsDialog.isSelected());
        this.viewer.getSceneRoot().getAppearance().setAttribute("rendermanRayTracingReflectionsEnabled", this.reflectionDialog.isSelected());
        this.viewer.getSceneRoot().getAppearance().setAttribute("rendermanRayTracingVolumesEnabled", this.volumeDialog.isSelected());
        if (this.includeFilePath != "") {
            this.viewer.getSceneRoot().getAppearance().setAttribute("rendermanGlobalIncludeFile", this.includeFilePath);
        }
        RIBViewer rv = new RIBViewer();
        rv.initializeFrom(this.viewer);
        rv.setRendererType(this.type.getSelectedIndex() + 1);
        rv.setFileName(file.getPath());
        rv.render();
    }

    private JComponent createAccessory() {
        JPanel panel = new JPanel(new BorderLayout());
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options");
        panel.setBorder(title);
        Box box = Box.createVerticalBox();
        box.setBorder(new EmptyBorder(5, 10, 5, 10));
        JLabel typeLabel = new JLabel(" renderer type:");
        box.add(typeLabel);
        this.type = new JComboBox<String>(new String[]{"Pixar", "3DeLight", "Aqsis", "Pixie"});
        this.type.setMaximumSize(new Dimension(1000, (int)this.type.getPreferredSize().getHeight()));
        this.type.setAlignmentX(0.0f);
        box.add(this.type);
        box.add(Box.createRigidArea(new Dimension(0, 15)));
        this.shadowsDialog = new JCheckBox("ray-traced shadows", false);
        box.add(this.shadowsDialog);
        this.reflectionDialog = new JCheckBox("ray-traced reflections", false);
        box.add(this.reflectionDialog);
        this.volumeDialog = new JCheckBox("ray-traced volumes", false);
        box.add(this.volumeDialog);
        box.add(Box.createRigidArea(new Dimension(0, 15)));
        this.includeFileDialog = new JButton("global include rib-file");
        this.includeFileDialog.setMaximumSize(new Dimension(1000, (int)this.includeFileDialog.getPreferredSize().getHeight()));
        box.add(this.includeFileDialog);
        this.includeFileDialog.setActionCommand("openIncludeFile");
        this.includeFileDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!event.getActionCommand().equals(ExportRIB.this.includeFileDialog.getActionCommand())) {
                    return;
                }
                if (ExportRIB.this.includeFilePath.equals("")) {
                    File file = FileLoaderDialog.loadFile((Component)ExportRIB.this.includeFileDialog, "rib", "RIB files");
                    if (file != null) {
                        ExportRIB.this.includeFilePath = file.getAbsolutePath();
                        if (!File.separator.equals("/")) {
                            while (ExportRIB.this.includeFilePath.contains(File.separator)) {
                                int ind = ExportRIB.this.includeFilePath.indexOf(File.separator);
                                String newPath = ind > 0 ? ExportRIB.this.includeFilePath.substring(0, ind) : "";
                                newPath = newPath + "/";
                                if (ind < ExportRIB.this.includeFilePath.length()) {
                                    newPath = newPath + ExportRIB.this.includeFilePath.substring(ind + 1);
                                }
                                ExportRIB.this.includeFilePath = newPath;
                            }
                        }
                        ExportRIB.this.includeFileDialog.setText("remove included file");
                        ExportRIB.this.includeFileLabel.setText("  > include " + file.getName());
                    }
                } else {
                    ExportRIB.this.includeFileDialog.setText("global include rib-file");
                    ExportRIB.this.includeFileLabel.setText(" ");
                    ExportRIB.this.includeFilePath = "";
                }
            }
        });
        box.add(this.includeFileLabel);
        panel.add(box);
        return panel;
    }
}

