/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.FileFilter;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.ViewerSwitch;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jtem.beans.DimensionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.beans.Statement;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class ExportImage
extends AbstractJrAction {
    private ViewerSwitch viewer;
    private DimensionPanel dimPanel;
    private JComponent options;
    private int antialiasing;
    private boolean saveAlpha = true;
    private JCheckBox checkbox;

    public ExportImage(String name, ViewerSwitch viewer, Component parentComp) {
        super(name, parentComp);
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer is null!");
        }
        this.viewer = viewer;
        this.setShortDescription("Export image file");
        this.setShortCut(73, 0, true);
    }

    public static void exportImage(Viewer realViewer, File file, int antialiasing) {
        Dimension d = realViewer.getViewingComponentSize();
        DimensionPanel dimPanel = new DimensionPanel();
        dimPanel.setDimension(d);
        Dimension dim = dimPanel.getDimension();
        if (file == null || dim == null) {
            return;
        }
        if (FileFilter.getFileExtension(file) == null) {
            System.err.println("Please specify a valid file extension.\nExport aborted.");
            return;
        }
        BufferedImage scaledImg = null;
        try {
            Expression expr = new Expression(realViewer, "renderOffscreen", new Object[]{antialiasing * dim.width, antialiasing * dim.height});
            scaledImg = (BufferedImage)expr.getValue();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        int type = 1;
        BufferedImage img = new BufferedImage(dim.width, dim.height, type);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, dim.width, dim.height);
        g.drawImage(scaledImg.getScaledInstance(dim.width, dim.height, 4), 0, 0, null);
        try {
            new Statement(Class.forName("de.jreality.util.ImageUtility"), "writeBufferedImage", new Object[]{file, img}).execute();
            System.out.println("Wrote file " + file.getPath());
        }
        catch (Exception ex) {
            throw new RuntimeException("writing image failed", ex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.options == null) {
            this.options = this.createAccessory();
        }
        Viewer realViewer = this.viewer.getCurrentViewer();
        Dimension d = realViewer.getViewingComponentSize();
        this.dimPanel.setDimension(d);
        File file = FileLoaderDialog.selectTargetFile(this.parentComp, this.options, false, FileFilter.createImageWriterFilters());
        Dimension dim = this.dimPanel.getDimension();
        if (file == null || dim == null) {
            return;
        }
        if (FileFilter.getFileExtension(file) == null) {
            System.err.println("Please specify a valid file extension.\nExport aborted.");
            return;
        }
        BufferedImage scaledImg = null;
        try {
            Expression expr = new Expression(realViewer, "renderOffscreen", new Object[]{this.antialiasing * dim.width, this.antialiasing * dim.height});
            scaledImg = (BufferedImage)expr.getValue();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        int type = this.saveAlpha ? 2 : 1;
        BufferedImage img = new BufferedImage(dim.width, dim.height, type);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, dim.width, dim.height);
        g.drawImage(scaledImg.getScaledInstance(dim.width, dim.height, 4), 0, 0, null);
        if (this.saveAlpha) {
            img.coerceData(true);
        }
        try {
            new Statement(Class.forName("de.jreality.util.ImageUtility"), "writeBufferedImage", new Object[]{file, img}).execute();
            System.out.println("Wrote file " + file.getPath());
        }
        catch (Exception ex) {
            throw new RuntimeException("writing image failed", ex);
        }
    }

    public boolean isEnabled() {
        Class<?> viewerType = this.viewer.getCurrentViewer().getClass();
        try {
            viewerType.getMethod("renderOffscreen", Integer.TYPE, Integer.TYPE);
            return true;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private JComponent createAccessory() {
        if (this.dimPanel == null) {
            this.dimPanel = new DimensionPanel();
            this.dimPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Dimension"));
            this.dimPanel.setToolTipText("Set image dimensions");
        }
        Box accessory = Box.createVerticalBox();
        accessory.add((Component)this.dimPanel);
        accessory.add(Box.createVerticalGlue());
        JPanel p = new JPanel();
        ButtonGroup bg = new ButtonGroup();
        JRadioButton button = new JRadioButton(new AbstractAction("none"){

            public void actionPerformed(ActionEvent e) {
                ExportImage.this.antialiasing = 1;
            }
        });
        bg.add(button);
        p.add(button);
        button = new JRadioButton(new AbstractAction("2x2"){

            public void actionPerformed(ActionEvent e) {
                ExportImage.this.antialiasing = 2;
            }
        });
        bg.add(button);
        p.add(button);
        button = new JRadioButton(new AbstractAction("4x4"){

            public void actionPerformed(ActionEvent e) {
                ExportImage.this.antialiasing = 4;
            }
        });
        button.setSelected(true);
        this.antialiasing = 4;
        bg.add(button);
        p.add(button);
        p.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Antialiasing factor"));
        p.setToolTipText("<html><body>Choose the factor of dimension scaling<br>for \"antialiased\" offscreen rendering</body></html>");
        accessory.add(p);
        this.checkbox = new JCheckBox(new AbstractAction("save alpha"){

            public void actionPerformed(ActionEvent e) {
                ExportImage.this.saveAlpha = ExportImage.this.checkbox.isSelected();
            }
        });
        this.checkbox.setSelected(this.saveAlpha);
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        hbox.add(this.checkbox);
        hbox.add(Box.createHorizontalGlue());
        accessory.add(hbox);
        return accessory;
    }
}

