/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.edit;

import de.jreality.scene.Appearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.TextureUtility;
import de.jreality.ui.viewerapp.FileFilter;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.actions.AbstractSelectionListenerAction;
import de.jreality.util.Input;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

public class LoadTexture
extends AbstractSelectionListenerAction {
    public LoadTexture(String name, SelectionManager sm, Component frame) {
        super(name, sm, frame);
        this.setShortDescription("Load texture");
    }

    public void actionPerformed(ActionEvent e) {
        File file = FileLoaderDialog.loadFile(this.parentComp, true, FileFilter.createImageReaderFilters());
        if (file == null) {
            return;
        }
        ImageData img = null;
        try {
            img = ImageData.load(Input.getInput(file));
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        Appearance app = null;
        if (this.getSelection().isComponent()) {
            app = this.getSelection().asComponent().getAppearance();
            if (app == null) {
                app = new Appearance();
                this.getSelection().asComponent().setAppearance(app);
            }
        } else {
            app = (Appearance)this.getSelection().asNode();
        }
        TextureUtility.createTexture(app, "polygonShader", img, false);
    }

    public boolean isEnabled(SelectionEvent e) {
        return e.componentSelected() || e.appearanceSelected();
    }
}

