/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.camera;

import de.jreality.scene.Camera;
import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.actions.camera.AbstractCameraAction;
import de.jreality.util.CameraUtility;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class ShiftFieldOfView
extends AbstractCameraAction {
    public ShiftFieldOfView(String name, Viewer v, boolean decrease) {
        super(name, v);
        this.setStep(1.0);
        if (decrease) {
            this.setStep(-this.getStep());
            this.setShortDescription("Decrease the field of view of the camera");
            this.setAcceleratorKey(KeyStroke.getKeyStroke(112, 1));
        } else {
            this.setShortDescription("Increase the field of view of the camera");
            this.setAcceleratorKey(KeyStroke.getKeyStroke(113, 1));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Camera camera = CameraUtility.getCamera(this.viewer);
        camera.setFieldOfView(camera.getFieldOfView() + this.getStep());
        this.viewer.render();
    }
}

