/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.scene.Geometry;
import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.SunflowMenu;
import de.jreality.ui.viewerapp.ViewerApp;
import de.jreality.ui.viewerapp.ViewerSwitch;
import de.jreality.ui.viewerapp.actions.AbstractSelectionListenerAction;
import de.jreality.ui.viewerapp.actions.camera.LoadCameraPreferences;
import de.jreality.ui.viewerapp.actions.camera.SaveCameraPreferences;
import de.jreality.ui.viewerapp.actions.camera.ShiftEyeSeparation;
import de.jreality.ui.viewerapp.actions.camera.ShiftFieldOfView;
import de.jreality.ui.viewerapp.actions.camera.ShiftFocus;
import de.jreality.ui.viewerapp.actions.camera.ToggleStereo;
import de.jreality.ui.viewerapp.actions.edit.AddTool;
import de.jreality.ui.viewerapp.actions.edit.AssignFaceAABBTree;
import de.jreality.ui.viewerapp.actions.edit.CreateAppearance;
import de.jreality.ui.viewerapp.actions.edit.CurrentSelection;
import de.jreality.ui.viewerapp.actions.edit.ExportOBJ;
import de.jreality.ui.viewerapp.actions.edit.LoadFileToNode;
import de.jreality.ui.viewerapp.actions.edit.LoadReflectionMap;
import de.jreality.ui.viewerapp.actions.edit.LoadTexture;
import de.jreality.ui.viewerapp.actions.edit.Remove;
import de.jreality.ui.viewerapp.actions.edit.Rename;
import de.jreality.ui.viewerapp.actions.edit.RotateReflectionMapSides;
import de.jreality.ui.viewerapp.actions.edit.SaveSelected;
import de.jreality.ui.viewerapp.actions.edit.ToggleAppearance;
import de.jreality.ui.viewerapp.actions.edit.TogglePickable;
import de.jreality.ui.viewerapp.actions.edit.ToggleVisibility;
import de.jreality.ui.viewerapp.actions.file.ExportImage;
import de.jreality.ui.viewerapp.actions.file.ExportPDF;
import de.jreality.ui.viewerapp.actions.file.ExportPS;
import de.jreality.ui.viewerapp.actions.file.ExportRIB;
import de.jreality.ui.viewerapp.actions.file.ExportSTL;
import de.jreality.ui.viewerapp.actions.file.ExportSVG;
import de.jreality.ui.viewerapp.actions.file.ExportU3D;
import de.jreality.ui.viewerapp.actions.file.ExportVRML;
import de.jreality.ui.viewerapp.actions.file.LoadFile;
import de.jreality.ui.viewerapp.actions.file.LoadScene;
import de.jreality.ui.viewerapp.actions.file.Quit;
import de.jreality.ui.viewerapp.actions.file.SaveScene;
import de.jreality.ui.viewerapp.actions.view.LoadSkyBox;
import de.jreality.ui.viewerapp.actions.view.Maximize;
import de.jreality.ui.viewerapp.actions.view.RotateSkyboxSides;
import de.jreality.ui.viewerapp.actions.view.SetViewerSize;
import de.jreality.ui.viewerapp.actions.view.SwitchBackgroundColor;
import de.jreality.ui.viewerapp.actions.view.ToggleBeanShell;
import de.jreality.ui.viewerapp.actions.view.ToggleExternalBeanShell;
import de.jreality.ui.viewerapp.actions.view.ToggleExternalNavigator;
import de.jreality.ui.viewerapp.actions.view.ToggleMenu;
import de.jreality.ui.viewerapp.actions.view.ToggleNavigator;
import de.jreality.ui.viewerapp.actions.view.ToggleRenderSelection;
import de.jreality.ui.viewerapp.actions.view.ToggleShowCursor;
import de.jreality.ui.viewerapp.actions.view.ToggleViewerFullScreen;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.Beans;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class ViewerAppMenu {
    public static String FILE_MENU = "File";
    public static String EDIT_MENU = "Edit";
    public static String CAMERA_MENU = "Camera";
    public static String VIEW_MENU = "View";
    public static String LOAD_FILE = "Load files";
    public static String LOAD_FILE_MERGED = "Load merged files";
    public static String LOAD_SCENE = "Load scene";
    public static String SAVE_SCENE = "Save scene";
    public static String EXPORT = "Export";
    public static String QUIT = "Quit";
    public static String SAVE_SELECTED = "Save selected";
    public static String LOAD_FILE_TO_NODE = "Load files into node";
    public static String REMOVE = "Remove";
    public static String RENAME = "Rename";
    public static String TOGGLE_VISIBILITY = "Toggle visibility";
    public static String ASSIGN_FACE_AABBTREE = "Assign AABBTree";
    public static String APPEARANCE = "Appearance";
    public static String CREATE_APPEARANCE = "Create new Appearance";
    public static String TOGGLE_VERTEX_DRAWING = "Toggle vertex drawing";
    public static String TOGGLE_EDGE_DRAWING = "Toggle egde drawing";
    public static String TOGGLE_FACE_DRAWING = "Toggle face drawing";
    public static String LOAD_TEXTURE = "Load texture";
    public static String REFLECTIONMAP = "Reflection map";
    public static String LOAD_REFLECTIONMAP = "Load reflection map";
    public static String ROTATE_REFLECTIONMAP_SIDES = "Rotate reflection map sides";
    public static String GEOMETRY = "Geometry";
    public static String EXPORT_OBJ = "Write OBJ";
    public static String TOGGLE_PICKABLE = "Toggle pickable";
    public static String ADD_TOOL = "Add Tools";
    public static String DECREASE_FIELD_OF_VIEW = "Decrease fieldOfView";
    public static String INCREASE_FIELD_OF_VIEW = "Increase fieldOfView";
    public static String DECREASE_FOCUS = "Decrease focus";
    public static String INCREASE_FOCUS = "Increase focus";
    public static String DECREASE_EYE_SEPARATION = "Decrease eyeSeparation";
    public static String INCREASE_EYE_SEPARATION = "Increase eyeSeparation";
    public static String TOGGLE_PERSPECTIVE = "Toggle perspective";
    public static String TOGGLE_STEREO = "Toggle stereo";
    public static String TOGGLE_CURSOR = "Toggle cursor";
    public static String LOAD_CAMERA_PREFERENCES = "Load camera preferences";
    public static String SAVE_CAMERA_PREFERENCES = "Save camera preferences";
    public static String TOGGLE_NAVIGATOR = "Show navigator";
    public static String TOGGLE_EXTERNAL_NAVIGATOR = "Open navigator in separate frame";
    public static String TOGGLE_BEANSHELL = "Show bean shell";
    public static String TOGGLE_EXTERNAL_BEANSHELL = "Open bean shell in separate frame";
    public static String TOGGLE_RENDER_SELECTION = "Show selection";
    public static String TOGGLE_MENU = "Hide menu bar";
    public static String SET_BACKGROUND_COLOR = "Set background color";
    public static String SKYBOX = "Skybox";
    public static String LOAD_SKYBOX = "Load skybox";
    public static String ROTATE_SKYBOX_SIDES = "Rotate skybox sides";
    public static String TOGGLE_VIEWER_FULL_SCREEN = "Toggle full screen";
    public static String MAXIMIZE = "Maximize frame size";
    public static String RESTORE = "Restore frame size";
    public static String SET_VIEWER_SIZE = "Set viewer size";
    private Component parentComp = null;
    private ViewerApp viewerApp = null;
    private SelectionManager sm = null;
    private Viewer viewer = null;
    private JComponent viewingComp = null;
    private JMenuBar menuBar;
    private JCheckBoxMenuItem navigatorCheckBox;
    private JCheckBoxMenuItem externalNavigatorCheckBox;
    private JCheckBoxMenuItem beanShellCheckBox;
    private JCheckBoxMenuItem externalBeanShellCheckBox;
    private JCheckBoxMenuItem renderSelectionCheckbox;
    private ExportImage exportImageAction;
    private boolean showMenuBar = true;
    private HashMap<String, Boolean> showMenu = new HashMap();

    protected ViewerAppMenu(ViewerApp v) {
        this.viewerApp = v;
        this.parentComp = v.getFrame();
        this.sm = v.getSelectionManager();
        this.viewer = v.getViewerSwitch();
        this.viewingComp = (JComponent)this.viewerApp.getViewingComponent();
        this.menuBar = new JMenuBar();
        this.addMenu(this.createFileMenu());
        JMenu editMenu = ViewerAppMenu.createEditMenu(this.parentComp, this.sm);
        editMenu.insert(new JMenuItem(new CurrentSelection(null, this.sm)), 0);
        editMenu.insertSeparator(1);
        this.addMenu(editMenu);
        this.addMenu(this.createCameraMenu());
        this.addMenu(this.createViewMenu());
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu(FILE_MENU);
        fileMenu.setMnemonic(70);
        fileMenu.add(new JMenuItem(new LoadFile(LOAD_FILE, this.sm.getDefaultSelection().getLastComponent(), this.viewer, this.parentComp)));
        fileMenu.add(new JMenuItem(new LoadScene(LOAD_SCENE, this.viewerApp)));
        fileMenu.addSeparator();
        fileMenu.add(new JMenuItem(new SaveScene(SAVE_SCENE, this.viewer, this.parentComp)));
        fileMenu.addSeparator();
        JMenu export = new JMenu(EXPORT);
        fileMenu.add(export);
        try {
            export.add(new SunflowMenu(this.viewerApp));
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggingSystem.getLogger(this).log(Level.CONFIG, "no sunflow", e);
        }
        export.add(new JMenuItem(new ExportRIB("RIB", this.viewer, this.parentComp)));
        export.add(new JMenuItem(new ExportSVG("SVG", this.viewer, this.parentComp)));
        export.add(new JMenuItem(new ExportPS("PS", this.viewer, this.parentComp)));
        export.add(new JMenuItem(new ExportVRML("VRML", this.viewer, this.parentComp)));
        export.add(new JMenuItem(new ExportSTL("STL", this.viewer, this.parentComp)));
        this.exportImageAction = new ExportImage("Image", this.viewerApp.getViewerSwitch(), this.parentComp);
        export.add(new JMenuItem(this.exportImageAction));
        export.add(new JMenuItem(new ExportU3D("U3D", this.viewer, this.parentComp)));
        export.add(new JMenuItem(new ExportPDF("PDF", this.viewer, this.parentComp)));
        if (!Beans.isDesignTime()) {
            fileMenu.addSeparator();
            fileMenu.add(new JMenuItem(new Quit(QUIT)));
        }
        return fileMenu;
    }

    protected static JMenu createEditMenu(Component parentComp, SelectionManager sm) {
        JMenu editMenu = new JMenu(EDIT_MENU);
        editMenu.setMnemonic(69);
        editMenu.add(new JMenuItem(new LoadFileToNode(LOAD_FILE_TO_NODE, sm, parentComp)));
        editMenu.add(new JMenuItem(new SaveSelected(SAVE_SELECTED, sm, parentComp)));
        editMenu.addSeparator();
        editMenu.add(new JMenuItem(new Remove(REMOVE, sm)));
        editMenu.add(new JMenuItem(new Rename(RENAME, sm, parentComp)));
        editMenu.addSeparator();
        editMenu.add(new JMenuItem(new ToggleVisibility(TOGGLE_VISIBILITY, sm)));
        editMenu.add(new JMenuItem(new AssignFaceAABBTree(ASSIGN_FACE_AABBTREE, sm)));
        editMenu.addSeparator();
        JMenu appearance = new JMenu(new AbstractSelectionListenerAction(APPEARANCE, sm){
            {
                this.setShortDescription(APPEARANCE + " options");
            }

            public void actionPerformed(ActionEvent e) {
            }

            public boolean isEnabled(SelectionEvent e) {
                return e.componentSelected() || e.appearanceSelected();
            }
        });
        editMenu.add(appearance);
        appearance.add(new JMenuItem(new CreateAppearance(CREATE_APPEARANCE, sm)));
        appearance.addSeparator();
        appearance.add(new JMenuItem(new ToggleAppearance(TOGGLE_VERTEX_DRAWING, "showPoints", sm)));
        appearance.add(new JMenuItem(new ToggleAppearance(TOGGLE_EDGE_DRAWING, "showLines", sm)));
        appearance.add(new JMenuItem(new ToggleAppearance(TOGGLE_FACE_DRAWING, "showFaces", sm)));
        appearance.addSeparator();
        appearance.add(new JMenuItem(new LoadTexture(LOAD_TEXTURE, sm, parentComp)));
        JMenu reflectionmap = new JMenu(REFLECTIONMAP);
        appearance.add(reflectionmap);
        reflectionmap.add(new JMenuItem(new LoadReflectionMap(LOAD_REFLECTIONMAP, sm, parentComp)));
        reflectionmap.add(new JMenuItem(new RotateReflectionMapSides(ROTATE_REFLECTIONMAP_SIDES, sm, parentComp)));
        JMenu geometry = new JMenu(new AbstractSelectionListenerAction(GEOMETRY, sm){
            {
                this.setShortDescription(GEOMETRY + " options");
            }

            public void actionPerformed(ActionEvent e) {
            }

            public boolean isEnabled(SelectionEvent e) {
                if (e.geometrySelected()) {
                    return true;
                }
                Geometry g = null;
                if (e.componentSelected()) {
                    g = e.getSelection().getLastComponent().getGeometry();
                }
                return g instanceof Geometry;
            }
        });
        editMenu.add(geometry);
        geometry.add(new JMenuItem(new ExportOBJ(EXPORT_OBJ, sm, parentComp)));
        geometry.add(new JMenuItem(new TogglePickable(TOGGLE_PICKABLE, sm)));
        editMenu.addSeparator();
        editMenu.add(new JMenuItem(new AddTool(ADD_TOOL, sm, parentComp)));
        return editMenu;
    }

    private JMenu createCameraMenu() {
        JMenu cameraMenu = new JMenu(CAMERA_MENU);
        cameraMenu.setMnemonic(67);
        cameraMenu.add(new JMenuItem(new ShiftFieldOfView(DECREASE_FIELD_OF_VIEW, this.viewer, true)));
        cameraMenu.add(new JMenuItem(new ShiftFieldOfView(INCREASE_FIELD_OF_VIEW, this.viewer, false)));
        cameraMenu.addSeparator();
        cameraMenu.add(new JMenuItem(new ShiftFocus(DECREASE_FOCUS, this.viewer, true)));
        cameraMenu.add(new JMenuItem(new ShiftFocus(INCREASE_FOCUS, this.viewer, false)));
        cameraMenu.addSeparator();
        cameraMenu.add(new JMenuItem(new ShiftEyeSeparation(DECREASE_EYE_SEPARATION, this.viewer, true)));
        cameraMenu.add(new JMenuItem(new ShiftEyeSeparation(INCREASE_EYE_SEPARATION, this.viewer, false)));
        cameraMenu.addSeparator();
        cameraMenu.add(new JMenuItem(new ToggleStereo(TOGGLE_STEREO, this.viewer)));
        cameraMenu.add(new JMenuItem(new ToggleShowCursor(TOGGLE_CURSOR, this.viewer)));
        cameraMenu.addSeparator();
        cameraMenu.add(new JMenuItem(new LoadCameraPreferences(LOAD_CAMERA_PREFERENCES, this.viewer)));
        cameraMenu.add(new JMenuItem(new SaveCameraPreferences(SAVE_CAMERA_PREFERENCES, this.viewer)));
        return cameraMenu;
    }

    private JMenu createViewMenu() {
        JMenu viewMenu = new JMenu(VIEW_MENU);
        viewMenu.setMnemonic(86);
        this.navigatorCheckBox = new JCheckBoxMenuItem(new ToggleNavigator(TOGGLE_NAVIGATOR, this.viewerApp));
        this.externalNavigatorCheckBox = new JCheckBoxMenuItem(new ToggleExternalNavigator(TOGGLE_EXTERNAL_NAVIGATOR, this.viewerApp));
        this.beanShellCheckBox = new JCheckBoxMenuItem(new ToggleBeanShell(TOGGLE_BEANSHELL, this.viewerApp));
        this.externalBeanShellCheckBox = new JCheckBoxMenuItem(new ToggleExternalBeanShell(TOGGLE_EXTERNAL_BEANSHELL, this.viewerApp));
        viewMenu.add(this.navigatorCheckBox);
        viewMenu.add(this.externalNavigatorCheckBox);
        viewMenu.add(this.beanShellCheckBox);
        viewMenu.add(this.externalBeanShellCheckBox);
        viewMenu.addSeparator();
        this.renderSelectionCheckbox = new JCheckBoxMenuItem(new ToggleRenderSelection(TOGGLE_RENDER_SELECTION, this.sm));
        viewMenu.add(this.renderSelectionCheckbox);
        viewMenu.add(new JMenuItem(new ToggleMenu(TOGGLE_MENU, this)));
        viewMenu.addSeparator();
        JMenu bgColors = new JMenu(SET_BACKGROUND_COLOR);
        ButtonGroup bg = new ButtonGroup();
        LinkedList<JRadioButtonMenuItem> items = new LinkedList<JRadioButtonMenuItem>();
        items.add(new JRadioButtonMenuItem(new SwitchBackgroundColor("default", this.viewerApp, ViewerApp.defaultBackgroundColor)));
        items.add(new JRadioButtonMenuItem(new SwitchBackgroundColor("white", this.viewerApp, Color.WHITE)));
        items.add(new JRadioButtonMenuItem(new SwitchBackgroundColor("gray", this.viewerApp, new Color(225, 225, 225))));
        items.add(new JRadioButtonMenuItem(new SwitchBackgroundColor("black", this.viewerApp, Color.BLACK)));
        for (JRadioButtonMenuItem item : items) {
            bg.add(item);
            bgColors.add(item);
        }
        viewMenu.add(bgColors);
        JMenu skybox = new JMenu(SKYBOX);
        viewMenu.add(skybox);
        skybox.add(new JMenuItem(new LoadSkyBox(LOAD_SKYBOX, this.viewer.getSceneRoot(), this.parentComp)));
        skybox.add(new JMenuItem(new RotateSkyboxSides(ROTATE_SKYBOX_SIDES, this.viewer.getSceneRoot(), this.parentComp)));
        viewMenu.addSeparator();
        viewMenu.add(new JMenuItem(ToggleViewerFullScreen.sharedInstance(TOGGLE_VIEWER_FULL_SCREEN, this.viewerApp)));
        viewMenu.add(new JMenuItem(Maximize.sharedInstance(MAXIMIZE, (Frame)this.parentComp)));
        viewMenu.add(new JMenuItem(new SetViewerSize(SET_VIEWER_SIZE, this.viewerApp.getViewingComponent(), (Frame)this.parentComp)));
        final ViewerSwitch viewerSwitch = this.viewerApp.getViewerSwitch();
        String[] viewerNames = viewerSwitch.getViewerNames();
        ButtonGroup bgr = new ButtonGroup();
        viewMenu.addSeparator();
        for (int i = 0; i < viewerSwitch.getNumViewers(); ++i) {
            final int index = i;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(new AbstractAction(viewerNames[index]){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent e) {
                    viewerSwitch.selectViewer(index);
                    viewerSwitch.getCurrentViewer().renderAsync();
                    if (ViewerAppMenu.this.exportImageAction != null) {
                        ViewerAppMenu.this.exportImageAction.setEnabled(ViewerAppMenu.this.exportImageAction.isEnabled());
                    }
                }
            });
            item.setSelected(index == 0);
            item.setAccelerator(KeyStroke.getKeyStroke(112 + index, 0));
            bgr.add(item);
            viewMenu.add(item);
        }
        return viewMenu;
    }

    protected static ActionMap updateActionMap(ActionMap actionMap, JMenu menu) {
        Component[] elements = menu.getMenuComponents();
        for (int i = 0; i < elements.length; ++i) {
            try {
                JMenuItem element = (JMenuItem)elements[i];
                if (element instanceof JMenu) {
                    ViewerAppMenu.updateActionMap(actionMap, (JMenu)element);
                    continue;
                }
                Action a = element.getAction();
                if (a == null || a.getValue("AcceleratorKey") == null) continue;
                actionMap.put(a.getValue("AcceleratorKey"), a);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return actionMap;
    }

    private void registerAcceleratorKey(KeyStroke key, Action a) {
        this.viewingComp.getInputMap().put(key, key);
        this.viewingComp.getActionMap().put(key, a);
    }

    private void degisterAcceleratorKey(KeyStroke key) {
        this.viewingComp.getInputMap().remove(key);
    }

    private void registerAcceleratorKeys(ActionMap actionMap) {
        Object[] keys = actionMap.keys();
        if (keys != null) {
            for (int j = 0; j < keys.length; ++j) {
                this.registerAcceleratorKey((KeyStroke)keys[j], actionMap.get(keys[j]));
            }
        }
    }

    public void update() {
        if (this.viewerApp == null) {
            return;
        }
        this.navigatorCheckBox.setSelected(this.viewerApp.isAttachNavigator());
        this.externalNavigatorCheckBox.setSelected(this.viewerApp.isExternalNavigator());
        this.beanShellCheckBox.setSelected(this.viewerApp.isAttachBeanShell());
        this.externalBeanShellCheckBox.setSelected(this.viewerApp.isExternalBeanShell());
        this.renderSelectionCheckbox.setSelected(this.sm.isRenderSelection());
        this.showMenuBar(this.viewerApp.isShowMenu());
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void addMenu(JMenu menu) {
        this.addMenu(menu, this.menuBar.getComponentCount());
    }

    public void addMenu(JMenu menu, int index) {
        this.menuBar.add((Component)menu, index);
        this.showMenu.put(menu.getText(), menu.isVisible());
        this.registerAcceleratorKeys(ViewerAppMenu.updateActionMap(menu.getActionMap(), menu));
    }

    public boolean removeMenu(String menuName) {
        JMenu menu = this.getMenu(menuName);
        if (menu != null) {
            this.menuBar.remove(menu);
            Object[] keys = menu.getActionMap().keys();
            if (keys != null) {
                for (int j = 0; j < keys.length; ++j) {
                    this.degisterAcceleratorKey((KeyStroke)keys[j]);
                }
            }
        }
        return menu != null;
    }

    public JMenu getMenu(String menuName) {
        JMenu menu = null;
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            if (this.menuBar.getMenu(i) == null || !this.menuBar.getMenu(i).getText().equals(menuName)) continue;
            menu = this.menuBar.getMenu(i);
        }
        return menu;
    }

    public boolean addMenuItem(JMenuItem item, String menuName) {
        return this.addMenuItem(item, menuName, this.menuBar.getComponentCount());
    }

    public boolean addMenuItem(JMenuItem item, String menuName, int index) {
        JMenu menu = this.getMenu(menuName);
        if (menu != null) {
            menu.insert(item, index);
            this.registerAcceleratorKeys(ViewerAppMenu.updateActionMap(menu.getActionMap(), menu));
        }
        return menu != null;
    }

    public boolean removeMenuItem(String menuName, int index) {
        JMenu menu = this.getMenu(menuName);
        if (menu != null) {
            try {
                JMenuItem item = (JMenuItem)menu.getMenuComponent(index);
                Action a = item.getAction();
                if (a != null && a.getValue("AcceleratorKey") != null) {
                    this.degisterAcceleratorKey((KeyStroke)a.getValue("AcceleratorKey"));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            menu.remove(index);
        }
        return menu != null;
    }

    public boolean addAction(Action a, String menuName) {
        int index = 0;
        JMenu menu = this.getMenu(menuName);
        if (menu == null) {
            return false;
        }
        index = menu.getMenuComponentCount();
        return this.addAction(a, menuName, index);
    }

    public boolean addAction(Action a, String menuName, int index) {
        return this.addMenuItem(new JMenuItem(a), menuName, index);
    }

    public boolean addSeparator(String menuName) {
        int index = 0;
        JMenu menu = this.getMenu(menuName);
        if (menu == null) {
            return false;
        }
        index = menu.getMenuComponentCount();
        return this.addSeparator(menuName, index);
    }

    public boolean addSeparator(String menuName, int index) {
        JMenu menu = this.getMenu(menuName);
        if (menu != null) {
            menu.insertSeparator(index);
        }
        return menu != null;
    }

    public void showMenuBar(boolean show) {
        if (this.showMenuBar == show) {
            return;
        }
        for (int i = 0; i < this.menuBar.getComponentCount(); ++i) {
            this.menuBar.getMenu(i).setVisible(show ? this.getShowMenu(this.menuBar.getMenu(i).getText()) : false);
        }
        this.showMenuBar = show;
        this.viewerApp.setShowMenu(show);
    }

    private boolean getShowMenu(String menu) {
        Boolean b = this.showMenu.get(menu);
        if (b == null) {
            b = true;
            this.showMenu.put(menu, b);
        }
        return b;
    }

    public boolean isShowMenuBar() {
        return this.showMenuBar;
    }

    public void showMenu(String menuName, boolean show) {
        if (this.getMenu(menuName) == null) {
            return;
        }
        this.getMenu(menuName).setVisible(show);
        this.showMenu.put(menuName, show);
    }

    void dispose() {
        this.menuBar.removeAll();
    }
}

